/*
 * Decompiled with CFR 0.152.
 */
package de.eibport.tools;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import de.babtec.globals.HashUtils;
import de.babtec.json.JsonUtils;
import de.eibport.net.mcast.DatagramListener;
import de.eibport.net.mcast.DatagramListenerAdapter;
import de.eibport.net.mcast.MulticastThread;
import de.eibport.net.mcast.packets.v2.BodyJSON;
import de.eibport.net.mcast.packets.v2.EpDatagram;
import de.eibport.tools.Messages;
import de.eibport.utils.Base64;
import de.eibport.utils.NetworkValidator;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseListener;
import java.net.InetAddress;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.JWindow;
import javax.swing.border.CompoundBorder;

public class NetworkConfiguration {
    public static final boolean DEBUG = true;
    final int MAX_WAIT_TIME = 5000;
    private int sernr;
    private String version;
    private MulticastThread mt;
    private JPasswordField inputEpSSHString = new JPasswordField();
    private JPasswordField inputAdminPassword = new JPasswordField();
    private JTextField inputEpName = new JTextField();
    private JCheckBox inputUseDhcp = new JCheckBox();
    private JTextField inputIPAddress = new JTextField();
    private JTextField inputNetmask = new JTextField();
    private JTextField inputGateway = new JTextField();
    private JTextField inputDnsServer1 = new JTextField();
    private JTextField inputDnsServer2 = new JTextField();
    private JTextField inputDnsServer3 = new JTextField();
    private JFrame owner;
    private MouseListener dummy = new MouseAdapter(){};
    private JWindow waitDlg;

    public NetworkConfiguration(JFrame jFrame, MulticastThread multicastThread, int n, String string) {
        this.owner = jFrame;
        this.mt = multicastThread;
        this.sernr = n;
        this.version = string;
        this.inputUseDhcp.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                NetworkConfiguration.this.checkGUI();
            }
        });
    }

    private void checkGUI() {
        boolean bl = this.inputUseDhcp.isSelected();
        this.inputIPAddress.setEnabled(!bl);
        this.inputNetmask.setEnabled(!bl);
        this.inputGateway.setEnabled(!bl);
        this.inputDnsServer1.setEnabled(!bl);
        this.inputDnsServer2.setEnabled(!bl);
        this.inputDnsServer3.setEnabled(!bl);
    }

    public void showNetworkConfiguration() {
        new Thread(){

            @Override
            public void run() {
                final JsonObject jsonObject = NetworkConfiguration.this.getNetworkParameters();
                if (jsonObject == null) {
                    return;
                }
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        NetworkConfiguration.this.openNetworkConfigurationDialog(jsonObject);
                    }
                });
            }
        }.start();
    }

    private JsonObject getNetworkParameters() {
        this.setGlassPaneVisible(true, Messages.getString("message.reading_network_properties"));
        final ParameterGetRequest parameterGetRequest = new ParameterGetRequest();
        parameterGetRequest.startRequest();
        for (int i = 0; !parameterGetRequest.isFinished() && i < 100; ++i) {
            try {
                Thread.sleep(50L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        this.setGlassPaneVisible(false, null);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!parameterGetRequest.isFinished()) {
                    parameterGetRequest.cancelRequest();
                    JOptionPane.showMessageDialog(NetworkConfiguration.this.owner, Messages.getString("message.read_no_response"));
                } else if (parameterGetRequest.getData() == null) {
                    JOptionPane.showMessageDialog(NetworkConfiguration.this.owner, Messages.getString("message.read_error_response"));
                }
            }
        });
        return parameterGetRequest.getData();
    }

    private void openNetworkConfigurationDialog(JsonObject jsonObject) {
        this.inputEpName.setText(JsonUtils.getString(jsonObject, "name", ""));
        this.inputUseDhcp.setSelected("yes".equals(JsonUtils.getString(jsonObject, "use_dhcpc", "no")));
        this.inputIPAddress.setText(JsonUtils.getString(jsonObject, "ether_ip", ""));
        this.inputNetmask.setText(JsonUtils.getString(jsonObject, "ether_nm", ""));
        this.inputGateway.setText(JsonUtils.getString(jsonObject, "default_gw", ""));
        this.inputDnsServer1.setText(JsonUtils.getString(jsonObject, "dns_server1", ""));
        this.inputDnsServer2.setText(JsonUtils.getString(jsonObject, "dns_server2", ""));
        this.inputDnsServer3.setText(JsonUtils.getString(jsonObject, "dns_server3", ""));
        this.checkGUI();
        int n = JOptionPane.showConfirmDialog(this.owner, new Object[]{Messages.getString("property.ssh_string"), this.inputEpSSHString, Messages.getString("property.admin_pw"), this.inputAdminPassword, Messages.getString("property.name"), this.inputEpName, Messages.getString("property.use_dhcp"), this.inputUseDhcp, Messages.getString("property.ip_address"), this.inputIPAddress, Messages.getString("property.subnet_mask"), this.inputNetmask, Messages.getString("property.gateway"), this.inputGateway, Messages.getString("property.dns_server") + " 1", this.inputDnsServer1, Messages.getString("property.dns_server") + " 2", this.inputDnsServer2, Messages.getString("property.dns_server") + " 3", this.inputDnsServer3}, Messages.getString("title.network_configuration"), 2);
        if (n == 0) {
            String string;
            String string2;
            String string3;
            String string4;
            String string5;
            char[] cArray = this.inputEpSSHString.getPassword();
            char[] cArray2 = this.inputAdminPassword.getPassword();
            String string6 = this.inputEpName.getText();
            String string7 = this.inputUseDhcp.isSelected() ? "yes" : "no";
            String string8 = this.inputIPAddress.getText();
            int n2 = NetworkValidator.validate(string8, string5 = this.inputNetmask.getText(), string4 = this.inputGateway.getText(), string3 = this.inputDnsServer1.getText(), string2 = this.inputDnsServer2.getText(), string = this.inputDnsServer3.getText());
            if (n2 != 0) {
                String string9 = Messages.getString("validation.unknown_error");
                switch (n2) {
                    case 1: {
                        string9 = Messages.getString("validation.ip_invalid") + ": " + string8;
                        break;
                    }
                    case 2: {
                        string9 = Messages.getString("validation.ip_restricted") + ": " + string8;
                        break;
                    }
                    case 4: {
                        string9 = Messages.getString("validation.ip_equals_network");
                        break;
                    }
                    case 3: {
                        string9 = Messages.getString("validation.ip_equals_broadcast");
                        break;
                    }
                    case 5: {
                        string9 = Messages.getString("validation.ip_reserved");
                        break;
                    }
                    case 6: {
                        string9 = Messages.getString("validation.netmask_invalid") + ": " + string5;
                        break;
                    }
                    case 7: {
                        string9 = Messages.getString("validation.gateway_invalid") + ": " + string4;
                        break;
                    }
                    case 8: {
                        string9 = Messages.getString("validation.gateway_unreachable");
                        break;
                    }
                    case 9: {
                        string9 = Messages.getString("validation.dns_invalid") + " #1 " + string3;
                        break;
                    }
                    case 10: {
                        string9 = Messages.getString("validation.dns_invalid") + " #2 " + string2;
                        break;
                    }
                    case 11: {
                        string9 = Messages.getString("validation.dns_invalid") + " #3 " + string;
                    }
                }
                JOptionPane.showMessageDialog(this.owner, Messages.getString("message.validation_error") + ": " + string9);
                this.openNetworkConfigurationDialog(jsonObject);
                return;
            }
            final JsonObject jsonObject2 = new JsonObject();
            jsonObject2.addProperty("sshString", new String(cArray));
            jsonObject2.addProperty("name", string6);
            jsonObject2.addProperty("use_dhcpc", string7);
            jsonObject2.addProperty("ether_ip", string8);
            jsonObject2.addProperty("ether_nm", string5);
            jsonObject2.addProperty("default_gw", string4);
            jsonObject2.addProperty("dns_server1", string3);
            jsonObject2.addProperty("dns_server2", string2);
            jsonObject2.addProperty("dns_server3", string);
            final String string10 = new String(cArray2);
            new Thread(){

                @Override
                public void run() {
                    try {
                        NetworkConfiguration.this.saveNetworkConfiguration(jsonObject2, string10);
                    }
                    catch (Exception exception) {
                        JOptionPane.showMessageDialog(NetworkConfiguration.this.owner, Messages.getString("message.unable_to_prep_data") + " (" + exception.getMessage() + ").");
                        exception.printStackTrace();
                    }
                }
            }.start();
        }
    }

    private void saveNetworkConfiguration(final JsonObject jsonObject, String string) throws Exception {
        System.out.println("Request: " + jsonObject.toString());
        Cipher cipher = Cipher.getInstance("AES");
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        String[] stringArray = this.version.split("\\.|-pre");
        int[] nArray = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            nArray[i] = Integer.parseInt(stringArray[i]);
        }
        String string2 = Integer.toString(this.sernr);
        string2 = "BT0000000000".substring(0, 12 - string2.length()) + string2;
        boolean bl = string2.startsWith("BT09");
        boolean bl2 = false;
        if (bl) {
            bl2 = stringArray.length >= 3 && (nArray[0] > 1 || nArray[0] == 1 && nArray[1] >= 6);
        } else {
            boolean bl3 = bl2 = stringArray.length >= 3 && (nArray[0] > 3 || nArray[0] == 3 && nArray[1] > 0 || nArray[0] == 3 && nArray[1] == 0 && nArray[2] >= 1);
        }
        if (bl2) {
            messageDigest.update(HashUtils.doHash("admin", string).getBytes(Charset.forName("ISO-8859-1")));
        } else {
            messageDigest.update(string.getBytes(Charset.forName("UTF-8")));
        }
        SecretKeySpec secretKeySpec = new SecretKeySpec(messageDigest.digest(), "AES");
        cipher.init(1, secretKeySpec);
        byte[] byArray = cipher.doFinal(jsonObject.toString().getBytes(Charset.forName("ISO-8859-1")));
        if (byArray.length > 1024) {
            System.out.println("to much data");
            return;
        }
        System.out.println("sending encrypted data: " + byArray.length);
        this.setGlassPaneVisible(true, Messages.getString("message.writing_network_properties"));
        final ParameterSetRequest parameterSetRequest = new ParameterSetRequest();
        short s = (short)(Math.random() * 32767.0);
        EpDatagram epDatagram = EpDatagram.getDatagram((short)8, (short)64, BodyJSON.setConfigurationRequest(s, this.sernr, Base64.toBase64(byArray)));
        parameterSetRequest.startRequest(epDatagram, s);
        for (int i = 0; !parameterSetRequest.isFinished() && i < 100; ++i) {
            try {
                Thread.sleep(50L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        this.setGlassPaneVisible(false, null);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!parameterSetRequest.isFinished()) {
                    parameterSetRequest.cancelRequest();
                    JOptionPane.showMessageDialog(NetworkConfiguration.this.owner, Messages.getString("message.unable_to_save"));
                    NetworkConfiguration.this.openNetworkConfigurationDialog(jsonObject);
                    return;
                }
                switch (parameterSetRequest.getErrno()) {
                    case 0: {
                        JOptionPane.showMessageDialog(NetworkConfiguration.this.owner, Messages.getString("message.saved_successfully"));
                        NetworkConfiguration.this.finished(true);
                        break;
                    }
                    case 1: {
                        JOptionPane.showMessageDialog(NetworkConfiguration.this.owner, Messages.getString("message.invalid_ssh_string"));
                        NetworkConfiguration.this.openNetworkConfigurationDialog(jsonObject);
                        break;
                    }
                    case 2: {
                        JOptionPane.showMessageDialog(NetworkConfiguration.this.owner, Messages.getString("message.wrong_admin_pw"));
                        NetworkConfiguration.this.openNetworkConfigurationDialog(jsonObject);
                        break;
                    }
                    case 3: {
                        JOptionPane.showMessageDialog(NetworkConfiguration.this.owner, Messages.getString("message.invalid_data"));
                        NetworkConfiguration.this.openNetworkConfigurationDialog(jsonObject);
                        break;
                    }
                    default: {
                        JOptionPane.showMessageDialog(NetworkConfiguration.this.owner, Messages.getString("message.unknown_error") + " (" + parameterSetRequest.getErrno() + ": " + parameterSetRequest.getMessage() + ").");
                        NetworkConfiguration.this.openNetworkConfigurationDialog(jsonObject);
                    }
                }
            }
        });
    }

    private void setGlassPaneVisible(final boolean bl, final String string) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (bl) {
                    NetworkConfiguration.this.owner.getGlassPane().setVisible(true);
                    NetworkConfiguration.this.owner.getGlassPane().addMouseListener(NetworkConfiguration.this.dummy);
                    if (NetworkConfiguration.this.waitDlg != null) {
                        return;
                    }
                    NetworkConfiguration.this.waitDlg = new JWindow(NetworkConfiguration.this.owner);
                    NetworkConfiguration.this.waitDlg.getContentPane().setLayout(new BorderLayout());
                    JLabel jLabel = new JLabel(string);
                    jLabel.setBorder(new CompoundBorder(BorderFactory.createLineBorder(Color.black), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
                    NetworkConfiguration.this.waitDlg.getContentPane().add((Component)jLabel, "Center");
                    NetworkConfiguration.this.waitDlg.pack();
                    NetworkConfiguration.this.waitDlg.setLocationRelativeTo(NetworkConfiguration.this.owner);
                    NetworkConfiguration.this.waitDlg.setAlwaysOnTop(true);
                    NetworkConfiguration.this.waitDlg.setVisible(true);
                } else {
                    NetworkConfiguration.this.owner.getGlassPane().setVisible(false);
                    NetworkConfiguration.this.owner.getGlassPane().removeMouseListener(NetworkConfiguration.this.dummy);
                    NetworkConfiguration.this.waitDlg.setVisible(false);
                    NetworkConfiguration.this.waitDlg = null;
                }
            }
        });
    }

    protected void finished(boolean bl) {
    }

    class ParameterGetRequest {
        private JsonObject data = null;
        private boolean finished = false;
        private DatagramListener listener;

        ParameterGetRequest() {
        }

        public void startRequest() {
            final short s = (short)(Math.random() * 32767.0);
            JsonArray jsonArray = new JsonArray();
            jsonArray.add(new JsonPrimitive("name"));
            jsonArray.add(new JsonPrimitive("use_dhcpc"));
            jsonArray.add(new JsonPrimitive("ether_ip"));
            jsonArray.add(new JsonPrimitive("ether_nm"));
            jsonArray.add(new JsonPrimitive("default_gw"));
            jsonArray.add(new JsonPrimitive("dns_server1"));
            jsonArray.add(new JsonPrimitive("dns_server2"));
            jsonArray.add(new JsonPrimitive("dns_server3"));
            this.listener = new DatagramListenerAdapter(){

                @Override
                public void receivedJSON(EpDatagram epDatagram, InetAddress inetAddress, int n) {
                    BodyJSON bodyJSON;
                    if (epDatagram.getBody() instanceof BodyJSON && (bodyJSON = (BodyJSON)epDatagram.getBody()).checkCommand("getConfiguration") && bodyJSON.checkInvokeId(s)) {
                        if (bodyJSON.checkType("response")) {
                            NetworkConfiguration.this.mt.removeListener(this);
                            ParameterGetRequest.this.data = bodyJSON.getJSON().getAsJsonObject("data");
                            System.out.println("got answer: " + ParameterGetRequest.this.data.toString());
                            ParameterGetRequest.this.finished = true;
                        } else if (bodyJSON.checkType("message")) {
                            NetworkConfiguration.this.mt.removeListener(this);
                            ParameterGetRequest.this.finished = true;
                        }
                    }
                }
            };
            NetworkConfiguration.this.mt.addListener(this.listener);
            System.out.println("sending mcast config request");
            NetworkConfiguration.this.mt.sendBytes(EpDatagram.getDatagram((short)8, (short)64, BodyJSON.getConfigurationRequest(s, NetworkConfiguration.this.sernr, jsonArray)).getBytes());
        }

        public void cancelRequest() {
            NetworkConfiguration.this.mt.removeListener(this.listener);
        }

        public boolean isFinished() {
            return this.finished;
        }

        public JsonObject getData() {
            return this.data;
        }
    }

    class ParameterSetRequest {
        private int errno = -1;
        private String message = null;
        private boolean finished = false;
        private DatagramListener listener;

        ParameterSetRequest() {
        }

        public void startRequest(EpDatagram epDatagram, final int n) {
            this.listener = new DatagramListenerAdapter(){

                @Override
                public void receivedJSON(EpDatagram epDatagram, InetAddress inetAddress, int n2) {
                    BodyJSON bodyJSON;
                    if (epDatagram.getBody() instanceof BodyJSON && (bodyJSON = (BodyJSON)epDatagram.getBody()).checkCommand("setConfiguration") && bodyJSON.checkInvokeId(n) && bodyJSON.checkType("message")) {
                        System.out.println("finished ParameterSetRequest");
                        NetworkConfiguration.this.mt.removeListener(this);
                        ParameterSetRequest.this.errno = JsonUtils.getInt(bodyJSON.getJSON(), "msg_no", -1);
                        ParameterSetRequest.this.message = JsonUtils.getString(bodyJSON.getJSON(), "msg", "");
                        ParameterSetRequest.this.finished = true;
                    }
                }
            };
            NetworkConfiguration.this.mt.addListener(this.listener);
            NetworkConfiguration.this.mt.sendBytes(epDatagram.getBytes());
        }

        public void cancelRequest() {
            NetworkConfiguration.this.mt.removeListener(this.listener);
        }

        public boolean isFinished() {
            return this.finished;
        }

        public String getMessage() {
            return this.message;
        }

        public int getErrno() {
            return this.errno;
        }
    }
}

