/*
 * Decompiled with CFR 0.152.
 */
package de.babtec.themes;

import de.eibport.themes.model.Theme;
import java.awt.Color;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ColorDialog_EditVisu {
    private JComboBox cbPageBg = new JComboBox();
    private JButton labelPageBg1;
    private JButton labelPageBg2;
    private JComboBox cbObjBg;
    private JButton labelObjBg1;
    private JButton labelObjBg2;
    private JButton labelObjFg1;
    private JButton labelObjFg2;
    private JComboBox cbObjBorder;
    private JButton labelObjBorderColor;
    private JSpinner spinnerCornerWidth;
    private JSpinner spinnerCornerRadius;
    private Frame currentOwner;
    private Theme currentTheme;

    public ColorDialog_EditVisu() {
        this.cbPageBg.addItem("Solid");
        this.cbPageBg.addItem("Gradient");
        this.cbPageBg.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ColorDialog_EditVisu.this.currentTheme.setProperty("pageBgType", ColorDialog_EditVisu.this.cbPageBg.getSelectedIndex() + 1);
                ColorDialog_EditVisu.this.checkGui();
            }
        });
        this.labelPageBg1 = this.getColorLabel("pageBgColor1");
        this.labelPageBg2 = this.getColorLabel("pageBgColor2");
        this.cbObjBg = new JComboBox();
        this.cbObjBg.addItem("None");
        this.cbObjBg.addItem("Solid");
        this.cbObjBg.addItem("Gradient");
        this.cbObjBg.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ColorDialog_EditVisu.this.currentTheme.setProperty("objectBgType", ColorDialog_EditVisu.this.cbObjBg.getSelectedIndex());
                ColorDialog_EditVisu.this.checkGui();
            }
        });
        this.labelObjBg1 = this.getColorLabel("objectBgColor1");
        this.labelObjBg2 = this.getColorLabel("objectBgColor2");
        this.labelObjFg1 = this.getColorLabel("objectFgColor1");
        this.labelObjFg2 = this.getColorLabel("objectFgColor2");
        this.cbObjBorder = new JComboBox();
        this.cbObjBorder.addItem("None");
        this.cbObjBorder.addItem("Auto");
        this.cbObjBorder.addItem("Line");
        this.cbObjBorder.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ColorDialog_EditVisu.this.currentTheme.setProperty("objectBorderType", ColorDialog_EditVisu.this.cbObjBorder.getSelectedIndex());
                ColorDialog_EditVisu.this.checkGui();
            }
        });
        this.labelObjBorderColor = this.getColorLabel("objectBorderColor");
        this.spinnerCornerWidth = new JSpinner(new SpinnerNumberModel(0, 0, 10, 1));
        this.spinnerCornerWidth.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ColorDialog_EditVisu.this.currentTheme.setProperty("objectBorderWidth", (Integer)ColorDialog_EditVisu.this.spinnerCornerWidth.getValue());
            }
        });
        this.spinnerCornerRadius = new JSpinner(new SpinnerNumberModel(0, 0, 50, 1));
        this.spinnerCornerRadius.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ColorDialog_EditVisu.this.currentTheme.setProperty("objectBorderRadius", (Integer)ColorDialog_EditVisu.this.spinnerCornerRadius.getValue());
            }
        });
    }

    private void checkGui() {
        switch (this.cbPageBg.getSelectedIndex() + 1) {
            case 1: {
                this.labelPageBg1.setEnabled(true);
                this.labelPageBg2.setEnabled(false);
                break;
            }
            case 2: {
                this.labelPageBg1.setEnabled(true);
                this.labelPageBg2.setEnabled(true);
            }
        }
        switch (this.cbObjBg.getSelectedIndex()) {
            case 0: {
                this.labelObjBg1.setEnabled(false);
                this.labelObjBg2.setEnabled(false);
                break;
            }
            case 1: {
                this.labelObjBg1.setEnabled(true);
                this.labelObjBg2.setEnabled(false);
                break;
            }
            case 2: {
                this.labelObjBg1.setEnabled(true);
                this.labelObjBg2.setEnabled(true);
            }
        }
        switch (this.cbObjBorder.getSelectedIndex()) {
            case 2: {
                this.labelObjBorderColor.setEnabled(true);
                this.spinnerCornerWidth.setEnabled(true);
                this.spinnerCornerRadius.setEnabled(true);
                break;
            }
            default: {
                this.labelObjBorderColor.setEnabled(false);
                this.spinnerCornerWidth.setEnabled(false);
                this.spinnerCornerRadius.setEnabled(false);
            }
        }
    }

    private JButton getColorLabel(String key) {
        final String colorKey = key;
        final JButton colorLabel = new JButton("click");
        colorLabel.setOpaque(true);
        colorLabel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color ret = ColorDialog_EditVisu.this.getColor(colorLabel.getBackground());
                if (ret != null) {
                    ColorDialog_EditVisu.this.currentTheme.setPropertyColor(colorKey, ret);
                    colorLabel.setBackground(ret);
                }
            }
        });
        return colorLabel;
    }

    private Color getColor(Color initialColor) {
        return JColorChooser.showDialog(this.currentOwner, "Choose Color", initialColor);
    }

    public void showDialog(Theme theme, Frame owner) {
        this.currentOwner = owner;
        this.currentTheme = theme;
        int index = this.currentTheme.getPropertyInt("pageBgType", 1);
        this.cbPageBg.setSelectedIndex(Math.min(index - 1, this.cbPageBg.getItemCount() - 1));
        Color col = this.currentTheme.getPropertyColor("pageBgColor1", new Color(0xE6E6FF));
        this.labelPageBg1.setBackground(col != null ? col : new Color(0xE6E6FF));
        col = this.currentTheme.getPropertyColor("pageBgColor2", new Color(0x2A2A2A));
        this.labelPageBg2.setBackground(col != null ? col : new Color(0x2A2A2A));
        index = this.currentTheme.getPropertyInt("objectBgType", 2);
        this.cbObjBg.setSelectedIndex(Math.min(index, this.cbPageBg.getItemCount()));
        col = this.currentTheme.getPropertyColor("objectBgColor1", new Color(0xAAAAAA));
        this.labelObjBg1.setBackground(col);
        col = this.currentTheme.getPropertyColor("objectBgColor2", new Color(0xCCCCCC));
        this.labelObjBg2.setBackground(col);
        index = this.currentTheme.getPropertyInt("objectBorderType", 1);
        this.cbObjBorder.setSelectedIndex(Math.min(index, this.cbObjBorder.getItemCount()));
        col = this.currentTheme.getPropertyColor("objectBorderColor", new Color(0xAAAAAA));
        this.labelObjBorderColor.setBackground(col);
        int width = this.currentTheme.getPropertyInt("objectBorderWidth", 1);
        this.spinnerCornerWidth.setValue(width);
        int radius = this.currentTheme.getPropertyInt("objectBorderRadius", 0);
        this.spinnerCornerRadius.setValue(radius);
        col = this.currentTheme.getPropertyColor("objectFgColor1", new Color(0xEEEEEE));
        this.labelObjFg1.setBackground(col);
        col = this.currentTheme.getPropertyColor("objectFgColor2", new Color(238));
        this.labelObjFg2.setBackground(col);
        this.checkGui();
        Object[] obj = new Object[]{new JLabel("Page Background"), this.cbPageBg, new JLabel("Page Background Color #1 (top)"), this.labelPageBg1, new JLabel("Page Background Color #2 (bottom)"), this.labelPageBg2, new JSeparator(), new JLabel("Object Background"), this.cbObjBg, new JLabel("Object Background Color #1 (top)"), this.labelObjBg1, new JLabel("Object Background Color #2 (bottom)"), this.labelObjBg2, new JSeparator(), new JLabel("Object Border"), this.cbObjBorder, new JLabel("Object Border Color"), this.labelObjBorderColor, new JLabel("Object Border Width"), this.spinnerCornerWidth, new JLabel("Object Border Radius"), this.spinnerCornerRadius, new JSeparator(), new JLabel("Object Foreground1"), this.labelObjFg1, new JLabel("Object Foreground2"), this.labelObjFg2};
        JOptionPane.showMessageDialog(this.currentOwner, obj, "Style Colors", 3);
    }
}

