/*
 * Decompiled with CFR 0.152.
 */
package de.babtec.themes;

import de.eibport.themes.model.AbstractThemeObject;
import de.eibport.themes.model.Theme;
import de.eibport.themes.model.ThemeCategory;
import de.eibport.themes.model.ThemeItem;
import de.eibport.themes.model.ThemeSet;
import info.clearthought.layout.TableLayout;
import info.clearthought.layout.TableLayoutConstraints;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.prefs.Preferences;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class ThemeEditPane
extends JPanel {
    public static final String PREF_LAST_ICON_DIR = "lastIconDirectory";
    private Theme currentTheme;
    private JTree tree;
    private DefaultTreeModel dtm;
    private DefaultMutableTreeNode root;
    private JPanel content;
    private JScrollPane scrollContent;
    private HashMap<String, JComponent> categories = new HashMap();
    private JFileChooser fc;
    private Preferences preferences = Preferences.userNodeForPackage(ThemeEditPane.class);
    private JPanel catPanel = null;
    private JPanel setPanel = null;

    public ThemeEditPane() {
        this.root = new DefaultMutableTreeNode();
        this.dtm = new DefaultTreeModel(this.root);
        this.tree = new JTree(this.dtm);
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                JComponent cmp;
                TreePath tp = e.getNewLeadSelectionPath();
                if (tp == null || !(tp.getLastPathComponent() instanceof DefaultMutableTreeNode)) {
                    return;
                }
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)tp.getLastPathComponent();
                if (node.getUserObject() instanceof ThemeCategory && (cmp = (JComponent)ThemeEditPane.this.categories.get(((ThemeCategory)node.getUserObject()).getTitle())) != null) {
                    ThemeEditPane.this.scrollContent.getViewport().setViewPosition(cmp.getLocation());
                }
            }
        });
        this.setLayout(new BorderLayout());
        this.content = new JPanel();
        this.content.setBackground(Color.DARK_GRAY);
        this.content.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        this.content.setLayout(new BoxLayout(this.content, 1));
        this.scrollContent = new JScrollPane(this.content, 22, 30);
        this.scrollContent.getVerticalScrollBar().setUnitIncrement(20);
        JSplitPane split = new JSplitPane(1, new JScrollPane(this.tree), this.scrollContent);
        split.setDividerLocation(270);
        this.add((Component)split, "Center");
    }

    public void setTheme(Theme thm) {
        this.currentTheme = thm;
        this.content.removeAll();
        this.root.removeAllChildren();
        this.root.setUserObject(thm);
        this.addThemeObjects(this.root, thm);
        this.dtm.reload();
        this.content.revalidate();
    }

    public Theme getTheme() {
        return this.currentTheme;
    }

    private void addThemeObjects(DefaultMutableTreeNode parent, AbstractThemeObject parentObj) {
        AbstractThemeObject[] abstractThemeObjectArray = parentObj.getChildObjects();
        int n = abstractThemeObjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractThemeObject obj = abstractThemeObjectArray[n2];
            if (obj instanceof ThemeCategory) {
                this.content.add(Box.createVerticalStrut(20));
                this.catPanel = new JPanel();
                this.catPanel.setBorder(BorderFactory.createLineBorder(Color.GRAY, 2));
                this.catPanel.setLayout(new BoxLayout(this.catPanel, 3));
                this.catPanel.setAlignmentX(0.5f);
                this.catPanel.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
                JLabel label = new JLabel(obj.getTitle(), 0);
                label.setAlignmentX(0.5f);
                label.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
                label.setOpaque(true);
                label.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.BLACK), BorderFactory.createEmptyBorder(3, 3, 3, 3)));
                label.setBackground(new Color(0xDDDDFF));
                Font font = new Font(label.getFont().getFamily(), 1, 15);
                label.setFont(font);
                this.catPanel.add(label);
                this.content.add(this.catPanel);
                this.categories.put(((ThemeCategory)obj).getTitle(), this.catPanel);
                DefaultMutableTreeNode dtm = new DefaultMutableTreeNode(obj);
                parent.add(dtm);
                this.addThemeObjects(dtm, obj);
            }
            if (obj instanceof ThemeSet) {
                ThemeSet ts = (ThemeSet)obj;
                Integer[] integerArray = ts.getSetKeys();
                int n3 = integerArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    int index = integerArray[n4];
                    this.addThemeSet(ts, index);
                    ++n4;
                }
            }
            if (obj instanceof ThemeItem) {
                this.addThemeItem((ThemeItem)obj, -1);
            }
            ++n2;
        }
    }

    private void addThemeSet(final ThemeSet ts, final int setIndex) {
        this.setPanel = new JPanel();
        this.setPanel.setBorder(BorderFactory.createTitledBorder(ts.getSetTitle(setIndex)));
        this.setPanel.setLayout(new BoxLayout(this.setPanel, 3));
        this.setPanel.setAlignmentX(0.5f);
        this.setPanel.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        JPanel tb = new JPanel(new FlowLayout(0));
        this.setPanel.add(tb);
        if (setIndex == 0) {
            tb.add(new JButton(new AbstractAction("Add New Set"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int newKey = 1;
                    while (ts.containsKey(newKey)) {
                        ++newKey;
                    }
                    String setName = "Set " + newKey;
                    while ((setName = JOptionPane.showInputDialog("Insert title for new set!", (Object)setName)).trim().length() == 0 && setName != null) {
                    }
                    ts.addSet(newKey, setName);
                    ThemeEditPane.this.setTheme(ThemeEditPane.this.currentTheme);
                }
            }));
        } else if (ts.isRemovable()) {
            tb.add(new JButton(new AbstractAction("Remove This Set"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ts.removeSet(setIndex);
                    ThemeEditPane.this.setTheme(ThemeEditPane.this.currentTheme);
                }
            }));
        }
        this.catPanel.add(this.setPanel);
        ThemeItem[] themeItemArray = ts.getChildItems();
        int n = themeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            ThemeItem item = themeItemArray[n2];
            this.addThemeItem(item, setIndex);
            ++n2;
        }
        this.setPanel = null;
    }

    private void addThemeItem(ThemeItem item, int setIndex) {
        ThemeItemEditPane tiep = new ThemeItemEditPane(item, setIndex);
        if (this.setPanel != null) {
            this.setPanel.add(tiep);
        } else {
            this.catPanel.add(tiep);
        }
    }

    class ThemeItemEditPane
    extends JPanel {
        private ThemeItem item;
        private int setIndex = -1;
        private JLabel icon;
        private JLabel title;
        private JLabel desc;
        private JLabel dimensions;
        private JLabel format;
        private JButton btnExport;
        private JButton btnReplace;

        public ThemeItemEditPane(ThemeItem item, int setIndex) {
            this.item = item;
            this.setIndex = setIndex;
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1), BorderFactory.createLineBorder(Color.LIGHT_GRAY)));
            this.icon = new JLabel(item.getIcon(setIndex)){

                @Override
                protected void paintComponent(Graphics g) {
                    if (this.getIcon() != null && this.getIcon() instanceof ImageIcon) {
                        double fh;
                        Image img = ((ImageIcon)this.getIcon()).getImage();
                        float w = img.getWidth(this);
                        float h = img.getHeight(this);
                        double fw = (float)this.getWidth() / w;
                        double factor = Math.min(fw, fh = (double)((float)this.getHeight() / h));
                        if (factor < 1.0) {
                            w = (float)((double)w * factor);
                            h = (float)((double)h * factor);
                        }
                        g.drawImage(img, (int)((float)this.getWidth() - w) / 2, (int)((float)this.getHeight() - h) / 2, (int)w, (int)h, this);
                    } else {
                        super.paintComponent(g);
                    }
                }
            };
            this.icon.setPreferredSize(new Dimension(80, 80));
            this.title = new JLabel(item.getTitle());
            this.title.setFont(this.title.getFont().deriveFont(1));
            this.desc = new JLabel(item.getDesc());
            this.dimensions = new JLabel("Size: " + item.getWidth() + "x" + item.getHeight() + "px");
            this.dimensions.setFont(this.dimensions.getFont().deriveFont(1));
            this.format = new JLabel();
            TableLayout tl = new TableLayout(new double[]{120.0, -1.0, 120.0, 120.0}, new double[]{-2.0, -2.0});
            this.setLayout((LayoutManager)tl);
            this.add((Component)this.icon, "0,0,0,1");
            this.add((Component)this.title, "1,0");
            this.add((Component)this.desc, "1,1,2,0");
            this.add((Component)this.dimensions, "2,0");
            if (item.isExportAllowed()) {
                this.btnExport = new JButton(new AbstractAction("Export"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ThemeItemEditPane.this.export();
                    }
                });
                this.add((Component)this.btnExport, new TableLayoutConstraints(3, 0, 3, 0, 2, 1));
            }
            if (item.isReplaceAllowed()) {
                this.btnReplace = new JButton(new AbstractAction("Replace"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ThemeItemEditPane.this.replace();
                    }
                });
                this.add((Component)this.btnReplace, new TableLayoutConstraints(3, 1, 3, 1, 2, 1));
            }
        }

        private void export() {
            if (ThemeEditPane.this.fc == null) {
                ThemeEditPane.this.fc = new JFileChooser(ThemeEditPane.this.preferences.get(ThemeEditPane.PREF_LAST_ICON_DIR, null));
            }
            ThemeEditPane.this.fc.setFileFilter(null);
            String filename = String.valueOf(this.item.getKey()) + this.item.getExtension(this.setIndex);
            ThemeEditPane.this.fc.setName(this.item.getTitle());
            ThemeEditPane.this.fc.setSelectedFile(new File(filename));
            int ret = ThemeEditPane.this.fc.showSaveDialog(this);
            if (ret == 0) {
                try {
                    File f = ThemeEditPane.this.fc.getSelectedFile();
                    ThemeEditPane.this.preferences.put(ThemeEditPane.PREF_LAST_ICON_DIR, f.getAbsolutePath());
                    FileOutputStream fos = new FileOutputStream(f);
                    fos.write(this.item.getImageData(this.setIndex));
                    fos.flush();
                    fos.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        private void replace() {
            if (ThemeEditPane.this.fc == null) {
                ThemeEditPane.this.fc = new JFileChooser(ThemeEditPane.this.preferences.get(ThemeEditPane.PREF_LAST_ICON_DIR, null));
            }
            ThemeEditPane.this.fc.setFileFilter(new FileFilter(){

                @Override
                public String getDescription() {
                    return "Images (.gif; .png)";
                }

                @Override
                public boolean accept(File f) {
                    return f.isDirectory() || f.getName().endsWith(".gif") || f.getName().endsWith(".png");
                }
            });
            int ret = ThemeEditPane.this.fc.showOpenDialog(this);
            if (ret == 0) {
                File f = ThemeEditPane.this.fc.getSelectedFile();
                ThemeEditPane.this.preferences.put(ThemeEditPane.PREF_LAST_ICON_DIR, f.getAbsolutePath());
                try {
                    long len = f.length();
                    if (len > Integer.MAX_VALUE) {
                        throw new IOException("File is too big (>2147483647 Bytes)");
                    }
                    byte[] buf = new byte[(int)len];
                    int offset = 0;
                    int numRead = 0;
                    FileInputStream is = new FileInputStream(f);
                    while (offset < buf.length && (numRead = ((InputStream)is).read(buf, offset, buf.length - offset)) >= 0) {
                        offset += numRead;
                    }
                    ((InputStream)is).close();
                    if (offset < buf.length) {
                        throw new IOException("Could not completely read file " + f.getName());
                    }
                    BufferedImage bimg = ImageIO.read(new ByteArrayInputStream(buf));
                    boolean scale = false;
                    if (bimg.getWidth() != this.item.getWidth() || bimg.getHeight() != this.item.getHeight()) {
                        ret = JOptionPane.showConfirmDialog(this, "<html>Shall the image be scaled to recommended size (" + this.item.getWidth() + "x" + this.item.getHeight() + ")?<br>" + "The image will be saved as PNG. Animations (in gif format) will be lost.</html>", "Replace Image", 1);
                        if (ret == 2) {
                            return;
                        }
                        boolean bl = scale = ret == 0;
                    }
                    if (scale) {
                        double fh;
                        float w = bimg.getWidth();
                        float h = bimg.getHeight();
                        double fw = (float)this.item.getWidth() / w;
                        double factor = Math.min(fw, fh = (double)((float)this.item.getHeight() / h));
                        if (factor < 1.0) {
                            w = (float)((double)w * factor);
                            h = (float)((double)h * factor);
                        }
                        Image img = bimg.getScaledInstance((int)w, (int)h, 4);
                        bimg.flush();
                        bimg = new BufferedImage(this.item.getWidth(), this.item.getHeight(), 2);
                        bimg.getGraphics().drawImage(img, (int)(((float)this.item.getWidth() - w) / 2.0f), (int)(((float)this.item.getHeight() - h) / 2.0f), (int)w, (int)h, this);
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        ImageIO.write((RenderedImage)bimg, "png", baos);
                        buf = baos.toByteArray();
                    }
                    String name = f.getAbsolutePath();
                    this.item.setImageData(buf, this.setIndex, name.substring(name.lastIndexOf(46)));
                    this.icon.setIcon(this.item.getIcon(this.setIndex));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

