/*
 * Decompiled with CFR 0.152.
 */
package de.babtec.themes;

import de.babtec.themes.ColorDialog_EditVisu;
import de.babtec.themes.ColorDialog_HIC;
import de.babtec.themes.ThemeEditPane;
import de.eibport.themes.ThemeGlobals;
import de.eibport.themes.ThemeGlobalsInfo;
import de.eibport.themes.io.ThemeLoader;
import de.eibport.themes.model.Theme;
import de.eibport.themes.security.ThemeProtection;
import de.eibport.themes.security.ThemeProtectionException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.ResourceBundle;
import java.util.prefs.Preferences;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.filechooser.FileFilter;
import org.jdom.JDOMException;

public class ThemeEditor
extends JFrame {
    public static final String PREF_LAST_THEME_DIR = "lastThemeDirectory";
    public static ResourceBundle messages;
    private ThemeEditPane tep;
    private JFileChooser fc;
    private FileFilter ff_default = new FileFilter(){

        @Override
        public String getDescription() {
            return messages.getString("ThemeEditor.file_filter.theme");
        }

        @Override
        public boolean accept(File f) {
            return f.isDirectory() || f.getName().toLowerCase().endsWith(".thm");
        }
    };
    private FileFilter ff_encrypted = new FileFilter(){

        @Override
        public String getDescription() {
            return messages.getString("ThemeEditor.file_filter.enc_theme");
        }

        @Override
        public boolean accept(File f) {
            return f.isDirectory() || f.getName().toLowerCase().endsWith(".thx");
        }
    };
    private Preferences preferences = Preferences.userNodeForPackage(ThemeEditor.class);
    private AbstractAction actDownloadTheme;
    private AbstractAction actOpenTheme;
    private AbstractAction actSaveTheme;
    private AbstractAction actLoadEncryptedTheme;
    private AbstractAction actSaveEncryptedTheme;
    private AbstractAction actEditTheme;
    private AbstractAction actEditThemeColors;
    private ThemeProtection themeProtection = new ThemeProtection();

    public ThemeEditor() {
        super(messages.getString("ThemeEditor.title"));
        try {
            BufferedImage img = ImageIO.read(this.getClass().getResource("epIcon26x26.gif"));
            this.setIconImage(img);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.setDefaultCloseOperation(3);
        this.createMenuBar();
        Container cp = this.getContentPane();
        cp.setLayout(new BorderLayout());
        this.tep = new ThemeEditPane();
        cp.add((Component)this.tep, "Center");
        this.setSize(1000, 600);
    }

    private void createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu(messages.getString("ThemeEditor.menu.file"));
        this.actDownloadTheme = new AbstractAction(messages.getString("ThemeEditor.menu.download_theme")){

            @Override
            public void actionPerformed(ActionEvent e) {
                JTextField inputAddress = new JTextField();
                JSpinner inputPortHttp = new JSpinner(new SpinnerNumberModel(80, 1, 65535, 1));
                int ret = 0;
                boolean success = false;
                while (ret == 0 && !success) {
                    ret = JOptionPane.showConfirmDialog(ThemeEditor.this, new Object[]{messages.getString("ThemeEditor.download.host"), inputAddress, messages.getString("ThemeEditor.download.port"), inputPortHttp}, messages.getString("ThemeEditor.menu.download_theme"), 2);
                    if (ret != 0) continue;
                    try {
                        URL baseUrl = new URL("http", inputAddress.getText(), (Integer)inputPortHttp.getValue(), "/");
                        ThemeEditor.this.download(baseUrl);
                        success = true;
                    }
                    catch (MalformedURLException e1) {
                        e1.printStackTrace();
                    }
                    catch (FileNotFoundException e1) {
                        JOptionPane.showMessageDialog(ThemeEditor.this, messages.getString("ThemeEditor.error.no_themes"), messages.getString("ThemeEditor.error.title"), 0);
                    }
                    catch (IOException e1) {
                        JOptionPane.showMessageDialog(ThemeEditor.this, messages.getString("ThemeEditor.error.unable_to_connect"), messages.getString("ThemeEditor.error.title"), 0);
                    }
                    catch (JDOMException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        };
        this.actOpenTheme = new AbstractAction(messages.getString("ThemeEditor.menu.open_theme")){

            @Override
            public void actionPerformed(ActionEvent e) {
                ThemeEditor.this.createFileChooser();
                ThemeEditor.this.fc.setFileFilter(ThemeEditor.this.ff_default);
                int ret = ThemeEditor.this.fc.showOpenDialog(ThemeEditor.this);
                if (ret == 0) {
                    File f = ThemeEditor.this.fc.getSelectedFile();
                    ThemeEditor.this.preferences.put(ThemeEditor.PREF_LAST_THEME_DIR, f.getAbsolutePath());
                    try {
                        FileInputStream is = new FileInputStream(f);
                        Theme thm = ThemeLoader.loadTheme(is, false);
                        thm.setLastChanged(System.currentTimeMillis());
                        ThemeEditor.this.tep.setTheme(thm);
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        JOptionPane.showMessageDialog(ThemeEditor.this, messages.getString("ThemeEditor.error.unable_to_open"));
                    }
                }
            }
        };
        this.actSaveTheme = new AbstractAction(messages.getString("ThemeEditor.menu.save_theme")){

            @Override
            public void actionPerformed(ActionEvent e) {
                ThemeEditor.this.createFileChooser();
                ThemeEditor.this.fc.setFileFilter(ThemeEditor.this.ff_default);
                int ret = ThemeEditor.this.fc.showSaveDialog(ThemeEditor.this);
                if (ret == 0) {
                    File f = ThemeEditor.this.fc.getSelectedFile();
                    if (!f.getAbsoluteFile().toString().toLowerCase().endsWith(".thm")) {
                        f = new File(String.valueOf(f.getAbsoluteFile().toString()) + ".thm");
                    }
                    ThemeEditor.this.preferences.put(ThemeEditor.PREF_LAST_THEME_DIR, f.getAbsolutePath());
                    try {
                        FileOutputStream os = new FileOutputStream(f);
                        Theme thm = ThemeEditor.this.tep.getTheme();
                        byte[] buf = ThemeLoader.saveTheme(thm);
                        os.write(buf);
                        os.flush();
                        os.close();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
            }
        };
        this.actLoadEncryptedTheme = new AbstractAction(messages.getString("ThemeEditor.menu.open_enc_theme")){

            @Override
            public void actionPerformed(ActionEvent e) {
                ThemeEditor.this.createFileChooser();
                ThemeEditor.this.fc.setFileFilter(ThemeEditor.this.ff_encrypted);
                int ret = ThemeEditor.this.fc.showOpenDialog(ThemeEditor.this);
                if (ret == 0) {
                    File f = ThemeEditor.this.fc.getSelectedFile();
                    ThemeEditor.this.preferences.put(ThemeEditor.PREF_LAST_THEME_DIR, f.getAbsolutePath());
                    ThemeEditor.this.loadEncryptedTheme(f);
                }
            }
        };
        this.actSaveEncryptedTheme = new AbstractAction(messages.getString("ThemeEditor.menu.save_enc_theme")){

            @Override
            public void actionPerformed(ActionEvent e) {
                ThemeEditor.this.createFileChooser();
                ThemeEditor.this.fc.setFileFilter(ThemeEditor.this.ff_encrypted);
                int ret = ThemeEditor.this.fc.showSaveDialog(ThemeEditor.this);
                if (ret == 0) {
                    File f = ThemeEditor.this.fc.getSelectedFile();
                    if (!f.getAbsoluteFile().toString().toLowerCase().endsWith(".thx")) {
                        f = new File(String.valueOf(f.getAbsoluteFile().toString()) + ".thx");
                    }
                    ThemeEditor.this.preferences.put(ThemeEditor.PREF_LAST_THEME_DIR, f.getAbsolutePath());
                    ThemeEditor.this.saveEncryptedTheme(f);
                }
            }
        };
        this.actEditTheme = new AbstractAction(messages.getString("ThemeEditor.edit.info")){

            @Override
            public void actionPerformed(ActionEvent e) {
                ThemeEditor.this.showThemeInformation();
            }
        };
        this.actEditThemeColors = new AbstractAction(messages.getString("ThemeEditor.edit.colors")){

            @Override
            public void actionPerformed(ActionEvent e) {
                ThemeEditor.this.showThemeColors();
            }
        };
        menu.add(this.actDownloadTheme);
        menu.add(new JSeparator());
        menu.add(this.actOpenTheme);
        menu.add(this.actSaveTheme);
        menu.add(new JSeparator());
        menu.add(this.actLoadEncryptedTheme);
        menu.add(this.actSaveEncryptedTheme);
        menu.add(new JSeparator());
        menu.add(new AbstractAction(messages.getString("ThemeEditor.menu.exit")){

            @Override
            public void actionPerformed(ActionEvent e) {
                ThemeEditor.this.setVisible(false);
                ThemeEditor.this.dispose();
            }
        });
        menuBar.add(menu);
        menu = new JMenu(messages.getString("ThemeEditor.menu.edit"));
        menu.add(this.actEditTheme);
        menu.add(this.actEditThemeColors);
        menuBar.add(menu);
        this.setJMenuBar(menuBar);
    }

    private void loadEncryptedTheme(File f) {
        JTextField masterPw = new JTextField(this.themeProtection.getMasterPw());
        int ret = JOptionPane.showConfirmDialog(this, new Object[]{messages.getString("ThemeEditor.enc.master_pw"), masterPw}, messages.getString("ThemeEditor.menu.open_enc_theme"), 2);
        if (ret == 0) {
            this.themeProtection.reset();
            try {
                Theme thm = this.themeProtection.loadThemeAsMaster(masterPw.getText(), f);
                thm.setLastChanged(System.currentTimeMillis());
                this.tep.setTheme(thm);
            }
            catch (ThemeProtectionException ex) {
                JOptionPane.showMessageDialog(this, ex.getMessage());
            }
        }
    }

    private void saveEncryptedTheme(File f) {
        JTextField masterPw = new JTextField(this.themeProtection.getMasterPw());
        JTextField userPw = new JTextField(this.themeProtection.getUserPw());
        JTextField serialNumber = new JTextField(this.themeProtection.getSerialNo());
        JTextField customerInfo = new JTextField(this.themeProtection.getCustomerInfo());
        int ret = JOptionPane.showConfirmDialog(this, new Object[]{messages.getString("ThemeEditor.enc.master_pw"), masterPw, messages.getString("ThemeEditor.enc.user_pw"), userPw, messages.getString("ThemeEditor.enc.sernr"), serialNumber, messages.getString("ThemeEditor.enc.customer_info"), customerInfo}, messages.getString("ThemeEditor.enc.settings"), 2);
        if (ret == 0) {
            this.themeProtection.setMasterPw(masterPw.getText());
            this.themeProtection.setUserPw(userPw.getText());
            this.themeProtection.setSerialNo(serialNumber.getText());
            this.themeProtection.setCustomerInfo(customerInfo.getText());
        }
        try {
            this.themeProtection.saveEncryptTheme(this.tep.getTheme(), f);
        }
        catch (ThemeProtectionException ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(this, ex.getMessage());
        }
    }

    private void download(URL baseUrl) throws IOException, JDOMException {
        ThemeGlobals tg = ThemeGlobals.init(baseUrl, messages.getString("ThemeEditor.edit_visu.title"), messages.getString("ThemeEditor.hic.title"));
        JRadioButton[] btns = new JRadioButton[tg.getThemeCount()];
        ButtonGroup btnGrp = new ButtonGroup();
        int i = 0;
        String[] stringArray = ThemeGlobals.THEME_KEYS;
        int n = ThemeGlobals.THEME_KEYS.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            ThemeGlobalsInfo tgi = tg.getThemeInfo(key);
            if (tgi.exists) {
                JRadioButton btn = new JRadioButton(tgi.name);
                btn.setActionCommand(tgi.key);
                btns[i] = btn;
                btnGrp.add(btn);
                if (i == 0) {
                    btn.setSelected(true);
                }
                ++i;
            }
            ++n2;
        }
        int ret = JOptionPane.showConfirmDialog(this, btns, messages.getString("ThemeEditor.info.default_title"), 2);
        if (ret == 0) {
            try {
                ThemeGlobalsInfo tgi = tg.getThemeInfo(btnGrp.getSelection().getActionCommand());
                if (tgi.isEncrypted()) {
                    this.downloadEncryptedTheme(baseUrl, tgi);
                } else {
                    this.downloadTheme(new URL(baseUrl, "/users/bt1/themes/" + tgi.file));
                }
            }
            catch (MalformedURLException e1) {
                e1.printStackTrace();
            }
        }
    }

    private void setTheme(Theme thm) {
        this.tep.setTheme(thm);
    }

    private void downloadEncryptedTheme(URL baseUrl, ThemeGlobalsInfo tgi) {
        JTextField masterPw = new JTextField(this.themeProtection.getMasterPw());
        int ret = JOptionPane.showConfirmDialog(this, new Object[]{messages.getString("ThemeEditor.enc.master_pw"), masterPw}, messages.getString("ThemeEditor.menu.download_enc_theme"), 2);
        if (ret == 0) {
            try {
                URL urlEntry0 = new URL(baseUrl, "/users/bt1/themes/" + tgi.pathToFolder + "entry0");
                URL urlEntry1 = new URL(baseUrl, "/users/bt1/themes/" + tgi.pathToFolder + "entry1");
                URL urlTheme = new URL(baseUrl, "/users/bt1/themes/" + tgi.file);
                this.themeProtection.loadThemeAsMaster(masterPw.getText(), urlEntry0, urlEntry1, urlTheme);
                Theme thm = this.themeProtection.getTheme();
                thm.setTitle(messages.getString("ThemeEditor.info.default_title"));
                thm.setAuthor(messages.getString("ThemeEditor.info.default_author"));
                thm.removeMergedWith();
                this.tep.setTheme(thm);
                this.showThemeInformation();
            }
            catch (ThemeProtectionException ex) {
                JOptionPane.showMessageDialog(this, ex.getMessage());
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
    }

    private void downloadTheme(URL url) {
        System.out.println(url.toString());
        try {
            Theme thm = ThemeLoader.loadTheme(url.openStream(), false);
            thm.setTitle(messages.getString("ThemeEditor.info.default_title"));
            thm.setAuthor(messages.getString("ThemeEditor.info.default_author"));
            thm.removeMergedWith();
            this.setTheme(thm);
            this.showThemeInformation();
        }
        catch (FileNotFoundException e) {
            JOptionPane.showMessageDialog(this, messages.getString("ThemeEditor.error.no_theme"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void showThemeColors() {
        if (this.tep.getTheme() == null) {
            JOptionPane.showMessageDialog(this, messages.getString("ThemeEditor.error.no_selection"));
            return;
        }
        if ("edit_visu".equals(this.tep.getTheme().getType())) {
            ColorDialog_EditVisu colorDialog = new ColorDialog_EditVisu();
            colorDialog.showDialog(this.tep.getTheme(), this);
        } else if ("hic".equals(this.tep.getTheme().getType())) {
            ColorDialog_HIC colorDialog = new ColorDialog_HIC();
            colorDialog.showDialog(this.tep.getTheme(), this);
        } else {
            JOptionPane.showMessageDialog(this, messages.getString("ThemeEditor.error.no_colors"));
        }
    }

    private void showThemeInformation() {
        if (this.tep.getTheme() == null) {
            JOptionPane.showMessageDialog(this, messages.getString("ThemeEditor.error.no_active_theme"));
            return;
        }
        JTextField inputTitle = new JTextField(this.tep.getTheme().getTitle());
        JTextField inputAuthor = new JTextField(this.tep.getTheme().getAuthor());
        long lastchanged = this.tep.getTheme().getLastChanged();
        JTextField inputLastChanged = new JTextField(lastchanged == 0L ? "" : new Date(lastchanged).toString());
        inputLastChanged.setEditable(false);
        int ret = JOptionPane.showConfirmDialog(this, new Object[]{messages.getString("ThemeEditor.info.theme_title"), inputTitle, messages.getString("ThemeEditor.info.theme_author"), inputAuthor, messages.getString("ThemeEditor.info.theme_last_change"), inputLastChanged}, messages.getString("ThemeEditor.info"), 2);
        if (ret == 0) {
            this.tep.getTheme().setTitle(inputTitle.getText());
            this.tep.getTheme().setAuthor(inputAuthor.getText());
        }
    }

    private void createFileChooser() {
        if (this.fc == null) {
            this.fc = new JFileChooser(this.preferences.get(PREF_LAST_THEME_DIR, null));
        }
    }

    public static void main(String[] args) {
        messages = ResourceBundle.getBundle("de.babtec.themes.language.messages");
        ThemeEditor utc = new ThemeEditor();
        utc.setVisible(true);
    }
}

