/*
 * Decompiled with CFR 0.152.
 */
package de.eibport.themes;

import de.eibport.themes.ThemeGlobalsInfo;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public class ThemeGlobals {
    public static final String BASE_DIR_HTTP = "/users/bt1/themes/";
    public static final String BASE_DIR_BT1 = "/home/bt1/htdocs/themes/";
    public static final String BASE_DIR_ROOT = "/config/chroot/home/bt1/htdocs/themes/";
    public static final String PATH_VISU_EDIT_DEFAULT = "edit_visu/default/";
    public static final String PATH_VISU_EDIT_USER = "edit_visu/user/";
    public static final String PATH_HIC_DEFAULT = "hic/default/";
    public static final String PATH_HIC_USER = "hic/user/";
    public static final String FILE_EXTENSION = ".thm";
    public static final String FILE_EXTENSION_ENCRYPTED = ".thx";
    public static final String FILE_NOT_ENCRYPTED = "theme.thm";
    public static final String FILE_ENCRYPTED = "theme.thx";
    public static final String FILE_THEME_INDEX = "ThemeIndex.xml";
    public static final String KEY_EDIT_VISU_DEFAULT = "edit_visu.default";
    public static final String KEY_EDIT_VISU_USER = "edit_visu.user";
    public static final String KEY_HIC_DEFAULT = "hic.default";
    public static final String KEY_HIC_USER = "hic.user";
    public static final String[] THEME_KEYS = new String[]{"edit_visu.default", "edit_visu.user", "hic.default", "hic.user"};
    private static final String CURRENT_VERSION = "1.1";
    private URL baseUrl = null;
    private Document doc = null;
    private HashMap<String, ThemeGlobalsInfo> themeInfos = new HashMap();
    private boolean dirty = false;
    public static ThemeGlobals INSTANCE = null;

    private ThemeGlobals(URL baseUrl, String titleEditVisu, String titleHIC) {
        this.baseUrl = baseUrl;
        this.themeInfos.put(KEY_EDIT_VISU_DEFAULT, new ThemeGlobalsInfo(KEY_EDIT_VISU_DEFAULT, String.valueOf(titleEditVisu) + " Default Theme", "edit_visu", "edit_visu/default/theme.thm", PATH_VISU_EDIT_DEFAULT, true));
        this.themeInfos.put(KEY_EDIT_VISU_USER, new ThemeGlobalsInfo(KEY_EDIT_VISU_USER, String.valueOf(titleEditVisu) + " User Theme", "edit_visu", "edit_visu/theme.thm", PATH_VISU_EDIT_USER, false));
        this.themeInfos.put(KEY_HIC_DEFAULT, new ThemeGlobalsInfo(KEY_HIC_DEFAULT, String.valueOf(titleHIC) + " Default Theme", "hic", "hic/default/theme.thm", PATH_HIC_DEFAULT, true));
        this.themeInfos.put(KEY_HIC_USER, new ThemeGlobalsInfo(KEY_HIC_USER, String.valueOf(titleHIC) + " User Theme", "hic", "hic/theme.thm", PATH_HIC_USER, false));
        this.init();
    }

    public ThemeGlobalsInfo getThemeInfo(String key) {
        return this.themeInfos.get(key);
    }

    public int getThemeCount() {
        int cnt = 0;
        for (ThemeGlobalsInfo tgi : this.themeInfos.values()) {
            if (!tgi.exists) continue;
            ++cnt;
        }
        return cnt;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public static ThemeGlobals init(URL baseUrl, String titleEditVisu, String titleHIC) {
        if (INSTANCE == null) {
            INSTANCE = new ThemeGlobals(baseUrl, titleEditVisu, titleHIC);
        }
        return INSTANCE;
    }

    public static ThemeGlobals getInstance() throws Exception {
        if (INSTANCE == null) {
            throw new Exception("ThemeGlobals is not initiated yet!");
        }
        return INSTANCE;
    }

    private void init() {
        try {
            URL url = new URL(this.baseUrl, "/users/bt1/themes/ThemeIndex.xml");
            this.doc = new SAXBuilder().build(url);
            if (!CURRENT_VERSION.equals(this.doc.getRootElement().getAttributeValue("version"))) {
                this.updateThemeIndex();
            }
            if (!this.doc.getRootElement().getAttributeValue("http_prefix").equals(BASE_DIR_HTTP)) {
                this.doc.getRootElement().setAttribute("http_prefix", BASE_DIR_HTTP);
                this.dirty = true;
            }
            List themes = this.doc.getRootElement().getChildren("theme");
            for (Element element : themes) {
                this.themeInfos.get((Object)element.getAttributeValue((String)"key")).file = String.valueOf(element.getAttributeValue("path")) + element.getAttributeValue("file");
                this.themeInfos.get((Object)element.getAttributeValue((String)"key")).exists = true;
            }
        }
        catch (Exception e) {
            System.out.println("no theme index found... creating a new one");
            this.createThemeIndex();
        }
    }

    public Document getDocument() {
        return this.doc;
    }

    public void removeThemeIndexFile(String key) {
        Element root = this.doc.getRootElement();
        for (Element thm : root.getChildren("theme")) {
            if (!thm.getAttributeValue("key").equals(key)) continue;
            root.removeContent(thm);
            break;
        }
        this.themeInfos.get((Object)key).exists = false;
    }

    public void setThemeIndexFile(String key, String path, String file, boolean encrypted) {
        System.out.println("Updating ThemeIndex.xml: " + key + " -> " + path + file);
        if (this.doc == null) {
            return;
        }
        try {
            Element root = this.doc.getRootElement();
            Element themeElement = null;
            for (Element thm : root.getChildren("theme")) {
                if (!thm.getAttributeValue("key").equals(key)) continue;
                themeElement = thm;
                break;
            }
            if (themeElement == null) {
                themeElement = new Element("theme");
                themeElement.setAttribute("key", key);
                root.addContent(themeElement);
            }
            themeElement.setAttribute("path", path);
            themeElement.setAttribute("file", file);
            themeElement.setAttribute("encrypted", Boolean.toString(encrypted));
            this.themeInfos.get((Object)key).file = String.valueOf(path) + file;
            this.themeInfos.get((Object)key).exists = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean openThemeFile(String key) {
        URL url = null;
        try {
            url = new URL(this.baseUrl, BASE_DIR_HTTP + this.themeInfos.get((Object)key).file);
            url.openStream().close();
            return true;
        }
        catch (Exception e) {
            System.out.println("unable to read " + url);
            return false;
        }
    }

    private void createThemeIndex() {
        Element root = new Element("themes");
        this.doc = new Document(root);
        this.updateThemeIndex();
        this.dirty = true;
    }

    private void updateThemeIndex() {
        System.out.println("Updating ThemeIndex.xml");
        if (this.doc == null) {
            return;
        }
        try {
            Element root = this.doc.getRootElement();
            root.removeChildren("theme");
            for (String key : this.themeInfos.keySet()) {
                if (!key.equals(KEY_EDIT_VISU_DEFAULT) && !key.equals(KEY_HIC_DEFAULT) && !this.openThemeFile(key)) continue;
                String path = this.themeInfos.get((Object)key).file;
                path = path.substring(0, path.lastIndexOf("/") + 1);
                this.setThemeIndexFile(key, path, FILE_NOT_ENCRYPTED, false);
            }
            root.setAttribute("version", CURRENT_VERSION);
            root.setAttribute("http_prefix", BASE_DIR_HTTP);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.dirty = true;
    }
}

