/*
 * Decompiled with CFR 0.152.
 */
package de.eibport.themes.io;

import de.eibport.themes.model.AbstractThemeObject;
import de.eibport.themes.model.Theme;
import de.eibport.themes.model.ThemeCategory;
import de.eibport.themes.model.ThemeItem;
import de.eibport.themes.model.ThemeSet;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class ThemeLoader {
    public static final int MERGE_ERROR_OK = 0;
    public static final int MERGE_ERROR_NO_IMAGE_DATA = 1;

    public static byte[] saveTheme(Theme theme) throws IOException, Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ZipOutputStream zos = new ZipOutputStream(baos);
        String[] stringArray = theme.getImagePaths();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            zos.putNextEntry(new ZipEntry(path));
            zos.write(theme.getImageData(path));
            zos.closeEntry();
            ++n2;
        }
        zos.putNextEntry(new ZipEntry("ThemeSettings.xml"));
        new XMLOutputter(Format.getPrettyFormat()).output(theme.getDocument(), (OutputStream)zos);
        zos.closeEntry();
        zos.close();
        return baos.toByteArray();
    }

    public static Theme loadTheme(InputStream in, boolean defaultTheme) throws IOException, Exception {
        ZipEntry ze;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int c = in.read();
        while (c != -1) {
            baos.write(c);
            c = in.read();
        }
        in.close();
        byte[] bytes = baos.toByteArray();
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        ZipInputStream zin = new ZipInputStream(bais);
        Theme theme = new Theme("New Theme", defaultTheme);
        boolean foundThemeSettings = false;
        while ((ze = zin.getNextEntry()) != null) {
            baos.reset();
            int c2 = zin.read();
            while (c2 != -1) {
                baos.write(c2);
                c2 = zin.read();
            }
            if (ze.getName().equals("ThemeSettings.xml")) {
                Document doc = new SAXBuilder().build(new ByteArrayInputStream(baos.toByteArray()));
                theme.setDocument(doc);
                Element root = doc.getRootElement();
                Element colors = root.getChild("themeColors");
                Element images = root.getChild("images");
                ThemeLoader.readChildren(images, theme);
                foundThemeSettings = true;
                continue;
            }
            theme.setImageData(ze.getName(), baos.toByteArray());
        }
        if (!foundThemeSettings) {
            throw new Exception("The selected file is not a valid theme.");
        }
        return theme;
    }

    public static int mergeThemes(Theme source, Theme target, String mergeIdent) {
        String key;
        System.out.println("Merging themes for " + mergeIdent);
        target.setTitle(source.getTitle());
        target.setAuthor(source.getAuthor());
        target.setLastChanged(source.getLastChanged());
        String[] stringArray = source.getPropertyKeys();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            key = stringArray[n2];
            if (target.getProperty(key, null) != null) {
                target.setProperty(key, source.getProperty(key, null));
            }
            ++n2;
        }
        stringArray = target.getThemeSetKeys();
        n = stringArray.length;
        n2 = 0;
        while (n2 < n) {
            String setKey = stringArray[n2];
            ThemeSet targetSet = target.getThemeSet(setKey);
            ThemeSet sourceSet = source.getThemeSet(setKey);
            if (sourceSet != null) {
                Integer[] integerArray = sourceSet.getSetKeys();
                int n3 = integerArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    int key2 = integerArray[n4];
                    if (sourceSet.getEdited(key2)) {
                        if (!targetSet.containsKey(key2)) {
                            targetSet.addSet(key2, sourceSet.getSetTitle(key2));
                        } else {
                            targetSet.setSetTitle(key2, sourceSet.getSetTitle(key2));
                        }
                        ThemeItem[] themeItemArray = targetSet.getChildItems();
                        int n5 = themeItemArray.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            ThemeItem targetItem = themeItemArray[n6];
                            ThemeItem sourceItem = source.getThemeItem(targetItem.getKey(), key2);
                            byte[] srcData = source.getImageData(sourceItem.getImagePath(key2));
                            if (srcData == null) {
                                System.out.println("Theme contains empty image.");
                                return 1;
                            }
                            targetItem.setImageData(srcData, key2, sourceItem.getExtension(key2));
                            ++n6;
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        stringArray = target.getThemeItemKeys();
        n = stringArray.length;
        n2 = 0;
        while (n2 < n) {
            key = stringArray[n2];
            ThemeItem item = source.getThemeItem(key);
            if (item != null && !(item.getParent() instanceof ThemeSet) && item.getEdited()) {
                byte[] srcData = item.getImageData(-1);
                if (srcData == null) {
                    System.out.println("Theme contains empty image.");
                    return 1;
                }
                target.getThemeItem(key).setImageData(srcData, -1, item.getExtension(0));
            }
            ++n2;
        }
        target.setMergedWith(mergeIdent);
        return 0;
    }

    public static void readChildren(Element parent, AbstractThemeObject parentObj) {
        for (Element child : parent.getChildren()) {
            if (child.getName().equals("category")) {
                ThemeCategory cat = new ThemeCategory(child, parentObj);
                parentObj.addChildObject(cat);
                ThemeLoader.readChildren(child, cat);
            }
            if (child.getName().equals("iconset")) {
                ThemeSet set = new ThemeSet(child, parentObj);
                parentObj.addChildObject(set);
                ThemeLoader.readChildren(child, set);
            }
            if (!child.getName().equals("icon")) continue;
            ThemeItem item = new ThemeItem(child, parentObj);
            parentObj.addChildObject(item);
        }
    }
}

