/*
 * Decompiled with CFR 0.152.
 */
package de.eibport.themes.model;

import de.eibport.themes.model.Theme;
import de.eibport.themes.model.ThemeCategory;
import de.eibport.themes.model.ThemeItem;
import de.eibport.themes.model.ThemeSet;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import org.jdom.Element;

public abstract class AbstractThemeObject {
    protected static SimpleDateFormat EDIT_DATE_FORMAT = new SimpleDateFormat("yyyyMMddHHmm");
    protected String title;
    private AbstractThemeObject parent;
    private ArrayList<AbstractThemeObject> childObjects = new ArrayList();
    protected Element element;

    public AbstractThemeObject(String title, Element element, AbstractThemeObject parent) {
        this.title = title;
        this.element = element;
        this.parent = parent;
    }

    public String getTitle() {
        return this.title;
    }

    public void addChildObject(AbstractThemeObject childObject) {
        this.childObjects.add(childObject);
    }

    public void removeChildObject(AbstractThemeObject childObject) {
        childObject.getParent().getElement().removeContent(childObject.getElement());
        this.childObjects.remove(childObject);
        this.getTheme().removeImagesFrom(childObject);
    }

    public AbstractThemeObject[] getChildObjects() {
        return this.childObjects.toArray(new AbstractThemeObject[this.childObjects.size()]);
    }

    public ThemeCategory[] getChildCategories() {
        ArrayList<ThemeCategory> cats = new ArrayList<ThemeCategory>();
        for (AbstractThemeObject obj : this.childObjects) {
            if (!(obj instanceof ThemeCategory)) continue;
            cats.add((ThemeCategory)obj);
        }
        return cats.toArray(new ThemeCategory[cats.size()]);
    }

    public ThemeSet[] getChildSets() {
        ArrayList<ThemeSet> sets = new ArrayList<ThemeSet>();
        for (AbstractThemeObject obj : this.childObjects) {
            if (!(obj instanceof ThemeSet)) continue;
            sets.add((ThemeSet)obj);
        }
        return sets.toArray(new ThemeSet[sets.size()]);
    }

    public ThemeItem[] getChildItems() {
        ArrayList<ThemeItem> items = new ArrayList<ThemeItem>();
        for (AbstractThemeObject obj : this.childObjects) {
            if (!(obj instanceof ThemeItem)) continue;
            items.add((ThemeItem)obj);
        }
        return items.toArray(new ThemeItem[items.size()]);
    }

    public AbstractThemeObject getParent() {
        return this.parent;
    }

    public Element getElement() {
        return this.element;
    }

    public Theme getTheme() {
        AbstractThemeObject p = this.parent;
        while (!(p instanceof Theme)) {
            p = p.getParent();
        }
        return (Theme)p;
    }

    public String toString() {
        return this.getTitle();
    }
}

