/*
 * Decompiled with CFR 0.152.
 */
package de.eibport.themes.model;

import de.eibport.themes.model.AbstractThemeObject;
import de.eibport.themes.model.ThemeItem;
import de.eibport.themes.model.ThemeSet;
import java.awt.Color;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.util.HashMap;
import java.util.List;
import javax.swing.ImageIcon;
import org.jdom.Document;
import org.jdom.Element;

public class Theme
extends AbstractThemeObject {
    public static final String TYPE_EDIT_VISU = "edit_visu";
    public static final String TYPE_HIC = "hic";
    private HashMap<String, byte[]> imageData = new HashMap();
    private HashMap<String, ImageIcon> icons = new HashMap();
    private HashMap<String, Image> filteredImages = new HashMap();
    private HashMap<String, ThemeSet> themeSets = new HashMap();
    private HashMap<String, ThemeItem> themeItems = new HashMap();
    private Element properties;
    private Document doc;
    private boolean defaultTheme = false;

    public Theme(String title, boolean defaultTheme) {
        super(title, null, null);
        this.defaultTheme = defaultTheme;
    }

    public void setDocument(Document doc) {
        this.doc = doc;
        this.element = doc.getRootElement();
        this.title = this.element.getAttributeValue("title");
        this.properties = this.element.getChild("properties");
        if (this.properties == null) {
            this.properties = new Element("properties");
            this.element.addContent(this.properties);
        }
    }

    public String getProperty(String key, String defaultValue) {
        String value = this.properties.getChildText(key);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public void setProperty(String key, String value) {
        if (this.properties.getChild(key) == null) {
            this.properties.addContent(new Element(key).setText(value));
        } else {
            this.properties.getChild(key).setText(value);
        }
    }

    public int getPropertyInt(String key, int defaultValue) {
        try {
            return Integer.parseInt(this.getProperty(key, null));
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public void setProperty(String key, int value) {
        this.setProperty(key, Integer.toString(value));
    }

    public Color getPropertyColor(String key, Color defaultValue) {
        try {
            String value = this.getProperty(key, null);
            if (value == null) {
                return defaultValue;
            }
            return new Color(Integer.parseInt(value));
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public void setPropertyColor(String key, Color value) {
        this.setProperty(key, value.getRGB());
    }

    public String[] getPropertyKeys() {
        List list = this.properties.getChildren();
        String[] ret = new String[list.size()];
        int i = 0;
        while (i < list.size()) {
            ret[i] = ((Element)list.get(i)).getName();
            ++i;
        }
        return ret;
    }

    public String getType() {
        return this.element.getAttributeValue("type");
    }

    public void setTitle(String title) {
        this.title = title;
        this.element.setAttribute("title", title);
    }

    public void setAuthor(String author) {
        this.element.setAttribute("author", author);
    }

    public String getAuthor() {
        return this.element.getAttributeValue("author");
    }

    public void setLastChanged(long lastChanged) {
        this.element.setAttribute("lastChanged", Long.toString(lastChanged));
    }

    public long getLastChanged() {
        String lastChanged = this.element.getAttributeValue("lastChanged");
        return lastChanged == null ? 0L : Long.parseLong(lastChanged);
    }

    public void setDefaultTheme(boolean defaultTheme) {
        this.defaultTheme = defaultTheme;
    }

    public boolean isDefaultTheme() {
        return this.defaultTheme;
    }

    public void removeMergedWith() {
        this.doc.getRootElement().removeAttribute("mergedWith");
    }

    public void setMergedWith(String mergeIdent) {
        this.doc.getRootElement().setAttribute("mergedWith", mergeIdent);
    }

    public String getMergedWith() {
        return this.doc.getRootElement().getAttributeValue("mergedWith");
    }

    public Document getDocument() {
        return this.doc;
    }

    public void removeImagesFrom(AbstractThemeObject obj) {
        AbstractThemeObject[] abstractThemeObjectArray = obj.getChildObjects();
        int n = abstractThemeObjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractThemeObject objs = abstractThemeObjectArray[n2];
            if (objs instanceof ThemeItem) {
                String[] stringArray = ((ThemeItem)objs).getImagePaths();
                int n3 = stringArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    String path = stringArray[n4];
                    this.clearImageData(path);
                    ++n4;
                }
            } else {
                this.removeImagesFrom(objs);
            }
            ++n2;
        }
    }

    public void setImageData(String path, byte[] data) {
        this.imageData.put(path, data);
        this.filteredImages.remove(path);
        this.icons.remove(path);
    }

    public void clearImageData(String path) {
        this.imageData.remove(path);
        this.filteredImages.remove(path);
        this.icons.remove(path);
    }

    public void clear() {
        String[] stringArray = this.imageData.keySet().toArray(new String[this.imageData.size()]);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            this.clearImageData(key);
            ++n2;
        }
    }

    public byte[] getImageData(String path) {
        return this.imageData.get(path);
    }

    public boolean containsImageData(String path) {
        return this.imageData.containsKey(path);
    }

    public String[] getImagePaths() {
        return this.imageData.keySet().toArray(new String[this.imageData.size()]);
    }

    public String[] getThemeItemKeys() {
        return this.themeItems.keySet().toArray(new String[this.themeItems.size()]);
    }

    public ThemeItem getThemeItem(String key) {
        return this.themeItems.get(key);
    }

    public ThemeItem getThemeItem(String key, int setKey) {
        String newKey;
        if (setKey > 0 && this.themeItems.containsKey(newKey = String.valueOf(key) + "_" + setKey)) {
            return this.themeItems.get(newKey);
        }
        return this.themeItems.get(key);
    }

    public void addThemeItem(ThemeItem item) {
        this.themeItems.put(item.getKey(), item);
    }

    public String[] getThemeSetKeys() {
        return this.themeSets.keySet().toArray(new String[this.themeSets.size()]);
    }

    public ThemeSet getThemeSet(String key) {
        return this.themeSets.get(key);
    }

    public void addThemeSet(ThemeSet ts) {
        this.themeSets.put(ts.getKey(), ts);
    }

    public ImageIcon getIcon(String path) {
        if (!this.icons.containsKey(path) && this.imageData.containsKey(path)) {
            this.icons.put(path, new ImageIcon(this.getImageData(path)));
        }
        return this.icons.get(path);
    }

    public Image getFilteredImage(RGBImageFilter filter, String path) {
        if (!this.filteredImages.containsKey(path)) {
            Image filteredImage = Toolkit.getDefaultToolkit().createImage(this.getImageData(path));
            if (filter != null) {
                filteredImage = Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(filteredImage.getSource(), filter));
            }
            this.filteredImages.put(path, filteredImage);
        }
        return this.filteredImages.get(path);
    }

    public void clearFilteredImages() {
        this.filteredImages.clear();
    }
}

