/*
 * Decompiled with CFR 0.152.
 */
package de.eibport.themes.model;

import de.eibport.themes.model.AbstractThemeObject;
import de.eibport.themes.model.ThemeSet;
import java.awt.Image;
import java.awt.image.RGBImageFilter;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.ImageIcon;
import org.jdom.Element;

public class ThemeItem
extends AbstractThemeObject {
    private String key;
    private String path;
    private String filename;
    private String desc;
    private int width;
    private int height;
    private String edited = null;

    public ThemeItem(Element element, AbstractThemeObject parent) {
        super(element.getChildText("title"), element, parent);
        this.key = element.getAttributeValue("key");
        this.path = element.getChildText("path");
        this.filename = element.getChildText("filename");
        this.desc = element.getChildText("desc");
        this.width = Integer.parseInt(element.getChildText("width"));
        this.height = Integer.parseInt(element.getChildText("height"));
        this.edited = element.getAttributeValue("edited");
        this.getTheme().addThemeItem(this);
    }

    public String getKey() {
        return this.key;
    }

    public String getPath() {
        return this.path;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getDesc() {
        return this.desc;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public String getExtension(int setIndex) {
        if (this.getExtensionElement(setIndex) == null) {
            System.out.println("element null " + this.key + " - " + setIndex);
            return ".png";
        }
        String ext = this.getExtensionElement(setIndex).getText();
        if (ext == null) {
            System.out.println(String.valueOf(this.key) + " - " + setIndex);
            return ".png";
        }
        return this.getExtensionElement(setIndex).getText();
    }

    public boolean isExportAllowed() {
        String val = this.element.getAttributeValue("exportAllowed");
        return val == null ? true : Boolean.parseBoolean(val);
    }

    public boolean isReplaceAllowed() {
        String val = this.element.getAttributeValue("replaceAllowed");
        return val == null ? true : Boolean.parseBoolean(val);
    }

    public boolean getEdited() {
        return this.edited != null;
    }

    public boolean containsSetIndex(int setIndex) {
        if (this.getParent() instanceof ThemeSet) {
            return ((ThemeSet)this.getParent()).containsKey(setIndex);
        }
        return false;
    }

    public String getImagePath(int setIndex) {
        String ret = setIndex >= 0 ? (this.containsSetIndex(setIndex) ? String.valueOf(this.path) + setIndex + "_" + this.filename : String.valueOf(this.path) + "0_" + this.filename) : String.valueOf(this.path) + this.filename;
        return String.valueOf(ret) + this.getExtension(setIndex);
    }

    public String[] getImagePaths() {
        if (this.getParent() instanceof ThemeSet) {
            ThemeSet ts = (ThemeSet)this.getParent();
            ArrayList<String> ret = new ArrayList<String>();
            ret.add(this.getImagePath(0));
            Integer[] integerArray = ts.getSetKeys();
            int n = integerArray.length;
            int n2 = 0;
            while (n2 < n) {
                int key = integerArray[n2];
                ret.add(this.getImagePath(key));
                ++n2;
            }
            return ret.toArray(new String[ret.size()]);
        }
        return new String[]{this.getImagePath(-1)};
    }

    public void setImageData(byte[] data, int setIndex, String extension) {
        this.getTheme().clearImageData(this.getImagePath(setIndex));
        if (this.getParent() instanceof ThemeSet) {
            ((ThemeSet)this.getParent()).setEdited(true, setIndex);
            this.getExtensionElement(setIndex).setText(extension);
        } else {
            this.element.getChild("extension").setText(extension);
            this.element.setAttribute("edited", EDIT_DATE_FORMAT.format(new Date()));
        }
        this.getTheme().setImageData(this.getImagePath(setIndex), data);
    }

    private Element getExtensionElement(int setIndex) {
        Element ret = setIndex > 0 ? this.element.getChild("extension_" + setIndex) : this.element.getChild("extension");
        if (ret == null) {
            this.addSetInformation(setIndex);
            ret = this.getExtensionElement(setIndex);
        }
        return ret;
    }

    public void removeSetInformation(int setIndex) {
        this.getTheme().clearImageData(this.getImagePath(setIndex));
        this.element.removeChild("extension_" + setIndex);
    }

    public void addSetInformation(int setIndex) {
        if (setIndex > 0) {
            this.element.addContent(new Element("extension_" + setIndex));
        } else {
            this.element.addContent(new Element("extension"));
        }
    }

    public byte[] getImageData(int setIndex) {
        return this.getTheme().getImageData(this.getImagePath(setIndex));
    }

    public ImageIcon getIcon() {
        return this.getIcon(-1);
    }

    public ImageIcon getIcon(int setIndex) {
        return this.getTheme().getIcon(this.getImagePath(setIndex));
    }

    public Image getFilteredImage(RGBImageFilter filter, int setKey) {
        return this.getTheme().getFilteredImage(filter, this.getImagePath(setKey));
    }
}

