/*
 * Decompiled with CFR 0.152.
 */
package de.eibport.themes.model;

import de.eibport.themes.model.AbstractThemeObject;
import de.eibport.themes.model.ThemeItem;
import java.util.Date;
import java.util.HashMap;
import org.jdom.Element;

public class ThemeSet
extends AbstractThemeObject {
    private HashMap<Integer, String> sets = new HashMap();

    public ThemeSet(Element element, AbstractThemeObject parent) {
        super(element.getAttributeValue("title"), element, parent);
        this.sets.put(0, this.getDefaultTitle());
        for (Element set : element.getChildren("set")) {
            this.sets.put(Integer.parseInt(set.getAttributeValue("key")), set.getAttributeValue("title"));
        }
        this.getTheme().addThemeSet(this);
    }

    public boolean isRemovable() {
        String val = this.element.getAttributeValue("removable");
        return val == null ? true : Boolean.parseBoolean(val);
    }

    public String getKey() {
        return this.element.getAttributeValue("key");
    }

    public String getDefaultTitle() {
        return this.element.getAttributeValue("default");
    }

    public boolean containsKey(int key) {
        return key == 0 || this.sets.containsKey(key);
    }

    public Integer[] getSetKeys() {
        return this.sets.keySet().toArray(new Integer[this.sets.size()]);
    }

    public String getSetTitle(int key) {
        if (key == 0) {
            return this.getDefaultTitle();
        }
        return this.sets.get(key);
    }

    public void setSetTitle(int key, String title) {
        this.getSetElement(key).setAttribute("title", title);
        this.sets.put(key, title);
    }

    public void addSet(int key, String title) {
        Element set = new Element("set");
        set.setAttribute("key", Integer.toString(key));
        set.setAttribute("title", title);
        this.element.addContent(set);
        this.sets.put(key, title);
        this.setEdited(true, key);
    }

    public void removeSet(int key) {
        this.element.removeContent(this.getSetElement(key));
        ThemeItem[] themeItemArray = this.getChildItems();
        int n = themeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            ThemeItem item = themeItemArray[n2];
            item.removeSetInformation(key);
            ++n2;
        }
        this.sets.remove(key);
    }

    private Element getSetElement(int setIndex) {
        if (setIndex == 0) {
            return this.element;
        }
        for (Element set : this.element.getChildren("set")) {
            if (Integer.parseInt(set.getAttributeValue("key")) != setIndex) continue;
            return set;
        }
        return null;
    }

    public void setEdited(boolean edited, int setIndex) {
        Element e;
        Element element = e = setIndex == 0 ? this.element : this.getSetElement(setIndex);
        if (e == null) {
            return;
        }
        if (edited) {
            e.setAttribute("edited", EDIT_DATE_FORMAT.format(new Date()));
        } else {
            e.removeAttribute("edited");
        }
    }

    public boolean getEdited(int setIndex) {
        Element e;
        Element element = e = setIndex == 0 ? this.element : this.getSetElement(setIndex);
        if (e == null) {
            return false;
        }
        return e.getAttributeValue("edited") != null;
    }
}

