/*
 * Decompiled with CFR 0.152.
 */
package de.eibport.themes.security;

import de.eibport.themes.io.ThemeLoader;
import de.eibport.themes.model.Theme;
import de.eibport.themes.security.ThemeProtectionException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.spec.SecretKeySpec;

public class ThemeProtection {
    private String userPw;
    private String masterPw;
    private String serialNo;
    private String customerInfo;
    private Theme theme;
    private byte[] dataEntry0 = null;
    private byte[] dataEntry1 = null;
    private byte[] dataEntry2 = null;

    public String getUserPw() {
        return this.userPw;
    }

    public void setUserPw(String userPw) {
        this.userPw = userPw;
    }

    public String getMasterPw() {
        return this.masterPw;
    }

    public void setMasterPw(String masterPw) {
        this.masterPw = masterPw;
    }

    public String getSerialNo() {
        return this.serialNo;
    }

    public void setSerialNo(String serialNo) {
        this.serialNo = serialNo;
    }

    public String getCustomerInfo() {
        return this.customerInfo;
    }

    public void setCustomerInfo(String customerInfo) {
        this.customerInfo = customerInfo;
    }

    public Theme getTheme() {
        return this.theme;
    }

    public void setTheme(Theme theme) {
        this.theme = theme;
    }

    public byte[] getDataEntry0() {
        return this.dataEntry0;
    }

    public byte[] getDataEntry1() {
        return this.dataEntry1;
    }

    public byte[] getDataEntry2() {
        return this.dataEntry2;
    }

    public void reset() {
        this.userPw = "";
        this.masterPw = "";
        this.serialNo = "";
        this.customerInfo = "";
        this.theme = null;
        this.dataEntry0 = null;
        this.dataEntry1 = null;
        this.dataEntry2 = null;
    }

    public Theme loadThemeAsUser(String userPw, File f) throws ThemeProtectionException {
        return this.loadTheme(userPw, null, f);
    }

    public Theme loadThemeAsMaster(String masterPw, File f) throws ThemeProtectionException {
        return this.loadTheme(null, masterPw, f);
    }

    public Theme loadThemeAsMaster(String masterPw, URL entry0, URL entry1, URL entry2) throws ThemeProtectionException {
        this.setUserPw(null);
        this.setMasterPw(masterPw);
        try {
            int data;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            InputStream is = entry0.openStream();
            while ((data = is.read()) != -1) {
                baos.write(data);
            }
            this.dataEntry0 = baos.toByteArray();
            baos.reset();
            is.close();
            is = entry1.openStream();
            while ((data = is.read()) != -1) {
                baos.write(data);
            }
            this.dataEntry1 = baos.toByteArray();
            baos.reset();
            is.close();
            is = entry2.openStream();
            while ((data = is.read()) != -1) {
                baos.write(data);
            }
            this.dataEntry2 = baos.toByteArray();
            baos.reset();
            is.close();
        }
        catch (IOException e) {
            this.reset();
            throw new ThemeProtectionException(1, "Unable to read data!", e);
        }
        return this.decryptEntries();
    }

    private Theme loadTheme(String userPw, String masterPw, File f) throws ThemeProtectionException {
        this.setUserPw(userPw);
        this.setMasterPw(masterPw);
        try {
            int data;
            ZipFile zf = new ZipFile(f);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            InputStream is = zf.getInputStream(zf.getEntry("entry0"));
            while ((data = is.read()) != -1) {
                baos.write(data);
            }
            this.dataEntry0 = baos.toByteArray();
            baos.reset();
            is = zf.getInputStream(zf.getEntry("entry1"));
            while ((data = is.read()) != -1) {
                baos.write(data);
            }
            this.dataEntry1 = baos.toByteArray();
            baos.reset();
            is = zf.getInputStream(zf.getEntry("entry2"));
            while ((data = is.read()) != -1) {
                baos.write(data);
            }
            this.dataEntry2 = baos.toByteArray();
            baos.reset();
        }
        catch (IOException e) {
            this.reset();
            throw new ThemeProtectionException(1, "Unable to read data!", e);
        }
        return this.decryptEntries();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Theme decryptEntries() throws ThemeProtectionException {
        try {
            Cipher cipher;
            Charset cs;
            block11: {
                cs = Charset.forName("UTF-8");
                byte[] encKey = "iP5mETKqpMIVfiRL".getBytes("ISO-8859-1");
                SecretKeySpec k = new SecretKeySpec(encKey, "AES");
                cipher = Cipher.getInstance("AES");
                cipher.init(2, k);
                byte[] userInfo = cipher.doFinal(this.dataEntry0);
                int split = 0;
                while (true) {
                    if (userInfo[split] == 0) {
                        if (this.masterPw == null) break;
                        byte[] mpw = new byte[userInfo.length - (split + 1)];
                        System.arraycopy(userInfo, split + 1, mpw, 0, mpw.length);
                        String thmMasterPw = new String(mpw, cs);
                        if (!this.masterPw.equals(thmMasterPw)) {
                            this.reset();
                            throw new ThemeProtectionException(3, "Unable to decrypt theme using this password!", null);
                        }
                        byte[] upw = new byte[split];
                        System.arraycopy(userInfo, 0, upw, 0, split);
                        this.userPw = new String(upw, cs);
                        break block11;
                    }
                    ++split;
                }
                if (this.userPw == null) {
                    this.reset();
                    throw new ThemeProtectionException(3, "Unable to decrypt theme using this password!", null);
                }
                byte[] upw = new byte[split];
                System.arraycopy(userInfo, 0, upw, 0, split);
                String thmUserPw = new String(upw, cs);
                if (!this.userPw.equals(thmUserPw)) {
                    this.reset();
                    throw new ThemeProtectionException(3, "Unable to decrypt theme using this password!", null);
                }
            }
            String themeInfo = new String(cipher.doFinal(this.dataEntry1), cs);
            int splitIndex = themeInfo.indexOf(59);
            this.serialNo = themeInfo.substring(0, splitIndex);
            if (splitIndex != themeInfo.length()) {
                this.customerInfo = themeInfo.substring(splitIndex + 1);
            }
            this.theme = ThemeLoader.loadTheme(new ByteArrayInputStream(cipher.doFinal(this.dataEntry2)), false);
            return this.theme;
        }
        catch (BadPaddingException e) {
            this.reset();
            throw new ThemeProtectionException(3, "Unable to decrypt theme!", e);
        }
        catch (IllegalBlockSizeException e) {
            this.reset();
            throw new ThemeProtectionException(2, "Unable to decrypt: Invalid data!", e);
        }
        catch (IOException e) {
            this.reset();
            throw new ThemeProtectionException(1, "Unable to read data!", e);
        }
        catch (Exception e) {
            this.reset();
            if (!(e instanceof ThemeProtectionException)) throw new ThemeProtectionException(0, "An unknown error occured!", e);
            throw (ThemeProtectionException)e;
        }
    }

    public void saveEncryptTheme(Theme thm, File f) throws ThemeProtectionException {
        this.theme = thm;
        Charset cs = Charset.forName("UTF-8");
        byte[] upw = this.userPw.getBytes(cs);
        byte[] mpw = this.masterPw.getBytes(cs);
        byte[] themeInfo = (String.valueOf(this.serialNo) + ";" + this.customerInfo).getBytes(cs);
        byte[] userInfo = new byte[upw.length + mpw.length + 1];
        System.arraycopy(upw, 0, userInfo, 0, upw.length);
        System.arraycopy(mpw, 0, userInfo, upw.length + 1, mpw.length);
        try {
            byte[] encKey = "iP5mETKqpMIVfiRL".getBytes("ISO-8859-1");
            Cipher cipher = Cipher.getInstance("AES");
            SecretKeySpec k = new SecretKeySpec(encKey, "AES");
            cipher.init(1, k);
            byte[] userInfoData = cipher.doFinal(userInfo);
            byte[] themeInfoData = cipher.doFinal(themeInfo);
            byte[] themeData = cipher.doFinal(ThemeLoader.saveTheme(thm));
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ZipOutputStream zos = new ZipOutputStream(baos);
            zos.putNextEntry(new ZipEntry("entry0"));
            zos.write(userInfoData);
            zos.putNextEntry(new ZipEntry("entry1"));
            zos.write(themeInfoData);
            zos.putNextEntry(new ZipEntry("entry2"));
            zos.write(themeData);
            zos.close();
            FileOutputStream fos = new FileOutputStream(f);
            fos.write(baos.toByteArray());
            fos.close();
        }
        catch (BadPaddingException e) {
            throw new ThemeProtectionException(4, "Unable to encrypt theme using this password!", e);
        }
        catch (IllegalBlockSizeException e) {
            throw new ThemeProtectionException(2, "Unable to decrypt: Invalid data!", e);
        }
        catch (IOException e) {
            throw new ThemeProtectionException(1, "Unable to read data!", e);
        }
        catch (Exception e) {
            throw new ThemeProtectionException(0, "An unknown error occured!", e);
        }
    }

    public byte[] encryptTheme(Theme thm) throws ThemeProtectionException {
        try {
            byte[] encKey = "iP5mETKqpMIVfiRL".getBytes("ISO-8859-1");
            Cipher cipher = Cipher.getInstance("AES");
            SecretKeySpec k = new SecretKeySpec(encKey, "AES");
            cipher.init(1, k);
            return cipher.doFinal(ThemeLoader.saveTheme(thm));
        }
        catch (BadPaddingException e) {
            throw new ThemeProtectionException(4, "Unable to encrypt theme!", e);
        }
        catch (IllegalBlockSizeException e) {
            throw new ThemeProtectionException(2, "Unable to encrypt: Invalid data!", e);
        }
        catch (IOException e) {
            throw new ThemeProtectionException(1, "Unable to read data!", e);
        }
        catch (Exception e) {
            throw new ThemeProtectionException(0, "An unknown error occured!", e);
        }
    }

    public byte[] decryptTheme(byte[] data) throws ThemeProtectionException {
        try {
            byte[] encKey = "iP5mETKqpMIVfiRL".getBytes("ISO-8859-1");
            Cipher cipher = Cipher.getInstance("AES");
            SecretKeySpec k = new SecretKeySpec(encKey, "AES");
            cipher.init(2, k);
            return cipher.doFinal(data);
        }
        catch (BadPaddingException e) {
            throw new ThemeProtectionException(4, "Unable to encrypt theme!", e);
        }
        catch (IllegalBlockSizeException e) {
            throw new ThemeProtectionException(2, "Unable to encrypt: Invalid data!", e);
        }
        catch (IOException e) {
            throw new ThemeProtectionException(1, "Unable to read data!", e);
        }
        catch (Exception e) {
            throw new ThemeProtectionException(0, "An unknown error occured!", e);
        }
    }
}

