/*
 * Decompiled with CFR 0.152.
 */
package com.sun.swingset3.utilities;

import com.sun.swingset3.utilities.Utilities;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import javax.swing.JPanel;

public class GradientPanel
extends JPanel {
    private final Color[] colors = new Color[2];
    private Image image;

    public GradientPanel(Color color, Color color2) {
        this.setOpaque(false);
        this.setBackground(color);
        this.colors[0] = color;
        this.colors[1] = color2;
    }

    public void setGradientColor1(Color color) {
        this.changeGradientColor(0, color);
    }

    public void setGradientColor2(Color color) {
        this.changeGradientColor(1, color);
    }

    protected void changeGradientColor(int n, Color color) {
        Color color2 = this.colors[n];
        this.colors[n] = color;
        if (!color2.equals(color)) {
            this.image = null;
            this.firePropertyChange("gradientColor" + n, color2, color);
        }
    }

    protected Image getGradientImage() {
        Dimension dimension = this.getSize();
        if (this.image == null || this.image.getWidth(null) != dimension.width || this.image.getHeight(null) != dimension.height) {
            this.image = Utilities.createGradientImage(dimension.width, dimension.height, this.colors[0], this.colors[1]);
        }
        return this.image;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Image image = this.getGradientImage();
        graphics.drawImage(image, 0, 0, null);
        super.paintComponent(graphics);
    }
}

