/*
 * Decompiled with CFR 0.152.
 */
package de.babtec.matrix;

import de.babtec.matrix.exceptions.DPReadException;
import de.babtec.matrix.exceptions.DongleProtectException;
import de.matrixlock.Matrix;
import de.matrixlock.MxTea;
import java.io.ByteArrayOutputStream;
import java.util.Arrays;
import java.util.Random;

public class DongleProtectReader {
    DongleProtectReader() {
    }

    public byte[] getDataBytes() throws DPReadException, DongleProtectException {
        try {
            Matrix.init();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            throw new DongleProtectException(unsatisfiedLinkError.getMessage());
        }
        int n = 85;
        short s = Matrix.Init_MatrixAPI();
        if (s < 0) {
            Matrix.Release_MatrixAPI();
            throw new DPReadException(0, "Init_MatrixAPI    RetCode:  " + s + " \n");
        }
        short s2 = Matrix.Dongle_Count((short)n);
        if (s2 == 0) {
            Matrix.Release_MatrixAPI();
            throw new DPReadException(1, "More than one dongles detected!");
        }
        if (s2 > 1) {
            Matrix.Release_MatrixAPI();
            throw new DPReadException(2, "More than one dongles detected!");
        }
        short s3 = Matrix.Dongle_MemSize(s2, (short)n);
        if (s3 != 60) {
            Matrix.Release_MatrixAPI();
            throw new DPReadException(5, "Wrong dongle detected (only 60 data bytes accepted)!");
        }
        Random random = new Random(System.currentTimeMillis());
        int n2 = random.nextInt();
        int n3 = random.nextInt();
        int[] nArray = new int[]{n2, n3};
        int[] nArray2 = new int[]{n2, n3};
        short s4 = MxTea.MxApp_Encrypt(nArray, new int[]{-1939160670, 818448035, -2048304902, -294793513});
        short s5 = Matrix.Dongle_EncryptData(0x3BCC3B, nArray2, (short)1, (short)n);
        if (s4 < 0 || s5 < 0) {
            Matrix.Release_MatrixAPI();
            throw new DPReadException(3, "Unable to encrypt data. RetCode:  " + s4 + "; " + s5 + " \n");
        }
        if (!Arrays.equals(nArray2, nArray)) {
            Matrix.Release_MatrixAPI();
            throw new DPReadException(4, "Dongle encryption test failed.");
        }
        int[] nArray3 = new int[15];
        s = Matrix.Dongle_ReadData(0x3BCC3B, nArray3, (short)15, s2, (short)n);
        if (s < 0) {
            Matrix.Release_MatrixAPI();
            throw new DPReadException(6, "Error while reading Dongle data!  Error-Code: " + s);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(60);
        for (int n4 : nArray3) {
            byteArrayOutputStream.write(n4 >> 24 & 0xFF);
            byteArrayOutputStream.write(n4 >> 16 & 0xFF);
            byteArrayOutputStream.write(n4 >> 8 & 0xFF);
            byteArrayOutputStream.write(n4 & 0xFF);
        }
        return byteArrayOutputStream.toByteArray();
    }
}

