/*
 * Decompiled with CFR 0.152.
 */
package de.babtec.updatetool;

import com.jcraft.jsch.SftpProgressMonitor;
import de.babtec.matrix.DongleProtect;
import de.babtec.matrix.Utils;
import de.babtec.matrix.exceptions.DPParseException;
import de.babtec.matrix.exceptions.DPReadException;
import de.babtec.matrix.exceptions.DongleProtectException;
import de.babtec.updatetool.UpdateListener;
import de.babtec.updatetool.discovery.Device;
import de.eibport.components.login.ILoginUser;
import de.eibport.components.login.UserPool;
import de.eibport.net.mcast.packets.v2.EpDatagram;
import de.eibport.net.sftp.EibPortSftpException;
import de.eibport.net.sftp.FileInterface;
import de.eibport.net.sftp.KeyStorageStatic;
import de.eibport.net.sftp.SftpContainer;
import de.eibport.net.sftp.SftpTransfer;
import de.eibport.net.utils.ByteConv;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.NoRouteToHostException;
import java.net.SocketException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.swing.event.EventListenerList;
import org.jdom.DataConversionException;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class UpdateController {
    private static final int FCONT_MAGIC = 2114;
    private static final int FCONT_VERSION = 257;
    private static final int FCONT_FOOTER_ENTRY_TYPE_DIR = 42;
    private static final int FCONT_FOOTER_ENTRY_TYPE_DUMMY = 1;
    private static final int FCONT_MAX_DIR_ENTRIES = 16;
    private static final int FCONT_MAX_FILENAME_LENGTH = 31;
    public static final int RET_PREP_OK = 1;
    public static final int RET_PREP_WRONG_STRING = 2;
    public static final int RET_PREP_WRONG_ADMIN_PASSWD = 3;
    public static final int RET_PREP_CONNECTION_ERROR = 4;
    public static final int RET_TEST_INVALID_IMAGE = 1;
    public static final int RET_MD5_CHKSUM_OK = 1;
    public static final int RET_MD5_CHKSUM_ERROR = 2;
    public static final int RET_MD5_CHKSUM_FILE_NOT_FOUND = 3;
    public static final int RET_MD5_FW_FILE_NOT_FOUND = 4;
    public static final int RET_MD5_CHKSUM_UNABLE_TO_GENERATE = 5;
    public static final int RET_UPDATE_OK = 1;
    public static final int RET_UPDATE_CONNECTION_ERRROR = 2;
    public static final int RET_UPDATE_FILE_NOT_FOUND = 3;
    public static final String FILE_RESCUE_VERSION = "/config/rescue_version";
    public static final String FILE_START_RESCUE = "/config/START_RESCUE";
    public static final String FILE_UPDATE_FINISHED = "/home/bt1/ready";
    private EventListenerList listener = new EventListenerList();
    private DatagramSocket udpSocket = new DatagramSocket();

    public void addUpdateListener(UpdateListener updateListener) {
        this.listener.add(UpdateListener.class, updateListener);
    }

    public void removeUpdateListener(UpdateListener updateListener) {
        this.listener.remove(UpdateListener.class, updateListener);
    }

    private int startBootstrapInstall(String string, int n, FileInterface fileInterface) {
        for (UpdateListener updateListener : (UpdateListener[])this.listener.getListeners(UpdateListener.class)) {
            updateListener.preparationInstallingRescueSystem();
        }
        try {
            Object object;
            Object object22;
            Object object3;
            Object object4;
            ZipEntry zipEntry;
            InputStream dataConversionException = this.getClass().getResourceAsStream("/de/babtec/bootstrap/bootstrap");
            ZipInputStream zipInputStream = new ZipInputStream(dataConversionException);
            Document document = null;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ByteArrayInputStream byteArrayInputStream = null;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                int n2;
                byteArrayOutputStream.reset();
                object4 = new byte[1024];
                while ((n2 = zipInputStream.read((byte[])object4, 0, ((byte[])object4).length)) != -1) {
                    byteArrayOutputStream.write((byte[])object4, 0, n2);
                }
                if (zipEntry.getName().equals("index.xml")) {
                    object3 = new CipherInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()), this.getCipher(2));
                    document = new SAXBuilder().build((InputStream)object3);
                }
                if (!zipEntry.getName().equals("data")) continue;
                byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            }
            if (document == null || byteArrayOutputStream.size() == 0) {
                return -1;
            }
            object4 = document.getRootElement();
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            object3 = new HashMap();
            for (Object object22 : ((Element)object4).getChildren("category")) {
                System.out.println("Restore Cat: " + ((Element)object22).getAttributeValue("title"));
                for (Element element : ((Element)object22).getChildren("file")) {
                    object = new RestoreFile();
                    ((RestoreFile)object).filename = element.getAttributeValue("filename");
                    System.out.println("Restore File: " + ((RestoreFile)object).filename);
                    if (element.getAttributeValue("group") != null) {
                        ((RestoreFile)object).group = Integer.parseInt(element.getAttributeValue("group"));
                    }
                    if (element.getAttributeValue("owner") != null) {
                        ((RestoreFile)object).owner = Integer.parseInt(element.getAttributeValue("owner"));
                    }
                    if (element.getAttributeValue("permissions") != null) {
                        ((RestoreFile)object).permission = Integer.parseInt(element.getAttributeValue("permissions"));
                    }
                    hashMap.put(((RestoreFile)object).filename, object);
                }
            }
            CipherInputStream cipherInputStream = new CipherInputStream(byteArrayInputStream, this.getCipher(2));
            object22 = new ZipInputStream(cipherInputStream);
            Object object5 = EpDatagram.getConfigDatagram((short)64, (byte)3, "0");
            this.sendUDP((EpDatagram)object5, string, n);
            int n3 = 0;
            while ((zipEntry = ((ZipInputStream)object22).getNextEntry()) != null) {
                ++n3;
                object = zipEntry.getName();
                if (!hashMap.containsKey(object)) continue;
                RestoreFile restoreFile = (RestoreFile)hashMap.get(object);
                fileInterface.copy((InputStream)object22, (String)object);
                fileInterface.setGrpAndOwn((String)object, restoreFile.group, restoreFile.owner, false);
                if (restoreFile.permission == -1) continue;
                fileInterface.setPermissions((String)object, restoreFile.permission);
            }
            object5 = EpDatagram.getConfigDatagram((short)64, (byte)4, "0");
            this.sendUDP((EpDatagram)object5, string, n);
        }
        catch (DataConversionException noRouteToHostException) {
            noRouteToHostException.printStackTrace();
        }
        catch (NoRouteToHostException iOException) {
            iOException.printStackTrace();
        }
        catch (IOException jDOMException) {
            jDOMException.printStackTrace();
        }
        catch (JDOMException jDOMException) {
            jDOMException.printStackTrace();
        }
        return 1;
    }

    private Cipher getCipher(int n) {
        byte[] byArray = new byte[]{-128, 3, -41, -107, 30, -67, -25, 93};
        byte[] byArray2 = new byte[]{13, 91, -10, -48, -111, 54, -78, 113};
        try {
            Cipher cipher = Cipher.getInstance("Blowfish/CFB8/NoPadding");
            SecretKeySpec secretKeySpec = new SecretKeySpec(byArray2, "Blowfish");
            IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray);
            cipher.init(n, (Key)secretKeySpec, ivParameterSpec);
            return cipher;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public int startPreparation(Device device, String string, String string2) {
        EpDatagram epDatagram = device.getLastDatagram();
        String string3 = epDatagram.getHeader().getInetAddress("hIP").getHostAddress();
        short s = epDatagram.getBody().getPropertyShort("bPortSsh");
        short s2 = epDatagram.getBody().getPropertyShort("bPortBmx");
        short s3 = epDatagram.getBody().getPropertyShort("bPortUdp");
        for (UpdateListener updateListener : (UpdateListener[])this.listener.getListeners(UpdateListener.class)) {
            updateListener.preparationConnecting();
        }
        SftpContainer sftpContainer = new SftpContainer(string3, s, s2, "root");
        try {
            sftpContainer.init(string);
        }
        catch (EibPortSftpException eibPortSftpException) {
            for (UpdateListener updateListener : (UpdateListener[])this.listener.getListeners(UpdateListener.class)) {
                updateListener.preparationError(eibPortSftpException.getMessage());
            }
            eibPortSftpException.printStackTrace();
            return 2;
        }
        for (UpdateListener updateListener : (UpdateListener[])this.listener.getListeners(UpdateListener.class)) {
            updateListener.preparationLoggingIn();
        }
        boolean bl = false;
        DongleProtect dongleProtect = new DongleProtect();
        try {
            dongleProtect.init(null);
            int n = dongleProtect.getProperty(1, 4) ? 1 : 0;
            boolean bl2 = dongleProtect.getProperty(2, 4);
            int n2 = device.getLastDatagram().getBody().getPropertyInteger("bSernr");
            String string4 = new DecimalFormat("BT0000000000").format(n2);
            if (Utils.isEibPortSernr(string4) && n != 0) {
                bl = true;
            }
            if (Utils.isIpcSernr(string4) && bl2) {
                bl = true;
            }
        }
        catch (DPReadException dPReadException) {
        }
        catch (DPParseException dPParseException) {
        }
        catch (DongleProtectException dongleProtectException) {
            // empty catch block
        }
        ILoginUser iLoginUser = null;
        if (!bl) {
            UserPool userPool = new UserPool(sftpContainer.getFileInterface(), "/config/chroot/home/bt1/config/users.xml");
            iLoginUser = userPool.getUser("admin", string2);
        }
        if (bl || iLoginUser != null) {
            try {
                if (sftpContainer.getFileInterface().fileExists(FILE_RESCUE_VERSION)) {
                    sftpContainer.getFileInterface().writeToFile(FILE_START_RESCUE, new byte[]{0});
                    EpDatagram epDatagram2 = EpDatagram.getControlDatagram((short)64, (byte)1, (short)1);
                    this.sendUDP(epDatagram2, string3, s3);
                } else {
                    this.startBootstrapInstall(string3, s3, sftpContainer.getFileInterface());
                }
            }
            catch (NoRouteToHostException noRouteToHostException) {
                for (UpdateListener updateListener : (UpdateListener[])this.listener.getListeners(UpdateListener.class)) {
                    updateListener.preparationError(noRouteToHostException.getMessage());
                }
                noRouteToHostException.printStackTrace();
                return 2;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return 4;
            }
            device.setIgnoreSeconds(50);
            for (UpdateListener updateListener : (UpdateListener[])this.listener.getListeners(UpdateListener.class)) {
                updateListener.preparationRebootInResuceMode();
            }
            return 1;
        }
        for (UpdateListener updateListener : (UpdateListener[])this.listener.getListeners(UpdateListener.class)) {
            updateListener.preparationError("Wrong admin password");
        }
        return 3;
    }

    public int compareMD5Checksum(String string) {
        String string2;
        String string3;
        try {
            string3 = this.getMD5Checksum(string);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return 4;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
            return 5;
        }
        try {
            string2 = this.readMD5Checksum(string + ".md5");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return 3;
        }
        if (!string3.equals(string2)) {
            return 2;
        }
        return 1;
    }

    private String readMD5Checksum(String string) throws FileNotFoundException, IOException {
        FileInputStream fileInputStream = new FileInputStream(string);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
        String string2 = bufferedReader.readLine();
        return string2.substring(0, 32);
    }

    private String getMD5Checksum(String string) throws FileNotFoundException, IOException, NoSuchAlgorithmException {
        byte[] byArray = this.createChecksum(string);
        String string2 = "";
        for (int i = 0; i < byArray.length; ++i) {
            string2 = string2 + Integer.toString((byArray[i] & 0xFF) + 256, 16).substring(1);
        }
        return string2;
    }

    private byte[] createChecksum(String string) throws FileNotFoundException, IOException, NoSuchAlgorithmException {
        int n;
        FileInputStream fileInputStream = new FileInputStream(string);
        byte[] byArray = new byte[1024];
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        do {
            if ((n = ((InputStream)fileInputStream).read(byArray)) <= 0) continue;
            messageDigest.update(byArray, 0, n);
        } while (n != -1);
        ((InputStream)fileInputStream).close();
        return messageDigest.digest();
    }

    public String getTypeAndVersion(String string) {
        File file = new File(string);
        long l = file.length();
        if (l < 14L) {
            return null;
        }
        try {
            byte[] byArray;
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
            byte[] byArray2 = new byte[16];
            randomAccessFile.seek((int)l - byArray2.length);
            randomAccessFile.read(byArray2, 0, byArray2.length);
            if (ByteConv.byte2short(byArray2, 0) != 2114) {
                System.out.println("MAGIC DOES NOT FIT!");
                return null;
            }
            if (ByteConv.byte2short(byArray2, 2) != 257) {
                System.out.println("VERSION DOES NOT FIT!");
                return null;
            }
            int n = ByteConv.byte2long(byArray2, 4);
            int n2 = ByteConv.byte2long(byArray2, 8);
            byte[] byArray3 = new byte[6];
            randomAccessFile.seek(n);
            randomAccessFile.read(byArray3, 0, byArray3.length);
            int n3 = ByteConv.byte2short(byArray3, 0);
            int n4 = ByteConv.byte2long(byArray3, 2);
            int n5 = -1;
            int n6 = -1;
            if (n3 == 42) {
                byArray = new byte[n4];
                randomAccessFile.read(byArray, 0, byArray.length);
                int n7 = 0;
                int n8 = byArray[n7++] & 0xFF;
                int n9 = byArray[n7++] & 0xFF;
                for (int i = 0; i < n9; ++i) {
                    int n10 = ByteConv.byte2long(byArray, n7);
                    int n11 = ByteConv.byte2long(byArray, n7 += 4);
                    String string2 = new String(byArray, n7 += 4, 32).trim();
                    n7 += 32;
                    if (!"info".equals(string2)) continue;
                    n5 = n10;
                    n6 = n11;
                }
            }
            if (n5 == -1 || n6 == -1) {
                return null;
            }
            randomAccessFile.seek(n5);
            byArray = new byte[n6];
            randomAccessFile.read(byArray, 0, n6);
            return new String(byArray).trim();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return null;
    }

    public int startUpdate(Device device, String string) {
        EpDatagram epDatagram = device.getLastDatagram();
        String string2 = epDatagram.getHeader().getInetAddress("hIP").getHostAddress();
        short s = epDatagram.getBody().getPropertyShort("bPortSsh");
        short s2 = epDatagram.getBody().getPropertyShort("bPortBmx");
        for (UpdateListener object2 : (UpdateListener[])this.listener.getListeners(UpdateListener.class)) {
            object2.updateConnecting();
        }
        SftpContainer sftpContainer = new SftpContainer(string2, s, s2, "bt1");
        try {
            sftpContainer.init("2JX02fQqHz", new KeyStorageStatic());
        }
        catch (EibPortSftpException eibPortSftpException) {
            for (UpdateListener noRouteToHostException : (UpdateListener[])this.listener.getListeners(UpdateListener.class)) {
                noRouteToHostException.updateError(eibPortSftpException.getMessage());
            }
            eibPortSftpException.printStackTrace();
            return 2;
        }
        SftpTransfer sftpTransfer = (SftpTransfer)sftpContainer.getFileInterface();
        SftpProgressMonitor sftpProgressMonitor = new SftpProgressMonitor(){
            long max;
            long progress;

            @Override
            public void init(int n, String string, String string2, long l) {
                System.out.println(n + " " + string + " " + string2 + " " + l);
                this.max = l;
                this.progress = 0L;
                for (UpdateListener updateListener : (UpdateListener[])UpdateController.this.listener.getListeners(UpdateListener.class)) {
                    updateListener.updateUploadStarted(l);
                }
            }

            @Override
            public void end() {
                for (UpdateListener updateListener : (UpdateListener[])UpdateController.this.listener.getListeners(UpdateListener.class)) {
                    updateListener.updateUploadFinished();
                }
                System.out.println("end");
            }

            @Override
            public boolean count(long l) {
                this.progress += l;
                System.out.println("count: " + this.progress);
                for (UpdateListener updateListener : (UpdateListener[])UpdateController.this.listener.getListeners(UpdateListener.class)) {
                    updateListener.updateUploadProgress(this.progress, this.max);
                }
                return this.progress != this.max;
            }
        };
        for (UpdateListener updateListener : (UpdateListener[])this.listener.getListeners(UpdateListener.class)) {
            updateListener.updateTransferring();
        }
        String string3 = "/home/bt1/fw_image.bin";
        File file = new File(string);
        sftpProgressMonitor.init(0, string, string3, file.length());
        try {
            sftpTransfer.copy(new FileInputStream(file), string3, sftpProgressMonitor);
            sftpTransfer.mkdirs(FILE_UPDATE_FINISHED);
        }
        catch (NoRouteToHostException noRouteToHostException) {
            for (UpdateListener updateListener : (UpdateListener[])this.listener.getListeners(UpdateListener.class)) {
                updateListener.updateError(noRouteToHostException.getMessage());
            }
            noRouteToHostException.printStackTrace();
            return 2;
        }
        catch (FileNotFoundException fileNotFoundException) {
            for (UpdateListener updateListener : (UpdateListener[])this.listener.getListeners(UpdateListener.class)) {
                updateListener.updateError(fileNotFoundException.getMessage());
            }
            fileNotFoundException.printStackTrace();
            return 3;
        }
        device.setIgnoreSeconds(50);
        for (UpdateListener updateListener : (UpdateListener[])this.listener.getListeners(UpdateListener.class)) {
            updateListener.updateRebooting();
        }
        return 1;
    }

    public void startLedTest(Device device) throws IOException {
        EpDatagram epDatagram = device.getLastDatagram();
        String string = epDatagram.getHeader().getInetAddress("hIP").getHostAddress();
        short s = epDatagram.getBody().getPropertyShort("bPortUdp");
        EpDatagram epDatagram2 = EpDatagram.getControlDatagram((short)64, (byte)1, (short)0);
        this.sendUDP(epDatagram2, string, s);
    }

    public void sendUDP(EpDatagram epDatagram, String string, int n) throws IOException {
        byte[] byArray = epDatagram.getBytes();
        this.udpSocket.send(new DatagramPacket(byArray, byArray.length, InetAddress.getByName(string), n));
    }

    class RestoreFile {
        String filename;
        int group = -1;
        int owner = -1;
        int permission = -1;

        RestoreFile() {
        }
    }
}

