/*
 * Decompiled with CFR 0.152.
 */
package de.babtec.updatetool.discovery;

import de.babtec.updatetool.discovery.DeviceUpdateListener;
import de.eibport.net.mcast.packets.v2.EpDatagram;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class Device {
    private DeviceUpdateListener updateListener;
    private long lastBeaconTime;
    private long ignoreTime;
    private EpDatagram lastDatagram;
    private int reachable;
    private boolean rescueMode;
    private boolean active;

    public Device(EpDatagram epDatagram, DeviceUpdateListener deviceUpdateListener) {
        this.updateListener = deviceUpdateListener;
        this.rescueMode = epDatagram.isInRescueMode();
        this.reachable = epDatagram.isReachable();
        this.setNewDatagram(epDatagram);
    }

    public void setNewDatagram(EpDatagram epDatagram) {
        this.lastDatagram = epDatagram;
        this.lastBeaconTime = System.currentTimeMillis();
        this.active = true;
        if (this.rescueMode != epDatagram.isInRescueMode()) {
            this.rescueMode = epDatagram.isInRescueMode();
            this.updateListener.deviceUpdated(this, !epDatagram.isInRescueMode());
        }
        epDatagram.testReachable(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (Device.this.reachable != Device.this.lastDatagram.isReachable()) {
                    Device.this.reachable = Device.this.lastDatagram.isReachable();
                    Device.this.updateListener.deviceUpdated(Device.this, false);
                }
            }
        });
    }

    public void setIgnoreSeconds(int n) {
        this.ignoreTime = System.currentTimeMillis() + (long)(n * 1000);
        this.updateListener.deviceUpdated(this, false);
    }

    public void testTimeout(int n) {
        boolean bl;
        boolean bl2 = bl = System.currentTimeMillis() > this.ignoreTime && System.currentTimeMillis() - this.lastBeaconTime < (long)(n * 1000);
        if (bl != this.active) {
            this.active = bl;
            this.updateListener.deviceUpdated(this, false);
        }
    }

    public EpDatagram getLastDatagram() {
        return this.lastDatagram;
    }

    public int isReachable() {
        return this.reachable;
    }

    public boolean isInRescueMode() {
        return this.rescueMode;
    }

    public boolean isActive() {
        return this.active;
    }

    public String toString() {
        return this.lastDatagram.toString();
    }
}

