/*
 * Decompiled with CFR 0.152.
 */
package de.eibport.components;

import de.eibport.components.JButtonBar;
import de.eibport.net.bmx.BMXConnection;
import de.eibport.net.bmx.BMXConnectionHandler;
import de.eibport.net.bmx.BMXListenerAdapter;
import de.eibport.net.bmx.BMXPackets;
import de.eibport.utils.localization.Messages;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.text.MaskFormatter;

public class EpTimePanel
extends JPanel {
    public static String string_title = "Set eibPort Time";
    public static String string_current_title = "Current eibPort Time";
    public static String string_current_refresh = "Refresh";
    public static String string_new_title = "Set new eibPort time";
    public static String string_new_pc_time = "PC Time";
    public static String string_new_set = "Set";
    public static String string_ok = "OK";
    private JFormattedTextField eibPortTime;
    private JFormattedTextField setTime;
    private BMXConnection bmxCon;

    public static void adoptLocalization(Messages messages) {
        string_title = messages.getString("clock.dialog.title");
        string_current_title = messages.getString("clock.dialog.current.time");
        string_current_refresh = messages.getString("clock.dialog.current.refresh");
        string_new_title = messages.getString("clock.dialog.new.time");
        string_new_pc_time = messages.getString("clock.dialog.new.pc_time");
        string_new_set = messages.getString("clock.dialog.new.set");
        string_ok = messages.getString("clock.dialog.ok");
    }

    public EpTimePanel(BMXConnectionHandler bMXConnectionHandler) {
        Insets insets;
        this.bmxCon = bMXConnectionHandler.getBMXConnection();
        try {
            MaskFormatter maskFormatter = new MaskFormatter("##.##.#### ##:##:##");
            maskFormatter.setPlaceholderCharacter('_');
            this.eibPortTime = new JFormattedTextField(maskFormatter);
            this.setTime = new JFormattedTextField(maskFormatter);
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
        }
        this.eibPortTime.setEditable(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.setLayout(new GridBagLayout());
        gridBagConstraints.insets = insets = new Insets(2, 3, 2, 3);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        this.add((Component)new JLabel(string_current_title), gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 1;
        this.add((Component)this.eibPortTime, gridBagConstraints);
        JButton jButton = new JButton(string_current_refresh);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EpTimePanel.this.refreshEpTime();
            }
        });
        gridBagConstraints.gridx = 1;
        this.add((Component)jButton, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(8, 0, 8, 0);
        this.add((Component)new JSeparator(), gridBagConstraints);
        gridBagConstraints.insets = insets;
        ++gridBagConstraints.gridy;
        this.add((Component)new JLabel(string_new_title), gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)this.setTime, gridBagConstraints);
        JButton jButton2 = new JButton(string_new_set);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EpTimePanel.this.setNewTime();
            }
        });
        gridBagConstraints.gridx = 1;
        this.add((Component)jButton2, gridBagConstraints);
        JButton jButton3 = new JButton(string_new_pc_time);
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
                EpTimePanel.this.setTime.setText(simpleDateFormat.format(new Date()));
                EpTimePanel.this.setNewTime();
            }
        });
        ++gridBagConstraints.gridy;
        this.add((Component)jButton3, gridBagConstraints);
        this.setPreferredSize(new Dimension(400, this.getPreferredSize().height));
        this.refreshEpTime();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
        this.setTime.setText(simpleDateFormat.format(new Date()));
    }

    private void refreshEpTime() {
        this.bmxCon.addBMXListener(new BMXListenerAdapter(){

            @Override
            public void getSystem(int n, String string) {
                if (n != 1) {
                    return;
                }
                if (string.length() == 17) {
                    string = string.substring(0, 5) + "20" + string.substring(6, string.length());
                }
                EpTimePanel.this.eibPortTime.setText(string);
                EpTimePanel.this.bmxCon.removeBMXListener(this);
            }
        });
        this.bmxCon.sendPacket(BMXPackets.constructGetSystem(1, "Command"));
    }

    private void setNewTime() {
        this.bmxCon.sendPacket(BMXPackets.constructSetSystem(1, this.setTime.getText()));
        this.refreshEpTime();
    }

    public static void openDialog(Frame frame, BMXConnectionHandler bMXConnectionHandler) {
        final JDialog jDialog = new JDialog(frame, string_title, true);
        AbstractAction abstractAction = new AbstractAction("Ok"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.setVisible(false);
            }
        };
        JButtonBar jButtonBar = new JButtonBar();
        jButtonBar.setRightButtons(abstractAction);
        jDialog.getContentPane().setLayout(new BorderLayout());
        jDialog.getContentPane().add((Component)new EpTimePanel(bMXConnectionHandler), "Center");
        jDialog.getContentPane().add((Component)jButtonBar, "South");
        jDialog.pack();
        jDialog.setLocationRelativeTo(frame);
        jDialog.setVisible(true);
    }
}

