/*
 * Decompiled with CFR 0.152.
 */
package de.eibport.components.about;

import de.eibport.components.JButtonBar;
import de.eibport.net.HostInformation;
import de.eibport.utils.localization.Messages;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class AboutBox
extends JPanel {
    public static String LABEL_NAME = "Name";
    public static String LABEL_FIRMWARE = "Firmware Version";
    public static String LABEL_SERIALNR = "Serial Number";
    public static String LABEL_IPADDRESS = "IP Address";
    public static String LABEL_PORT_HTTP = "HTTP Port";
    public static String LABEL_PORT_SSH = "SSH Port";
    public static String LABEL_PORT_BMX_TCP = "BMX TCP Port";
    public static String LABEL_PORT_BMX_UDP = "BMX UDP Port";
    public static String LABEL_JAVA_VERSION = "Client Java";
    private GridBagConstraints gbc;

    public AboutBox(HostInformation hostInformation) {
        this.setBackground(Color.WHITE);
        this.setLayout(new GridBagLayout());
        this.gbc = new GridBagConstraints();
        this.gbc.fill = 2;
        this.gbc.weightx = 1.0;
        this.gbc.gridy = 0;
        this.gbc.insets = new Insets(10, 0, 10, 0);
        this.gbc.gridwidth = 2;
        ImageIcon imageIcon = new ImageIcon(this.getClass().getClassLoader().getResource("de/eibport/components/about/AboutEibPort.png"));
        this.add((Component)new JLabel(imageIcon, 0), this.gbc);
        ++this.gbc.gridy;
        this.gbc.gridwidth = 1;
        this.add(LABEL_NAME, hostInformation.getEpName());
        this.add(LABEL_FIRMWARE, hostInformation.getFwVersion());
        this.add(LABEL_SERIALNR, hostInformation.getSernr());
        this.add(LABEL_IPADDRESS, hostInformation.getHost().getHostAddress());
        this.add(LABEL_PORT_HTTP, Integer.toString(hostInformation.getHttpPort()));
        this.add(LABEL_PORT_SSH, Integer.toString(hostInformation.getSshPort()));
        this.add(LABEL_PORT_BMX_TCP, Integer.toString(hostInformation.getBmxTcpPort()));
        this.add(LABEL_PORT_BMX_UDP, Integer.toString(hostInformation.getBmxUdpPort()));
        this.add(LABEL_JAVA_VERSION, System.getProperty("java.version"));
    }

    public static void adoptLocalization(Messages messages) {
        LABEL_NAME = messages.getString("global.about.ep.name");
        LABEL_FIRMWARE = messages.getString("global.about.ep.firmware");
        LABEL_SERIALNR = messages.getString("global.about.ep.serialnr");
        LABEL_IPADDRESS = messages.getString("global.about.ep.ipaddress");
        LABEL_PORT_HTTP = messages.getString("global.about.ep.http.port");
        LABEL_PORT_SSH = messages.getString("global.about.ep.ssh.port");
        LABEL_PORT_BMX_TCP = messages.getString("global.about.ep.bmxtcp.port");
        LABEL_PORT_BMX_UDP = messages.getString("global.about.ep.bmxudp.port");
        LABEL_JAVA_VERSION = messages.getString("global.about.client.version");
    }

    private void add(String string, String string2) {
        this.gbc.insets = new Insets(5, 5, 5, 0);
        this.gbc.gridx = 0;
        this.add((Component)new JLabel(string, 2), this.gbc);
        this.gbc.insets = new Insets(5, 20, 5, 5);
        this.gbc.gridx = 1;
        this.add((Component)new JLabel(string2, 2), this.gbc);
        ++this.gbc.gridy;
    }

    public static void showDialog(Frame frame, HostInformation hostInformation) {
        final JDialog jDialog = new JDialog(frame, "About", true);
        jDialog.getContentPane().setLayout(new BorderLayout());
        jDialog.getContentPane().add((Component)new AboutBox(hostInformation), "Center");
        AbstractAction abstractAction = new AbstractAction("OK"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.setVisible(false);
                jDialog.dispose();
            }
        };
        JButtonBar jButtonBar = new JButtonBar();
        jButtonBar.setRightButtons(abstractAction);
        jDialog.getContentPane().add((Component)jButtonBar, "South");
        jDialog.pack();
        jDialog.setLocationRelativeTo(frame);
        jDialog.setVisible(true);
    }
}

