/*
 * Decompiled with CFR 0.152.
 */
package de.eibport.components.addressfield;

import de.eibport.components.addressfield.esfdata.ESFData;
import de.eibport.components.addressfield.esfdata.ESFElement;
import de.eibport.components.addressfield.esfdata.MainGroup;
import de.eibport.components.addressfield.esfdata.MiddleGroup;
import de.eibport.components.jtreetable.AbstractTreeTableModel;
import de.eibport.components.jtreetable.TreeTableModel;
import de.eibport.net.bmx.eibaddress2.EIBAddressFormat;

public class EsfTreeTableModel
extends AbstractTreeTableModel {
    protected static String[] cNames = new String[]{"Names", "GroupAddress", "DataType"};
    protected static Class[] cTypes = new Class[]{TreeTableModel.class, String.class, String.class};
    private ESFData esfData;

    public EsfTreeTableModel(ESFData eSFData) {
        super(eSFData);
        this.esfData = eSFData;
    }

    private Object[] getChildren(Object object) {
        if (object instanceof ESFData) {
            return ((ESFData)object).getFilledMainGroups();
        }
        if (object instanceof MainGroup) {
            if (EIBAddressFormat.is3Layer()) {
                return this.esfData.getFilledMiddleGroups(((MainGroup)object).index);
            }
            return this.esfData.getElementsInGroup(((MainGroup)object).index);
        }
        if (object instanceof MiddleGroup) {
            MiddleGroup middleGroup = (MiddleGroup)object;
            return this.esfData.getElementsInGroup(middleGroup.main, middleGroup.index);
        }
        return null;
    }

    @Override
    public boolean isCellEditable(Object object, int n) {
        return object instanceof ESFElement && n == 2 || super.isCellEditable(object, n);
    }

    @Override
    public int getChildCount(Object object) {
        Object[] objectArray = this.getChildren(object);
        return objectArray == null ? 0 : objectArray.length;
    }

    @Override
    public Object getChild(Object object, int n) {
        if (n == -1) {
            return null;
        }
        Object[] objectArray = this.getChildren(object);
        return objectArray == null || n >= objectArray.length ? null : objectArray[n];
    }

    @Override
    public boolean isLeaf(Object object) {
        return object instanceof ESFElement;
    }

    @Override
    public int getColumnCount() {
        return cNames.length;
    }

    @Override
    public String getColumnName(int n) {
        return cNames[n];
    }

    @Override
    public Class getColumnClass(int n) {
        return cTypes[n];
    }

    @Override
    public Object getValueAt(Object object, int n) {
        if (object instanceof ESFData && n == 0) {
            ((ESFData)object).getTitle();
        }
        if (object instanceof MainGroup && n == 0) {
            return ((MainGroup)object).title;
        }
        if (object instanceof MiddleGroup && n == 0) {
            return ((MiddleGroup)object).title;
        }
        if (object instanceof ESFElement) {
            ESFElement eSFElement = (ESFElement)object;
            switch (n) {
                case 0: {
                    return eSFElement.getTitle();
                }
                case 1: {
                    return eSFElement.getAddress().getStrAddress();
                }
                case 2: {
                    return eSFElement.getDataType();
                }
            }
        }
        return null;
    }

    public void reloadModel() {
        this.fireTreeStructureChanged(this, new Object[]{this.root}, null, null);
    }
}

