/*
 * Decompiled with CFR 0.152.
 */
package de.eibport.components.addressfield;

import de.eibport.components.JButtonBar;
import de.eibport.components.addressfield.JAddressSelector;
import de.eibport.components.addressfield.JEsfPane;
import de.eibport.components.addressfield.esfdata.ESFAddressObject;
import de.eibport.components.addressfield.esfdata.ESFData;
import de.eibport.components.addressfield.esfdata.ESFElement;
import de.eibport.components.ssh.JSshUnlockButton;
import de.eibport.net.bmx.eibaddress2.EIBAddress2;
import de.eibport.net.sftp.SftpContainer;
import de.eibport.utils.localization.Messages;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;

public class JAddressDialog
extends JDialog {
    public static String string_title = "Choose Address";
    public static String string_maingroup = "Maingroup";
    public static String string_maingroup_eib = "EIB Maingroup";
    public static String string_maingroup_virtual = "Virtual Maingroup";
    public static String string_middlegroup = "Middlegroup";
    public static String string_subgroup = "Subgroup";
    public static String string_address_eib = "EIB Address";
    public static String string_address = "Address";
    public static String string_address_3layers = "Adressen 3 Ebenen";
    public static String string_address_selected = "Ausgew\u00e4hlte Adressen";
    public static String string_address_tosender = "Make address to sender";
    public static String string_address_remove = "Remove Address";
    public static String string_datatype = "DataType";
    public static String string_ok = "OK";
    public static String string_cancel = "Cancel";
    public static String string_unlock = "Unlock";
    public static String string_tab_esf = "ESF Data";
    public static String string_tab_matrix = "Matrix";
    private static final Color TABLE_MARKING_COLOR = new Color(205, 225, 255);
    private ESFData esfData;
    private String[] esfColumnNames = new String[]{string_maingroup, string_middlegroup, string_subgroup, string_address_eib, string_datatype};
    private int matrixRows = 128;
    private JLabel currentAddressLabel = new JLabel("", 2);
    private ActionListener actionListener;
    private ESFAddressObject addresses;
    private DefaultTableModel currentAddressModel;
    private JTable currentAddresses;
    private JTabbedPane tp = new JTabbedPane();
    private JButtonBar buttons;
    private JEsfPane esfp;
    private AbstractAction actionOk;
    private AbstractAction actionCancel;
    private JSshUnlockButton actionUnlock;
    private static JAddressDialog dialog = null;

    public static void adoptLocalization(Messages messages) {
        string_title = messages.getString("address.dialog.title");
        string_maingroup = messages.getString("address.dialog.maingroup");
        string_maingroup_eib = messages.getString("address.dialog.maingroup_eib");
        string_maingroup_virtual = messages.getString("address.dialog.maingroup_virtual");
        string_middlegroup = messages.getString("address.dialog.middlegroup");
        string_subgroup = messages.getString("address.dialog.subgroup");
        string_address_eib = messages.getString("address.dialog.address_eib");
        string_address = messages.getString("address.dialog.address");
        string_address_3layers = messages.getString("address.dialog.address.3layers");
        string_address_selected = messages.getString("address.dialog.address.selected");
        string_address_tosender = messages.getString("address.dialog.address.tosender");
        string_address_remove = messages.getString("address.dialog.address.remove");
        string_datatype = messages.getString("address.dialog.eis_type");
        string_ok = messages.getString("address.dialog.ok");
        string_cancel = messages.getString("address.dialog.cancel");
        string_unlock = messages.getString("address.dialog.unlock");
        string_tab_esf = messages.getString("address.dialog.tab.esf");
        string_tab_matrix = messages.getString("address.dialog.tab.matrix");
        JAddressSelector.string_choose_address = messages.getString("address.dialog.choose_address");
    }

    private JAddressDialog(ESFData eSFData) {
        super(JOptionPane.getRootFrame(), string_title, true);
        this.esfData = eSFData;
        this.currentAddressModel = new DefaultTableModel(){

            @Override
            public int getRowCount() {
                if (JAddressDialog.this.addresses != null) {
                    return JAddressDialog.this.addresses.getMaxSize();
                }
                return 0;
            }

            @Override
            public int getColumnCount() {
                return 7;
            }

            @Override
            public Object getValueAt(int n, int n2) {
                String string = null;
                EIBAddress2 eIBAddress2 = JAddressDialog.this.addresses.getAddress(n);
                if (eIBAddress2 != null && JAddressDialog.this.esfData == null && n2 == 5) {
                    string = eIBAddress2.getStrAddress();
                }
                if (eIBAddress2 != null && JAddressDialog.this.esfData != null) {
                    ESFElement eSFElement = JAddressDialog.this.esfData.getElementByAddress(eIBAddress2.getIntAddress());
                    if (eSFElement == null) {
                        if (n2 == 5) {
                            string = eIBAddress2.getStrAddress();
                        }
                    } else {
                        switch (n2) {
                            case 2: {
                                string = JAddressDialog.this.esfData.getMainName(eSFElement);
                                break;
                            }
                            case 3: {
                                string = JAddressDialog.this.esfData.getMiddleName(eSFElement);
                                break;
                            }
                            case 4: {
                                string = eSFElement.getTitle();
                                break;
                            }
                            case 5: {
                                string = eSFElement.getAddress().getStrAddress();
                                break;
                            }
                            case 6: {
                                string = eSFElement.getDataType().toString();
                            }
                        }
                    }
                }
                return string;
            }

            public Class getColumnClass(int n) {
                Object object = this.getValueAt(0, n);
                if (object == null) {
                    return String.class;
                }
                return object.getClass();
            }

            @Override
            public String getColumnName(int n) {
                String string = n < 2 ? "" : JAddressDialog.this.esfColumnNames[n - 2];
                return string;
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        final ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("tableDelete.gif"));
        final ImageIcon imageIcon2 = new ImageIcon(this.getClass().getResource("tableSend.gif"));
        this.currentAddresses = new JTable(this.currentAddressModel){

            @Override
            public TableCellRenderer getCellRenderer(int n, int n2) {
                DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer();
                if (n == 0) {
                    defaultTableCellRenderer.setBackground(TABLE_MARKING_COLOR);
                }
                if (n2 == 0 && n < JAddressDialog.this.addresses.getAddressCount()) {
                    defaultTableCellRenderer.setIcon(imageIcon);
                    defaultTableCellRenderer.setToolTipText(string_address_remove);
                }
                if (n2 == 1 && n < JAddressDialog.this.addresses.getAddressCount()) {
                    defaultTableCellRenderer.setIcon(imageIcon2);
                    defaultTableCellRenderer.setToolTipText(string_address_tosender);
                }
                if (JAddressDialog.this.addresses != null && n >= JAddressDialog.this.addresses.getMaxSize()) {
                    defaultTableCellRenderer.setBackground(Color.LIGHT_GRAY);
                }
                return defaultTableCellRenderer;
            }
        };
        this.currentAddresses.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int n = JAddressDialog.this.currentAddresses.getSelectedRow();
                if (n < JAddressDialog.this.addresses.getAddressCount()) {
                    int n2 = JAddressDialog.this.currentAddresses.getSelectedColumn();
                    if (n2 == 0) {
                        JAddressDialog.this.addresses.removeAddress(n);
                    }
                    if (n2 == 1) {
                        JAddressDialog.this.addresses.makeMaster(n);
                    }
                    JAddressDialog.this.currentAddresses.repaint();
                }
            }
        });
        this.currentAddresses.setCellSelectionEnabled(false);
        this.currentAddresses.getColumnModel().getColumn(0).setPreferredWidth(imageIcon.getIconWidth() + 2);
        this.currentAddresses.getColumnModel().getColumn(0).setResizable(false);
        this.currentAddresses.getColumnModel().getColumn(1).setPreferredWidth(imageIcon2.getIconWidth() + 2);
        this.currentAddresses.getColumnModel().getColumn(1).setResizable(false);
        this.setLayout(new BorderLayout());
        this.esfp = new JEsfPane(eSFData);
        this.esfp.getESFTreeTable().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                ESFElement eSFElement;
                if (mouseEvent.getClickCount() >= 2 && (eSFElement = JAddressDialog.this.esfp.getESFTreeTable().getSelectedObject()) != null) {
                    JAddressDialog.this.addressSelected(eSFElement.getAddress());
                }
            }
        });
        this.esfp.setBorder(BorderFactory.createTitledBorder(string_tab_esf));
        this.tp.addTab(string_tab_esf, this.esfp);
        JPanel jPanel = this.getMatrixPane();
        jPanel.setBorder(BorderFactory.createTitledBorder(string_tab_matrix));
        this.tp.addTab(string_tab_matrix, jPanel);
        this.add((Component)this.tp, "Center");
        this.currentAddressLabel.setOpaque(true);
        this.buttons = new JButtonBar();
        this.actionOk = new AbstractAction(string_ok){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (JAddressDialog.this.actionListener == null) {
                    JAddressDialog.this.setVisible(false);
                } else {
                    JAddressDialog.this.actionListener.actionPerformed(actionEvent);
                }
            }
        };
        this.actionCancel = new AbstractAction(string_cancel){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JAddressDialog.this.setVisible(false);
            }
        };
        this.buttons.setRightButtons(this.actionOk, this.actionCancel);
        this.actionUnlock = new JSshUnlockButton(string_unlock);
        this.tp.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (JAddressDialog.this.tp.getSelectedComponent().equals(JAddressDialog.this.esfp)) {
                    JAddressDialog.this.buttons.setLeftButtons(JAddressDialog.this.actionUnlock);
                } else {
                    JAddressDialog.this.buttons.setLeftButtons(new Object[0]);
                }
            }
        });
        if (this.tp.getSelectedComponent().equals(this.esfp)) {
            this.buttons.setLeftButtons(this.actionUnlock);
        } else {
            this.buttons.setLeftButtons(new Object[0]);
        }
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(this.currentAddresses);
        jScrollPane.setBorder(BorderFactory.createTitledBorder(string_address_selected));
        jPanel2.add((Component)jScrollPane, "North");
        jPanel2.add((Component)this.buttons, "South");
        this.add((Component)jPanel2, "South");
        this.pack();
        this.setSize(new Dimension(640, 600));
    }

    public void update(ESFAddressObject eSFAddressObject, ESFData eSFData, ActionListener actionListener, SftpContainer sftpContainer) {
        this.addresses = eSFAddressObject;
        this.esfData = eSFData;
        this.actionListener = actionListener;
        this.actionUnlock.setSftpContainer(sftpContainer);
        this.actionUnlock.setVisible(sftpContainer != null);
        this.esfp.setSftpContainer(sftpContainer);
        this.currentAddresses.setPreferredScrollableViewportSize(new Dimension(200, this.currentAddresses.getRowHeight() * eSFAddressObject.getMaxSize()));
    }

    public void addressSelected(EIBAddress2 eIBAddress2) {
        this.addresses.addAddress(eIBAddress2);
        this.currentAddressModel.fireTableDataChanged();
    }

    public ESFAddressObject getCurrentAddresses() {
        return this.addresses;
    }

    private JPanel getMatrixPane() {
        String[] stringArray = new String[]{string_maingroup_eib + " 00", string_maingroup_eib + " 01", string_maingroup_eib + " 02", string_maingroup_eib + " 03", string_maingroup_eib + " 04", string_maingroup_eib + " 05", string_maingroup_eib + " 06", string_maingroup_eib + " 07", string_maingroup_eib + " 08", string_maingroup_eib + " 09", string_maingroup_eib + " 10", string_maingroup_eib + " 11", string_maingroup_eib + " 12", string_maingroup_eib + " 13", string_maingroup_eib + " 14", string_maingroup_eib + " 15", string_maingroup_virtual + " 16", string_maingroup_virtual + " 17", string_maingroup_virtual + " 18", string_maingroup_virtual + " 19", string_maingroup_virtual + " 20", string_maingroup_virtual + " 21", string_maingroup_virtual + " 22", string_maingroup_virtual + " 23", string_maingroup_virtual + " 24", string_maingroup_virtual + " 25", string_maingroup_virtual + " 26", string_maingroup_virtual + " 27", string_maingroup_virtual + " 28", string_maingroup_virtual + " 29", string_maingroup_virtual + " 30", string_maingroup_virtual + " 31"};
        String[] stringArray2 = new String[]{string_middlegroup + " 00", string_middlegroup + " 01", string_middlegroup + " 02", string_middlegroup + " 03", string_middlegroup + " 04", string_middlegroup + " 05", string_middlegroup + " 06", string_middlegroup + " 07"};
        final JComboBox<String> jComboBox = new JComboBox<String>(stringArray);
        final JComboBox<String> jComboBox2 = new JComboBox<String>(stringArray2);
        final JCheckBox jCheckBox = new JCheckBox(string_address_3layers);
        DefaultTableModel defaultTableModel = new DefaultTableModel(){

            @Override
            public Object getValueAt(int n, int n2) {
                return new Integer(n * 16 + n2);
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }

            @Override
            public int getRowCount() {
                return JAddressDialog.this.matrixRows;
            }

            @Override
            public int getColumnCount() {
                return 16;
            }

            public Class getColumnClass(int n) {
                return Integer.class;
            }
        };
        final JTable jTable = new JTable(defaultTableModel){

            @Override
            public TableCellRenderer getCellRenderer(int n, int n2) {
                int n3;
                DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer();
                int n4 = jComboBox.getSelectedIndex();
                if (!jCheckBox.isSelected()) {
                    n3 = n4 << 11 | n << 4 | n2;
                } else {
                    int n5 = jComboBox2.getSelectedIndex();
                    n3 = n4 << 11 | n5 << 8 | n << 4 | n2;
                }
                ESFElement eSFElement = null;
                if (JAddressDialog.this.esfData != null) {
                    eSFElement = JAddressDialog.this.esfData.getElementByAddress(n3);
                }
                if (eSFElement != null) {
                    defaultTableCellRenderer.setBackground(TABLE_MARKING_COLOR);
                    String string = "<html>" + JAddressDialog.this.esfData.getMainName(eSFElement) + "<UL>" + "<LI>" + eSFElement.getTitle() + "</LI>" + "</UL>" + "<B>" + string_address + "</B>: " + eSFElement.getAddress().getStrAddress() + "<BR>" + "<B>" + string_datatype + "</B>: " + eSFElement.getDataType().toString() + "</html>";
                    defaultTableCellRenderer.setToolTipText(string);
                }
                if (n3 == 0) {
                    defaultTableCellRenderer.setBackground(Color.GRAY);
                }
                defaultTableCellRenderer.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
                return defaultTableCellRenderer;
            }
        };
        jTable.setSelectionMode(0);
        jTable.setColumnSelectionAllowed(true);
        jTable.setRowSelectionAllowed(true);
        jTable.setTableHeader(null);
        jTable.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() >= 2) {
                    int n = jComboBox.getSelectedIndex();
                    int n2 = jComboBox2.getSelectedIndex();
                    int n3 = jTable.getSelectedRow() << 4 | jTable.getSelectedColumn();
                    if (!jCheckBox.isSelected()) {
                        if (n != 0 || n3 != 0) {
                            JAddressDialog.this.addresses.addAddress(EIBAddress2.getAddress(n, n3));
                        }
                    } else {
                        int n4 = jComboBox2.getSelectedIndex();
                        if (n != 0 || n4 != 0 || n3 != 0) {
                            JAddressDialog.this.addresses.addAddress(EIBAddress2.getAddress(n, n2, n3));
                        }
                    }
                    JAddressDialog.this.currentAddressModel.fireTableDataChanged();
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
            }
        });
        jComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                jTable.repaint();
            }
        });
        jComboBox2.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                jTable.repaint();
            }
        });
        jCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                boolean bl = jCheckBox.isSelected();
                jComboBox2.setVisible(bl);
                if (bl) {
                    JAddressSelector.ADDRESSLAYERS = 3;
                    JAddressDialog.this.matrixRows = 16;
                } else {
                    JAddressSelector.ADDRESSLAYERS = 2;
                    JAddressDialog.this.matrixRows = 128;
                }
                jTable.repaint();
            }
        });
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(jComboBox);
        jPanel2.add(Box.createHorizontalGlue());
        jPanel2.add(jComboBox2);
        jPanel2.add(Box.createHorizontalGlue());
        jPanel2.add(jCheckBox);
        jComboBox2.setVisible(false);
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(jPanel2);
        jPanel.add(new JScrollPane(jTable));
        if (JAddressSelector.ADDRESSLAYERS == 3) {
            jCheckBox.setSelected(true);
        }
        return jPanel;
    }

    public static JAddressDialog getAddressDialog(ESFAddressObject eSFAddressObject, ESFData eSFData, ActionListener actionListener, SftpContainer sftpContainer) {
        if (dialog == null) {
            dialog = new JAddressDialog(eSFData);
        }
        dialog.update(eSFAddressObject, eSFData, actionListener, sftpContainer);
        return dialog;
    }

    public static void disposeStatic() {
        if (dialog != null) {
            dialog.dispose();
            dialog = null;
        }
    }
}

