/*
 * Decompiled with CFR 0.152.
 */
package de.eibport.components.addressfield;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.eibport.components.MyTextField;
import de.eibport.components.addressfield.esfdata.ESFData;
import de.eibport.components.addressfield.esfdata.ESFElement;
import de.eibport.components.addressfield.esfdata.ESFFactory;
import de.eibport.components.addressfield.esfdata.ESFTreeTable;
import de.eibport.components.addressfield.esfdata.MainGroup;
import de.eibport.components.addressfield.esfdata.MiddleGroup;
import de.eibport.components.esfmerge.ESFMergePanel;
import de.eibport.net.bmx.eibaddress2.EIBAddress2;
import de.eibport.net.bmx.eibaddress2.EIBAddressFormat;
import de.eibport.net.sftp.SftpContainer;
import de.eibport.net.sftp.SftpContainerListener;
import de.eibport.utils.localization.Messages;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.net.MalformedURLException;
import java.net.NoRouteToHostException;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class JEsfPane
extends JComponent {
    public static String STRING_MAINGROUP = "Maingroup";
    public static String STRING_MIDDLEGROUP = "Middlegroup";
    public static String STRING_SUBGROUP = "Subgroup";
    public static String STRING_ADDRESS = "Groupaddress";
    public static String STRING_EISTYPE = "EIS-Type";
    public static String STRING_ADDRESS_INVALID = "The address is invalid.";
    public static String STRING_COLLAPSE_TREE = "Collapse Tree";
    public static String STRING_EXPAND_TREE = "Expand Tree";
    public static String STRING_EXPAND_NODE = "Expand Node";
    public static String STRING_UNLOCK = "Unlock";
    public static String STRING_ADD_DATA = "Add Data";
    public static String STRING_EDIT_DATA = "Edit Data";
    public static String STRING_DELETE_DATA = "Delete Data";
    public static String STRING_DELETE_DATA_CONFIRM = "Really delete this entry?";
    public static String STRING_BACKUP_FILE = "Backup ESFx File";
    public static String STRING_UPLOAD_FILE = "Upload ESF File";
    public static String STRING_MERGE_FILE = "Merge ESF File";
    public static String STRING_SAVE_FILE = "Save ESF Data";
    public static String STRING_SAVE_AND_CLOSE = "Save & Close";
    public static String STRING_ADDRESS_EXISTS = "This address already exists.";
    public static String STRING_CHANGE_MAINGROUP = "Change the name of the main group from";
    public static String STRING_CHANGE_MIDDLEGROUP = "Change the name of the middle group from";
    public static String STRING_GENERATING_FAILED = "Unable to generate new esf file.";
    public static String STRING_DOWNLOAD_FAILED_CLIENT = "Unable to write to that file.";
    public static String STRING_DOWNLOAD_FAILED_SERVER = "Unable to download file from eibPort.";
    public static String STRING_UPLOAD_FAILED_CLIENT = "Unable to read from that file.";
    public static String STRING_UPLOAD_FAILED_SERVER = "Unable to upload file to eibPort.";
    public static String STRING_BUTTON_OK = "OK";
    public static String STRING_BUTTON_CANCEL = "Cancel";
    private static final int TABLE_COLUMNS_MAINGROUP = 0;
    private static final int TABLE_COLUMNS_MIDDLEGROUP = 1;
    private static final int TABLE_COLUMNS_SUBGROUP = 2;
    private static final int TABLE_COLUMNS_ADDRESS = 3;
    private static final int TABLE_COLUMNS_DATATYPE = 4;
    private SftpContainer sftpContainer;
    private SftpContainerListener sftpContainerListener;
    private ESFData esfData;
    private ESFTreeTable treeTable;
    private Box controls;
    private AbstractAction collapseTree;
    private AbstractAction expandTree;
    private AbstractAction expandNode;
    private AbstractAction addEsfData;
    private AbstractAction editEsfData;
    private AbstractAction deleteEsfData;
    private AbstractAction backupEsfFile;
    private AbstractAction uploadEsfFile;
    private AbstractAction mergeEsfFile;

    public static void adoptLocalization(Messages messages) {
        STRING_MAINGROUP = messages.getString("esf.dialog.maingroup");
        STRING_MIDDLEGROUP = messages.getString("esf.dialog.middlegroup");
        STRING_SUBGROUP = messages.getString("esf.dialog.subgroup");
        STRING_ADDRESS = messages.getString("esf.dialog.address");
        STRING_EISTYPE = messages.getString("esf.dialog.eistype");
        STRING_COLLAPSE_TREE = messages.getString("esf.dialog.collapse_tree");
        STRING_EXPAND_TREE = messages.getString("esf.dialog.expand_tree");
        STRING_EXPAND_NODE = messages.getString("esf.dialog.expand_node");
        STRING_UNLOCK = messages.getString("esf.dialog.unlock");
        STRING_ADD_DATA = messages.getString("esf.dialog.add_data");
        STRING_EDIT_DATA = messages.getString("esf.dialog.edit_data");
        STRING_DELETE_DATA = messages.getString("esf.dialog.delete_data");
        STRING_DELETE_DATA_CONFIRM = messages.getString("esf.dialog.delete_data.confirm");
        STRING_BACKUP_FILE = messages.getString("esf.dialog.backup_file");
        STRING_UPLOAD_FILE = messages.getString("esf.dialog.upload_file");
        STRING_MERGE_FILE = messages.getString("esf.dialog.merge_file");
        STRING_SAVE_FILE = messages.getString("esf.dialog.save_file");
        STRING_SAVE_AND_CLOSE = messages.getString("esf.dialog.save_and_close");
        STRING_ADDRESS_INVALID = messages.getString("esf.dialog.address_invalid");
        STRING_ADDRESS_EXISTS = messages.getString("esf.dialog.address_exists");
        STRING_CHANGE_MAINGROUP = messages.getString("esf.dialog.change.maingroup");
        STRING_CHANGE_MIDDLEGROUP = messages.getString("esf.dialog.change.middlegroup");
        STRING_GENERATING_FAILED = messages.getString("esf.dialog.generation_failed");
        STRING_DOWNLOAD_FAILED_CLIENT = messages.getString("esf.dialog.download.failed_client");
        STRING_DOWNLOAD_FAILED_SERVER = messages.getString("esf.dialog.download.failed_server");
        STRING_UPLOAD_FAILED_CLIENT = messages.getString("esf.dialog.upload.failed_client");
        STRING_UPLOAD_FAILED_SERVER = messages.getString("esf.dialog.upload.failed_server");
        STRING_BUTTON_OK = messages.getString("esf.dialog.ok");
        STRING_BUTTON_CANCEL = messages.getString("esf.dialog.cancel");
    }

    public JEsfPane(ESFData eSFData) {
        this(eSFData, true);
    }

    public JEsfPane(ESFData eSFData, boolean bl) {
        this.esfData = eSFData;
        this.sftpContainerListener = new SftpContainerListener(){

            @Override
            public void sftpConnectionReady() {
                JEsfPane.this.checkActionState();
            }

            @Override
            public void sftpConnectionUnready() {
                JEsfPane.this.checkActionState();
            }
        };
        this.buildComponent(bl);
    }

    public void setSftpContainer(SftpContainer sftpContainer) {
        if (this.sftpContainer != null) {
            this.sftpContainer.removeSftpContainerListener(this.sftpContainerListener);
        }
        this.sftpContainer = sftpContainer;
        if (sftpContainer != null) {
            sftpContainer.addSftpContainerListener(this.sftpContainerListener);
        }
        this.controls.setVisible(sftpContainer != null);
        this.revalidate();
        this.checkActionState();
    }

    private void buildComponent(boolean bl) {
        this.setLayout(new BorderLayout());
        this.treeTable = new ESFTreeTable(this.esfData);
        this.treeTable.setSelectionMode(1);
        this.treeTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                JEsfPane.this.checkActionState();
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.treeTable, 22, 30);
        this.add((Component)jScrollPane, "Center");
        this.collapseTree = new AbstractAction(STRING_COLLAPSE_TREE){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TreeModel treeModel = JEsfPane.this.treeTable.getTree().getModel();
                Object object = treeModel.getRoot();
                for (int i = 0; i < treeModel.getChildCount(object); ++i) {
                    JEsfPane.this.treeTable.getTree().collapsePath(new TreePath(new Object[]{object, treeModel.getChild(object, i)}));
                }
            }
        };
        this.expandTree = new AbstractAction(STRING_EXPAND_TREE){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JEsfPane.this.treeTable.expandPath(new TreePath(JEsfPane.this.treeTable.getTree().getModel().getRoot()));
            }
        };
        this.expandNode = new AbstractAction(STRING_EXPAND_NODE){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JEsfPane.this.treeTable.expandPath(JEsfPane.this.treeTable.getTree().getSelectionPath());
            }
        };
        this.addEsfData = new AbstractAction(STRING_ADD_DATA){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ESFElement eSFElement;
                AddressProperties addressProperties = new AddressProperties(JOptionPane.getFrameForComponent(JEsfPane.this)){
                    String message;

                    @Override
                    public boolean validateContent() {
                        int n = EIBAddress2.getValidAddress(this.inputAddress.getText());
                        if (JEsfPane.this.esfData.addressExists(n)) {
                            this.message = STRING_ADDRESS_EXISTS;
                            return false;
                        }
                        return true;
                    }

                    @Override
                    public String getMessage() {
                        return this.message;
                    }
                };
                if (addressProperties.openNew(eSFElement = JEsfPane.this.treeTable.getSelectedObject()) == 1) {
                    JEsfPane.this.esfData.addElement(addressProperties.getESFElement(), true);
                    JEsfPane.this.saveEsfData(ESFFactory.getEsfxData(JEsfPane.this.esfData));
                }
            }
        };
        this.editEsfData = new AbstractAction(STRING_EDIT_DATA){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ESFElement eSFElement;
                AddressProperties addressProperties = new AddressProperties(JOptionPane.getFrameForComponent(JEsfPane.this)){
                    String message;

                    @Override
                    public boolean validateContent() {
                        return true;
                    }

                    @Override
                    public String getMessage() {
                        return this.message;
                    }
                };
                if (addressProperties.open(eSFElement = JEsfPane.this.treeTable.getSelectedObject()) == 1) {
                    JEsfPane.this.esfData.fireElementChanged(eSFElement);
                    JEsfPane.this.saveEsfData(ESFFactory.getEsfxData(JEsfPane.this.esfData));
                }
            }
        };
        this.deleteEsfData = new AbstractAction(STRING_DELETE_DATA){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (JEsfPane.this.treeTable.getSelectedRowCount() > 1) {
                    int n = JOptionPane.showConfirmDialog(JEsfPane.this, STRING_DELETE_DATA_CONFIRM, UIManager.getString("OptionPane.titleText"), 0);
                    if (n == 0) {
                        TreePath[] treePathArray = JEsfPane.this.treeTable.getTree().getSelectionPaths();
                        for (int i = 0; i < treePathArray.length; ++i) {
                            if (!(treePathArray[i].getLastPathComponent() instanceof ESFElement)) continue;
                            JEsfPane.this.esfData.removeElement((ESFElement)treePathArray[i].getLastPathComponent());
                        }
                        JEsfPane.this.saveEsfData(ESFFactory.getEsfxData(JEsfPane.this.esfData));
                    }
                } else {
                    int n;
                    ESFElement eSFElement = JEsfPane.this.treeTable.getSelectedObject();
                    if (eSFElement != null && (n = JOptionPane.showConfirmDialog(JEsfPane.this, STRING_DELETE_DATA_CONFIRM, UIManager.getString("OptionPane.titleText"), 0)) == 0) {
                        JEsfPane.this.esfData.removeElement(eSFElement);
                        JEsfPane.this.saveEsfData(ESFFactory.getEsfxData(JEsfPane.this.esfData));
                    }
                }
            }
        };
        this.backupEsfFile = new AbstractAction(STRING_BACKUP_FILE){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JEsfPane.this.backupEsfData();
            }
        };
        this.uploadEsfFile = new AbstractAction(STRING_UPLOAD_FILE){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JEsfPane.this.uploadEsfData();
            }
        };
        this.mergeEsfFile = new AbstractAction(STRING_MERGE_FILE){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JEsfPane.this.mergeEsfData();
            }
        };
        this.controls = Box.createVerticalBox();
        this.add((Component)this.controls, "East");
        JButton jButton = new JButton(this.collapseTree);
        jButton.setAlignmentX(0.0f);
        jButton.setMaximumSize(new Dimension(400, jButton.getPreferredSize().height));
        this.controls.add(jButton);
        jButton = new JButton(this.expandTree);
        jButton.setAlignmentX(0.0f);
        jButton.setMaximumSize(new Dimension(400, jButton.getPreferredSize().height));
        this.controls.add(jButton);
        jButton = new JButton(this.expandNode);
        jButton.setAlignmentX(0.0f);
        jButton.setMaximumSize(new Dimension(400, jButton.getPreferredSize().height));
        this.controls.add(jButton);
        if (bl) {
            this.controls.add(Box.createVerticalStrut(20));
            jButton = new JButton(this.addEsfData);
            jButton.setAlignmentX(0.0f);
            jButton.setMaximumSize(new Dimension(400, jButton.getPreferredSize().height));
            this.controls.add(jButton);
            jButton = new JButton(this.editEsfData);
            jButton.setAlignmentX(0.0f);
            jButton.setMaximumSize(new Dimension(400, jButton.getPreferredSize().height));
            this.controls.add(jButton);
            jButton = new JButton(this.deleteEsfData);
            jButton.setAlignmentX(0.0f);
            jButton.setMaximumSize(new Dimension(400, jButton.getPreferredSize().height));
            this.controls.add(jButton);
            this.controls.add(Box.createVerticalStrut(20));
            jButton = new JButton(this.backupEsfFile);
            jButton.setAlignmentX(0.0f);
            jButton.setMaximumSize(new Dimension(400, jButton.getPreferredSize().height));
            this.controls.add(jButton);
            jButton = new JButton(this.uploadEsfFile);
            jButton.setAlignmentX(0.0f);
            jButton.setMaximumSize(new Dimension(400, jButton.getPreferredSize().height));
            this.controls.add(jButton);
            jButton = new JButton(this.mergeEsfFile);
            jButton.setAlignmentX(0.0f);
            jButton.setMaximumSize(new Dimension(400, jButton.getPreferredSize().height));
            this.controls.add(jButton);
        }
        this.checkActionState();
        this.treeTable.expandPath(new TreePath(this.treeTable.getTree().getModel().getRoot()));
    }

    public ESFTreeTable getESFTreeTable() {
        return this.treeTable;
    }

    private void saveEsfData(byte[] byArray) {
        if (byArray != null) {
            try {
                this.sftpContainer.getFileInterface().writeToFile("/home/bt1/htdocs/config/data.esfx", byArray);
            }
            catch (NoRouteToHostException noRouteToHostException) {
                JOptionPane.showMessageDialog(this, STRING_UPLOAD_FAILED_SERVER, STRING_SAVE_FILE, 0);
            }
        } else {
            JOptionPane.showMessageDialog(this, STRING_GENERATING_FAILED, STRING_SAVE_FILE, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void backupEsfData() {
        File file;
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return "*.ESFx";
            }

            @Override
            public boolean accept(File file) {
                return file.isDirectory() || file.getName().toLowerCase().endsWith(".esfx");
            }
        });
        if (jFileChooser.showSaveDialog(this) == 0 && (file = jFileChooser.getSelectedFile()) != null) {
            if (!file.getAbsolutePath().endsWith(".esfx")) {
                file = new File(file.getAbsolutePath() + ".esfx");
            }
            FileOutputStream fileOutputStream = null;
            try {
                fileOutputStream = new FileOutputStream(file);
                this.sftpContainer.getFileInterface().copy("/home/bt1/htdocs/config/data.esfx", fileOutputStream);
            }
            catch (FileNotFoundException fileNotFoundException) {
                JOptionPane.showMessageDialog(this, STRING_DOWNLOAD_FAILED_CLIENT, STRING_BACKUP_FILE, 0);
            }
            catch (NoRouteToHostException noRouteToHostException) {
                JOptionPane.showMessageDialog(this, STRING_DOWNLOAD_FAILED_SERVER, STRING_BACKUP_FILE, 0);
            }
            finally {
                try {
                    fileOutputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void uploadEsfData() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return "*.ESF / *.ESFx";
            }

            @Override
            public boolean accept(File file) {
                return file.isDirectory() || file.getName().toLowerCase().endsWith(".esfx") || file.getName().toLowerCase().endsWith(".esf");
            }
        });
        if (jFileChooser.showOpenDialog(this) == 0) {
            File file = jFileChooser.getSelectedFile();
            try {
                this.esfData.clear();
                int n = ESFFactory.parseData(file.toURI().toURL(), this.esfData);
                if (n == 0) {
                    System.out.println("saving esfx data");
                    this.saveEsfData(ESFFactory.getEsfxData(this.esfData));
                } else {
                    JOptionPane.showMessageDialog(this, STRING_UPLOAD_FAILED_SERVER, STRING_UPLOAD_FILE, 0);
                }
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
            }
        }
    }

    private void mergeEsfData() {
        final ESFMergePanel eSFMergePanel = new ESFMergePanel(this.esfData);
        final JDialog jDialog = new JDialog(JOptionPane.getFrameForComponent(this), ESFMergePanel.STRING_TITLE, true);
        JButton jButton = new JButton(new AbstractAction(STRING_SAVE_AND_CLOSE){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.setVisible(false);
                if (eSFMergePanel.hasBeenChanged()) {
                    JEsfPane.this.saveEsfData(ESFFactory.getEsfxData(JEsfPane.this.esfData));
                }
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(jButton);
        jDialog.getContentPane().setLayout(new BorderLayout());
        jDialog.getContentPane().add((Component)eSFMergePanel, "Center");
        jDialog.getContentPane().add((Component)jPanel, "South");
        jDialog.pack();
        jDialog.setVisible(true);
    }

    private void checkActionState() {
        boolean bl;
        boolean bl2 = bl = this.sftpContainer != null && this.sftpContainer.isReady();
        if (this.treeTable.getTree().getSelectionCount() > 1) {
            this.editEsfData.setEnabled(false);
            this.deleteEsfData.setEnabled(bl);
            this.addEsfData.setEnabled(bl);
            this.backupEsfFile.setEnabled(false);
            this.uploadEsfFile.setEnabled(false);
        } else {
            TreePath treePath = this.treeTable.getTree().getSelectionPath();
            this.expandNode.setEnabled(treePath != null && !(treePath.getLastPathComponent() instanceof ESFElement));
            boolean bl3 = this.treeTable.getSelectedRow() != -1 && this.treeTable.getSelectedObject() != null && bl;
            this.editEsfData.setEnabled(bl3);
            this.deleteEsfData.setEnabled(bl3);
            this.addEsfData.setEnabled(bl);
            this.backupEsfFile.setEnabled(bl);
            this.uploadEsfFile.setEnabled(bl);
        }
    }

    abstract class AddressProperties
    extends JDialog {
        static final int OK = 1;
        static final int CANCEL = 0;
        protected ESFElement element;
        protected JComboBox inputMain;
        protected JTextField inputMainName;
        protected JComboBox inputMiddle;
        protected JTextField inputMiddleName;
        protected JSpinner inputSub;
        protected JTextField inputSubName;
        protected MyTextField inputAddress;
        private int returnCode;

        public AddressProperties(Frame frame) {
            super(frame, true);
            this.returnCode = 0;
        }

        private void createContents() {
            JLabel jLabel;
            Container container = this.getContentPane();
            container.setLayout(new FormLayout("50dlu, 80dlu:grow, 80dlu:grow", "pref, 2dlu, pref, 2dlu, pref, 2dlu, pref, 2dlu, pref, 2dlu, pref"));
            JLabel jLabel2 = new JLabel(STRING_MAINGROUP);
            this.inputMain = new JComboBox<MainGroup>(((JEsfPane)JEsfPane.this).esfData.mainGroup);
            this.inputMainName = new JTextField();
            this.inputMain.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    AddressProperties.this.refreshMain();
                }
            });
            container.add((Component)jLabel2, new CellConstraints(1, 1));
            container.add((Component)this.inputMain, new CellConstraints(2, 1));
            container.add((Component)this.inputMainName, new CellConstraints(3, 1));
            if (EIBAddressFormat.is3Layer()) {
                jLabel = new JLabel(STRING_MIDDLEGROUP);
                this.inputMiddle = new JComboBox<MiddleGroup>(((JEsfPane)JEsfPane.this).esfData.mainGroup[0].middleGroup);
                this.inputMiddleName = new JTextField();
                this.inputMiddle.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent itemEvent) {
                        AddressProperties.this.refreshMiddle();
                    }
                });
                container.add((Component)jLabel, new CellConstraints(1, 3));
                container.add((Component)this.inputMiddle, new CellConstraints(2, 3));
                container.add((Component)this.inputMiddleName, new CellConstraints(3, 3));
            }
            jLabel = new JLabel(STRING_SUBGROUP);
            this.inputSub = new JSpinner(new SpinnerNumberModel(1, 0, EIBAddressFormat.is3Layer() ? 255 : 2047, 1));
            this.inputSubName = new JTextField();
            this.inputSub.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    AddressProperties.this.refreshSub();
                }
            });
            container.add((Component)jLabel, new CellConstraints(1, 5));
            container.add((Component)this.inputSub, new CellConstraints(2, 5));
            container.add((Component)this.inputSubName, new CellConstraints(3, 5));
            JLabel jLabel3 = new JLabel(STRING_ADDRESS);
            this.inputAddress = new MyTextField(7);
            container.add((Component)jLabel3, new CellConstraints(1, 7));
            container.add((Component)this.inputAddress, new CellConstraints(2, 7));
            this.inputAddress.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    AddressProperties.this.refreshAddress();
                }
            });
            container.add((Component)new JSeparator(0), new CellConstraints(1, 10, 3, 1));
            JButton jButton = new JButton(new AbstractAction(STRING_BUTTON_OK){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n;
                    if (!AddressProperties.this.inputAddress.isValid()) {
                        JOptionPane.showMessageDialog(AddressProperties.this, STRING_ADDRESS_INVALID);
                        return;
                    }
                    if (!AddressProperties.this.validateContent()) {
                        JOptionPane.showMessageDialog(AddressProperties.this, AddressProperties.this.getMessage());
                        return;
                    }
                    AddressProperties.this.element.setTitle(AddressProperties.this.inputSubName.getText());
                    AddressProperties.this.element.setAddress(EIBAddress2.getValidAddress(AddressProperties.this.inputAddress.getText()));
                    if (!AddressProperties.this.inputMainName.getText().equals(JEsfPane.this.esfData.getMainName(AddressProperties.this.element)) && (n = JOptionPane.showConfirmDialog(AddressProperties.this, STRING_CHANGE_MAINGROUP + " \"" + JEsfPane.this.esfData.getMainName(AddressProperties.this.element) + "\" -> \"" + AddressProperties.this.inputMainName.getText() + "\"?")) != 0) {
                        return;
                    }
                    if (EIBAddressFormat.is3Layer() && !AddressProperties.this.inputMiddleName.getText().equals(JEsfPane.this.esfData.getMiddleName(AddressProperties.this.element)) && (n = JOptionPane.showConfirmDialog(AddressProperties.this, STRING_CHANGE_MIDDLEGROUP + " \"" + JEsfPane.this.esfData.getMiddleName(AddressProperties.this.element) + "\" -> \"" + AddressProperties.this.inputMiddleName.getText() + "\"?")) != 0) {
                        return;
                    }
                    JEsfPane.this.esfData.setMainName(AddressProperties.this.element, AddressProperties.this.inputMainName.getText(), true);
                    if (EIBAddressFormat.is3Layer()) {
                        JEsfPane.this.esfData.setMiddleName(AddressProperties.this.element, AddressProperties.this.inputMiddleName.getText(), true);
                    }
                    AddressProperties.this.returnCode = 1;
                    AddressProperties.this.setVisible(false);
                }
            });
            container.add((Component)jButton, new CellConstraints(2, 11));
            JButton jButton2 = new JButton(new AbstractAction(STRING_BUTTON_CANCEL){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AddressProperties.this.returnCode = 0;
                    AddressProperties.this.setVisible(false);
                }
            });
            container.add((Component)jButton2, new CellConstraints(3, 11));
            this.pack();
            this.refreshMain();
        }

        private void refreshMain() {
            MainGroup mainGroup = (MainGroup)this.inputMain.getSelectedItem();
            this.inputMainName.setText(mainGroup.title);
            if (EIBAddressFormat.is3Layer()) {
                int n = this.inputMiddle.getSelectedIndex();
                this.inputMiddle.removeAllItems();
                for (MiddleGroup middleGroup : mainGroup.middleGroup) {
                    this.inputMiddle.addItem(middleGroup);
                }
                this.inputMiddle.setSelectedIndex(n);
                this.refreshMiddle();
            } else {
                this.refreshSub();
            }
        }

        private void refreshMiddle() {
            if (this.inputMiddle.getSelectedItem() == null) {
                return;
            }
            this.inputMiddleName.setText(((MiddleGroup)this.inputMiddle.getSelectedItem()).title);
            this.refreshSub();
        }

        private void refreshSub() {
            int n;
            int n2;
            if (EIBAddressFormat.is3Layer()) {
                n2 = this.inputMain.getSelectedIndex();
                int n3 = this.inputMiddle.getSelectedIndex();
                int n4 = (Integer)this.inputSub.getValue();
                n = EIBAddress2.getIntAddress(n2, n3, n4);
            } else {
                n2 = this.inputMain.getSelectedIndex();
                int n5 = (Integer)this.inputSub.getValue();
                n = EIBAddress2.getIntAddress(n2, n5);
            }
            ESFElement eSFElement = JEsfPane.this.esfData.getElementByAddress(n);
            if (eSFElement == null) {
                this.inputSubName.setText("");
            } else {
                this.inputSubName.setText(eSFElement.getTitle());
            }
            this.inputAddress.setText(EIBAddress2.getAddress(n).getStrAddress());
        }

        private void refreshAddress() {
            if (this.inputAddress.isValid()) {
                String string = this.inputAddress.getText();
                EIBAddress2 eIBAddress2 = EIBAddress2.getAddress(string);
                this.inputMain.setSelectedIndex(eIBAddress2.getMain());
                if (EIBAddressFormat.is3Layer()) {
                    this.inputMiddle.setSelectedIndex(eIBAddress2.getMiddle());
                    this.inputSub.setValue(eIBAddress2.getSub3());
                } else {
                    this.inputSub.setValue(eIBAddress2.getSub2());
                }
                this.refreshMain();
            }
        }

        public int openNew(ESFElement eSFElement) {
            this.element = new ESFElement();
            this.createContents();
            if (eSFElement != null) {
                int n = eSFElement.getAddress().getIntAddress();
                while (JEsfPane.this.esfData.getElementByAddress(n) != null) {
                    ++n;
                }
                EIBAddress2 eIBAddress2 = EIBAddress2.getAddress(n);
                this.inputAddress.setText(eIBAddress2.getStrAddress());
                this.inputMain.setSelectedIndex(eIBAddress2.getMain());
                if (EIBAddressFormat.is3Layer()) {
                    this.inputMiddle.setSelectedIndex(eIBAddress2.getMiddle());
                    this.inputSub.setValue(eIBAddress2.getSub3());
                } else {
                    this.inputSub.setValue(eIBAddress2.getSub2());
                }
            }
            this.setVisible(true);
            return this.returnCode;
        }

        public int open(ESFElement eSFElement) {
            this.element = eSFElement;
            this.createContents();
            this.inputAddress.setText(eSFElement.getAddress().getStrAddress());
            this.inputMain.setSelectedIndex(eSFElement.getAddress().getMain());
            if (EIBAddressFormat.is3Layer()) {
                this.inputMiddle.setSelectedIndex(eSFElement.getAddress().getMiddle());
                this.inputSub.setValue(eSFElement.getAddress().getSub3());
            } else {
                this.inputSub.setValue(eSFElement.getAddress().getSub2());
            }
            this.inputAddress.setEditable(false);
            this.inputMain.setEnabled(false);
            if (EIBAddressFormat.is3Layer()) {
                this.inputMiddle.setEnabled(false);
            }
            this.inputSub.setEnabled(false);
            this.setVisible(true);
            return this.returnCode;
        }

        public ESFElement getESFElement() {
            return this.element;
        }

        public abstract boolean validateContent();

        public abstract String getMessage();
    }
}

