/*
 * Decompiled with CFR 0.152.
 */
package de.eibport.components.addressfield.esfdata;

import de.eibport.components.addressfield.esfdata.ESFElement;
import de.eibport.components.addressfield.esfdata.EsfDataListener;
import de.eibport.components.addressfield.esfdata.MainGroup;
import de.eibport.components.addressfield.esfdata.MiddleGroup;
import de.eibport.net.bmx.eibaddress2.EIBAddress2;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;

public class ESFData {
    public static final String ESF_PATH = "/home/bt1/htdocs/config/data.esf";
    public static final String ESFX_PATH = "/home/bt1/htdocs/config/data.esfx";
    public static final String ESF_HTTP_PATH = "users/bt1/config/data.esf";
    public static final String ESFX_HTTP_PATH = "users/bt1/config/data.esfx";
    public static final String ESF_EXTENSION = ".esf";
    public static final String ESFX_EXTENSION = ".esfx";
    public static final String[] EIS_TYPES = new String[]{"Uncertain (1 Byte)", "Uncertain (2 Byte)", "Uncertain (3 Byte)", "EIS 1 'Switching' (1 Bit)", "EIS 2 'Dimming - control' (4 Bit)", ""};
    private String title;
    private HashMap<Integer, ESFElement> esfMap = new HashMap();
    public MainGroup[] mainGroup = new MainGroup[]{new MainGroup("Maingroup 0", 0), new MainGroup("Maingroup 1", 1), new MainGroup("Maingroup 2", 2), new MainGroup("Maingroup 3", 3), new MainGroup("Maingroup 4", 4), new MainGroup("Maingroup 5", 5), new MainGroup("Maingroup 6", 6), new MainGroup("Maingroup 7", 7), new MainGroup("Maingroup 8", 8), new MainGroup("Maingroup 9", 9), new MainGroup("Maingroup 10", 10), new MainGroup("Maingroup 11", 11), new MainGroup("Maingroup 12", 12), new MainGroup("Maingroup 13", 13), new MainGroup("Maingroup 14", 14), new MainGroup("Maingroup 15", 15), new MainGroup("Virtual Maingroup 16", 16), new MainGroup("Virtual Maingroup 17", 17), new MainGroup("Virtual Maingroup 18", 18), new MainGroup("Virtual Maingroup 19", 19), new MainGroup("Virtual Maingroup 20", 20), new MainGroup("Virtual Maingroup 21", 21), new MainGroup("Virtual Maingroup 22", 22), new MainGroup("Virtual Maingroup 23", 23), new MainGroup("Virtual Maingroup 24", 24), new MainGroup("Virtual Maingroup 25", 25), new MainGroup("Virtual Maingroup 26", 26), new MainGroup("Virtual Maingroup 27", 27), new MainGroup("Virtual Maingroup 28", 28), new MainGroup("Virtual Maingroup 29", 29), new MainGroup("Virtual Maingroup 30", 30), new MainGroup("Virtual Maingroup 31", 31)};
    private ArrayList<EsfDataListener> listener = new ArrayList();

    public void dispose() {
        this.esfMap.clear();
    }

    public void clear() {
        this.esfMap.clear();
    }

    public void addElement(ESFElement eSFElement, boolean bl) {
        this.esfMap.put(eSFElement.getAddress().getIntAddress(), eSFElement);
        if (bl) {
            for (EsfDataListener esfDataListener : this.listener) {
                esfDataListener.esfElementAdded(eSFElement);
            }
        }
    }

    public void removeElement(ESFElement eSFElement) {
        this.esfMap.remove(eSFElement.getAddress().getIntAddress());
        for (EsfDataListener esfDataListener : this.listener) {
            esfDataListener.esfElementRemoved(eSFElement);
        }
    }

    public void fireDataChanged() {
        for (EsfDataListener esfDataListener : this.listener) {
            esfDataListener.esfDataChanged();
        }
    }

    public void fireElementChanged(ESFElement eSFElement) {
        for (EsfDataListener esfDataListener : this.listener) {
            esfDataListener.esfElementChanged(eSFElement);
        }
    }

    public boolean addressExists(int n) {
        return this.esfMap.containsKey(n);
    }

    public ESFElement getElementByAddress(int n) {
        return this.esfMap.get(n);
    }

    public ArrayList<ESFElement> getElements() {
        ArrayList<ESFElement> arrayList = new ArrayList<ESFElement>(this.esfMap.values());
        Collections.sort(arrayList);
        return arrayList;
    }

    public MainGroup[] getFilledMainGroups() {
        ArrayList<MainGroup> arrayList = new ArrayList<MainGroup>();
        for (MainGroup mainGroup : this.mainGroup) {
            if (this.getElementsInGroup(mainGroup.index).length <= 0) continue;
            arrayList.add(mainGroup);
        }
        return arrayList.toArray(new MainGroup[arrayList.size()]);
    }

    public MiddleGroup[] getFilledMiddleGroups(int n) {
        ArrayList<MiddleGroup> arrayList = new ArrayList<MiddleGroup>();
        for (MiddleGroup middleGroup : this.mainGroup[n].middleGroup) {
            if (this.getElementsInGroup(n, middleGroup.index).length <= 0) continue;
            arrayList.add(middleGroup);
        }
        return arrayList.toArray(new MiddleGroup[arrayList.size()]);
    }

    public ESFElement[] getElementsInGroup(int n) {
        ArrayList<ESFElement> arrayList = new ArrayList<ESFElement>();
        for (ESFElement eSFElement : this.esfMap.values()) {
            if (eSFElement.getAddress().getMain() != n) continue;
            arrayList.add(eSFElement);
        }
        Collections.sort(arrayList);
        return arrayList.toArray(new ESFElement[arrayList.size()]);
    }

    public ESFElement[] getElementsInGroup(int n, int n2) {
        ArrayList<ESFElement> arrayList = new ArrayList<ESFElement>();
        for (ESFElement eSFElement : this.esfMap.values()) {
            if (eSFElement.getAddress().getMain() != n || eSFElement.getAddress().getMiddle() != n2) continue;
            arrayList.add(eSFElement);
        }
        Collections.sort(arrayList);
        return arrayList.toArray(new ESFElement[arrayList.size()]);
    }

    public int getElementCount() {
        return this.esfMap.size();
    }

    public ESFElement getElementByAddress(String string) {
        return this.esfMap.get(EIBAddress2.getValidAddress(string));
    }

    public void addEsfDataListener(EsfDataListener esfDataListener) {
        this.listener.add(esfDataListener);
    }

    public void removeEsfDataListener(EsfDataListener esfDataListener) {
        this.listener.remove(esfDataListener);
    }

    public String getMainName(ESFElement eSFElement) {
        return eSFElement == null ? "" : this.getMainName(eSFElement.getAddress().getMain());
    }

    public String getMainName(int n) {
        return this.mainGroup[n].title;
    }

    public void setMainName(ESFElement eSFElement, String string, boolean bl) {
        this.setMainName(eSFElement.getAddress().getMain(), string, bl);
    }

    public void setMainName(int n, String string, boolean bl) {
        this.mainGroup[n].title = string;
        if (bl) {
            for (EsfDataListener esfDataListener : this.listener) {
                esfDataListener.esfMainGroupChanged(this.mainGroup[n]);
            }
        }
    }

    public String getMiddleName(ESFElement eSFElement) {
        return eSFElement == null ? "" : this.getMiddleName(eSFElement.getAddress().getMain(), eSFElement.getAddress().getMiddle());
    }

    public String getMiddleName(int n, int n2) {
        return this.mainGroup[n].middleGroup[n2].title;
    }

    public void setMiddleName(ESFElement eSFElement, String string, boolean bl) {
        this.setMiddleName(eSFElement.getAddress().getMain(), eSFElement.getAddress().getMiddle(), string, bl);
    }

    public void setMiddleName(int n, int n2, String string, boolean bl) {
        this.mainGroup[n].middleGroup[n2].title = string;
        if (bl) {
            for (EsfDataListener esfDataListener : this.listener) {
                esfDataListener.esfMiddleGroupChanged(this.mainGroup[n].middleGroup[n2]);
            }
        }
    }

    public String getSubName(int n) {
        ESFElement eSFElement = this.getElementByAddress(n);
        return eSFElement == null ? "" : eSFElement.getTitle();
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public String getTitle() {
        return this.title;
    }
}

