/*
 * Decompiled with CFR 0.152.
 */
package de.eibport.components.addressfield.esfdata;

import de.eibport.net.bmx.eibaddress2.EIBAddress2;
import de.eibport.net.bmx.eibaddress2.EIBAddressFormat;
import de.eibport.net.datatype.DataType;

public class ESFElement
implements Comparable<ESFElement> {
    private String title;
    private EIBAddress2 address;
    private DataType<?> dataType = DataType.getUnknown();
    private String priority = "Low";

    public ESFElement(String string, EIBAddress2 eIBAddress2, DataType<?> dataType) {
        this.title = string;
        this.address = eIBAddress2;
        this.dataType = dataType;
    }

    public ESFElement() {
        this.title = "";
        this.address = EIBAddress2.getAddress(1);
    }

    public String getTitle() {
        return this.title;
    }

    public EIBAddress2 getAddress() {
        return this.address;
    }

    public void setDataType(DataType<?> dataType) {
        this.dataType = dataType;
    }

    public DataType<?> getDataType() {
        return this.dataType;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public void setAddress(int n) {
        this.address = EIBAddress2.getAddress(n);
    }

    public void setPriority(String string) {
        this.priority = string;
    }

    public String getPriority() {
        return this.priority;
    }

    @Override
    public int compareTo(ESFElement eSFElement) {
        return this.address.compareTo(eSFElement.address);
    }

    public String toString() {
        if (EIBAddressFormat.is2Layer()) {
            return this.address.getSub2() + " " + this.title;
        }
        return this.address.getSub3() + " " + this.title;
    }
}

