/*
 * Decompiled with CFR 0.152.
 */
package de.eibport.components.addressfield.esfdata;

import de.eibport.components.addressfield.esfdata.ESFData;
import de.eibport.components.addressfield.esfdata.ESFElement;
import de.eibport.net.bmx.eibaddress2.EIBAddress2;
import de.eibport.net.datatype.DataType;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class ESFFactory {
    public static final int RESULT_UNKNOWN = -1;
    public static final int RESULT_SUCCESS = 0;
    public static final int RESULT_FILE_NOT_FOUND = 1;
    public static final int RESULT_IO_ERROR = 2;
    public static final int RESULT_PARSE_ERROR = 3;
    private static final String ESFX_ROOT = "esfx";
    private static final String ESFX_INDEX = "index";
    private static final String ESFX_GROUPS = "groups";
    private static final String ESFX_MAINGRP = "maingroup";
    private static final String ESFX_MIDDLEGRP = "middlegroup";
    private static final String ESFX_ADDRESSES = "addresses";
    private static final String ESFX_ADDRESS = "address";
    private static final String ESFX_SUBGRP2 = "subgrp2";
    private static final String ESFX_SUBGRP3 = "subgrp3";
    private static final String ESFX_NAME = "name";
    private static final String ESFX_DATATYPE = "datatype";

    public static int parseData(URL uRL, URL uRL2, ESFData eSFData) {
        int n = -1;
        try {
            System.out.println("Loading ESFx-Data: " + uRL);
            n = ESFFactory.parseData(uRL.openConnection().getInputStream(), eSFData);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (n == 0) {
            System.out.println("successfully parsed esfx file");
            return 0;
        }
        try {
            System.out.println("Loading ESF-Data: " + uRL2);
            n = ESFFactory.parseData(uRL2.openConnection().getInputStream(), eSFData);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (n == 0) {
            System.out.println("successfully parsed esf file");
            return 0;
        }
        return n;
    }

    public static int parseData(URL uRL, ESFData eSFData) {
        int n = -1;
        try {
            n = ESFFactory.parseData(uRL.openConnection().getInputStream(), eSFData);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int parseData(InputStream inputStream, ESFData eSFData) {
        eSFData.clear();
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            bufferedReader.mark(2048);
            if (bufferedReader.readLine().startsWith("<?xml")) {
                bufferedReader.reset();
                ESFFactory.parseEsfxData(bufferedReader, eSFData);
            } else {
                bufferedReader.reset();
                ESFFactory.parseEsfData(bufferedReader, eSFData);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            int n = 2;
            return n;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int parseEsfData(BufferedReader bufferedReader, ESFData eSFData) {
        try {
            String string;
            int n = 0;
            while ((string = bufferedReader.readLine()) != null) {
                ESFFactory.parseLine(eSFData, string, n++);
            }
            eSFData.fireDataChanged();
            System.out.println("Parsed " + n + " lines of esf data");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            int n = 2;
            return n;
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (Exception exception) {}
        }
        return 0;
    }

    private static boolean parseLine(ESFData eSFData, String string, int n) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
        boolean bl = true;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        if (stringTokenizer.countTokens() >= 4) {
            StringTokenizer stringTokenizer2 = new StringTokenizer(stringTokenizer.nextToken(), ".");
            if (stringTokenizer2.countTokens() == 3) {
                string2 = stringTokenizer2.nextToken();
                string3 = stringTokenizer2.nextToken();
                string5 = stringTokenizer2.nextToken();
            } else if (stringTokenizer2.countTokens() == 2) {
                string2 = stringTokenizer2.nextToken();
                string3 = "";
                string5 = stringTokenizer2.nextToken();
            } else {
                bl = false;
            }
            string4 = stringTokenizer.nextToken();
            string6 = stringTokenizer.nextToken();
            DataType dataType = DataType.getUnknown();
            if (string6.startsWith("EIS 1 ")) {
                dataType = DataType.getEis1();
            }
            if (string6.startsWith("EIS 3 ")) {
                dataType = DataType.getEis3();
            }
            if (string6.startsWith("EIS 4 ")) {
                dataType = DataType.getEis4();
            }
            if (string6.startsWith("EIS 5 ")) {
                dataType = DataType.getEis5();
            }
            if (string6.startsWith("EIS 6 ")) {
                dataType = DataType.getEis6();
            }
            if (string6.startsWith("EIS 9 ")) {
                dataType = DataType.getEis9();
            }
            if (string6.startsWith("EIS 10")) {
                dataType = DataType.getEis10s();
            }
            if (string6.startsWith("EIS 11")) {
                dataType = DataType.getEis11s();
            }
            if (bl) {
                try {
                    ESFElement eSFElement = new ESFElement(string4, EIBAddress2.getAddress(string5), dataType);
                    eSFData.setMainName(eSFElement, string2, false);
                    eSFData.setMiddleName(eSFElement, string3, false);
                    eSFElement.setPriority(stringTokenizer.nextToken());
                    eSFData.addElement(eSFElement, false);
                }
                catch (Exception exception) {
                    System.out.println("INVALID LINE (" + n + "): " + string);
                    return false;
                }
            }
        } else if (n == 0) {
            eSFData.setTitle(string.trim());
        } else {
            System.out.println("Invalid line in ESF-File: " + string);
            return false;
        }
        return true;
    }

    private static int parseEsfxData(BufferedReader bufferedReader, ESFData eSFData) {
        try {
            Object object;
            Object object22;
            Document document = new SAXBuilder().build(bufferedReader);
            Element element = document.getRootElement().getChild(ESFX_GROUPS);
            for (Object object22 : element.getChildren(ESFX_MAINGRP)) {
                int n = Integer.parseInt(((Element)object22).getAttributeValue(ESFX_INDEX));
                object = ((Element)object22).getAttributeValue(ESFX_NAME);
                eSFData.setMainName(n, (String)object, false);
                for (Element element2 : ((Element)object22).getChildren(ESFX_MIDDLEGRP)) {
                    int n2 = Integer.parseInt(element2.getAttributeValue(ESFX_INDEX));
                    String string = element2.getAttributeValue(ESFX_NAME);
                    eSFData.setMiddleName(n, n2, string, false);
                }
            }
            Element element3 = document.getRootElement().getChild(ESFX_ADDRESSES);
            object22 = element3.getChildren(ESFX_ADDRESS);
            Iterator iterator = object22.iterator();
            while (iterator.hasNext()) {
                object = (Element)iterator.next();
                ESFElement eSFElement = new ESFElement();
                eSFElement.setAddress(Integer.parseInt(((Element)object).getAttributeValue(ESFX_ADDRESS)));
                eSFElement.setTitle(((Element)object).getChildText(ESFX_NAME));
                eSFElement.setDataType(DataType.getDataType(Integer.parseInt(((Element)object).getChildText(ESFX_DATATYPE))));
                eSFData.addElement(eSFElement, false);
            }
            eSFData.fireDataChanged();
            System.out.println("Parsed " + eSFData.getElementCount() + " entries");
        }
        catch (JDOMException jDOMException) {
            return 3;
        }
        catch (IOException iOException) {
            return 2;
        }
        return 0;
    }

    public static byte[] getEsfxData(ESFData eSFData) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Element element = new Element(ESFX_ROOT);
        Element element2 = new Element(ESFX_GROUPS);
        Element element3 = new Element(ESFX_ADDRESSES);
        element.addContent(element2);
        element.addContent(element3);
        ArrayList<ESFElement> arrayList = eSFData.getElements();
        Collections.sort(arrayList);
        int n = -1;
        int n2 = -1;
        Element element4 = null;
        for (ESFElement eSFElement : arrayList) {
            Element element5;
            if (n != eSFElement.getAddress().getMain()) {
                n = eSFElement.getAddress().getMain();
                n2 = -1;
                element4 = new Element(ESFX_MAINGRP);
                element4.setAttribute(ESFX_INDEX, Integer.toString(n));
                element4.setAttribute(ESFX_NAME, eSFData.getMainName(n));
                element2.addContent(element4);
            }
            if (n2 != eSFElement.getAddress().getMiddle()) {
                n2 = eSFElement.getAddress().getMiddle();
                element5 = new Element(ESFX_MIDDLEGRP);
                element5.setAttribute(ESFX_INDEX, Integer.toString(n2));
                element5.setAttribute(ESFX_NAME, eSFData.getMiddleName(n, n2));
                element4.addContent(element5);
            }
            element5 = new Element(ESFX_ADDRESS);
            element5.setAttribute(ESFX_ADDRESS, Integer.toString(eSFElement.getAddress().getIntAddress()));
            element5.addContent(new Element(ESFX_MAINGRP).setText(Integer.toString(eSFElement.getAddress().getMain())));
            element5.addContent(new Element(ESFX_MIDDLEGRP).setText(Integer.toString(eSFElement.getAddress().getMiddle())));
            element5.addContent(new Element(ESFX_SUBGRP2).setText(Integer.toString(eSFElement.getAddress().getSub2())));
            element5.addContent(new Element(ESFX_SUBGRP3).setText(Integer.toString(eSFElement.getAddress().getSub3())));
            element5.addContent(new Element(ESFX_NAME).setText(eSFElement.getTitle()));
            element5.addContent(new Element(ESFX_DATATYPE).setText(Integer.toString(eSFElement.getDataType().getTypeIndex())));
            element3.addContent(element5);
        }
        Document document = new Document(element);
        try {
            new XMLOutputter(Format.getPrettyFormat()).output(document, (OutputStream)byteArrayOutputStream);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return byteArrayOutputStream.toByteArray();
    }
}

