/*
 * Decompiled with CFR 0.152.
 */
package de.eibport.components.esfmerge;

import de.eibport.components.addressfield.JEsfPane;
import de.eibport.components.addressfield.esfdata.ESFData;
import de.eibport.components.addressfield.esfdata.ESFElement;
import de.eibport.components.addressfield.esfdata.ESFFactory;
import de.eibport.components.addressfield.esfdata.ESFGroup;
import de.eibport.components.addressfield.esfdata.MainGroup;
import de.eibport.components.addressfield.esfdata.MiddleGroup;
import de.eibport.net.HostInformation;
import de.eibport.net.bmx.eibaddress2.EIBAddressFormat;
import de.eibport.utils.localization.Messages;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;

public class ESFMergePanel
extends JPanel {
    public static String STRING_TITLE = "Merge ESF File";
    public static String STRING_OPEN_ESF = "Open ESF File";
    public static String STRING_IGNORE_DATATYPE = "Ignore DataType";
    public static String STRING_CHECK_ALL = "Check All";
    public static String STRING_UNCHECK_ALL = "Uncheck All";
    public static String STRING_TOGGLE_ADDED = "Toggle Added";
    public static String STRING_TOGGLE_CHANGED = "Toggle Changed";
    public static String STRING_TOGGLE_REMOVED = "Toggle Removed";
    public static String STRING_PERFORM_MERGE = "Perform Merge";
    public static String STRING_COLUMN_ACTION = "Action";
    public static String STRING_COLUMN_ADDRESS = "Address";
    public static String STRING_COLUMN_TITLE = "Title";
    public static String STRING_COLUMN_DATATYPE = "DataType";
    public static String STRING_COLUMN_ACCEPT = "Accept";
    public static String STRING_SRC_EIBPORT = "eibPort ESF Data";
    public static String STRING_SRC_LOCAL = "Changes from local ESF file";
    public static String STRING_CONFIRM_REMOVE = "<html>Do you really want to remove the selected entries from your ESF file?<br>Entries you have added to the eibPort ESF file might be lost.</html>";
    private static final int MERGE_ACTION_NONE = 0;
    private static final int MERGE_ACTION_ADD = 1;
    private static final int MERGE_ACTION_CHANGE = 2;
    private static final int MERGE_ACTION_REMOVE = 3;
    private String[] TABLE_COlUMNS = new String[]{STRING_COLUMN_ACTION, STRING_COLUMN_ADDRESS, STRING_COLUMN_TITLE, STRING_COLUMN_DATATYPE, STRING_COLUMN_ACCEPT};
    private DefaultTableModel localDtm;
    private JTable localEsfTable;
    private ESFData localEsfData = new ESFData();
    private JEsfPane remoteEsfPane;
    private ESFData remoteEsfData;
    private JButton btnOpen;
    private JCheckBox chkIgnoreDataType;
    private JButton btnCheckAll;
    private JButton btnUncheckAll;
    private JButton btnCheckAdded;
    private JButton btnCheckChanged;
    private JButton btnCheckRemoved;
    private JButton btnPerformMerge;
    private File latestFile = null;
    private MergeObject[] mergeObjects = new MergeObject[0];
    private Icon[] mergeIcons;
    private boolean hasBeenChanged = false;

    public static void adoptLocalization(Messages messages) {
        STRING_TITLE = messages.getString("esf.merge.title");
        STRING_OPEN_ESF = messages.getString("esf.merge.open_esf");
        STRING_IGNORE_DATATYPE = messages.getString("esf.merge.ignore_datatype");
        STRING_CHECK_ALL = messages.getString("esf.merge.check_all");
        STRING_UNCHECK_ALL = messages.getString("esf.merge.uncheck_all");
        STRING_TOGGLE_ADDED = messages.getString("esf.merge.toggle_added");
        STRING_TOGGLE_CHANGED = messages.getString("esf.merge.toggle_changed");
        STRING_TOGGLE_REMOVED = messages.getString("esf.merge.toggle_removed");
        STRING_PERFORM_MERGE = messages.getString("esf.merge.perform_merge");
        STRING_COLUMN_ACTION = messages.getString("esf.merge.column.action");
        STRING_COLUMN_ADDRESS = messages.getString("esf.merge.column.address");
        STRING_COLUMN_TITLE = messages.getString("esf.merge.column.title");
        STRING_COLUMN_DATATYPE = messages.getString("esf.merge.column.datatype");
        STRING_COLUMN_ACCEPT = messages.getString("esf.merge.column.accept");
        STRING_SRC_EIBPORT = messages.getString("esf.merge.src_eibport");
        STRING_SRC_LOCAL = messages.getString("esf.merge.src_local");
        STRING_CONFIRM_REMOVE = messages.getString("esf.merge.confirm_remove");
    }

    public ESFMergePanel(ESFData eSFData) {
        this.remoteEsfData = eSFData;
        this.mergeIcons = new Icon[4];
        this.mergeIcons[1] = new ImageIcon(this.getClass().getResource("merge_add.png"));
        this.mergeIcons[2] = new ImageIcon(this.getClass().getResource("merge_change.png"));
        this.mergeIcons[3] = new ImageIcon(this.getClass().getResource("merge_remove.png"));
        this.remoteEsfPane = new JEsfPane(eSFData, false);
        this.btnOpen = new JButton(STRING_OPEN_ESF);
        this.btnOpen.setBackground(Color.ORANGE);
        this.btnOpen.setAlignmentX(0.5f);
        this.btnOpen.setMaximumSize(new Dimension(400, this.btnOpen.getPreferredSize().height));
        this.btnOpen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ESFMergePanel.this.openLocalFile();
            }
        });
        this.chkIgnoreDataType = new JCheckBox(STRING_IGNORE_DATATYPE);
        this.chkIgnoreDataType.setAlignmentX(0.5f);
        this.chkIgnoreDataType.setMaximumSize(new Dimension(400, this.chkIgnoreDataType.getPreferredSize().height));
        this.chkIgnoreDataType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ESFMergePanel.this.compare();
            }
        });
        this.btnCheckAll = new JButton(STRING_CHECK_ALL);
        this.btnCheckAll.setAlignmentX(0.5f);
        this.btnCheckAll.setMaximumSize(new Dimension(400, this.btnCheckAll.getPreferredSize().height));
        this.btnCheckAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                for (MergeObject mergeObject : ESFMergePanel.this.mergeObjects) {
                    mergeObject.accept = true;
                }
                ESFMergePanel.this.localDtm.fireTableDataChanged();
            }
        });
        this.btnUncheckAll = new JButton(STRING_UNCHECK_ALL);
        this.btnUncheckAll.setAlignmentX(0.5f);
        this.btnUncheckAll.setMaximumSize(new Dimension(400, this.btnUncheckAll.getPreferredSize().height));
        this.btnUncheckAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                for (MergeObject mergeObject : ESFMergePanel.this.mergeObjects) {
                    mergeObject.accept = false;
                }
                ESFMergePanel.this.localDtm.fireTableDataChanged();
            }
        });
        this.btnCheckAdded = new JButton(STRING_TOGGLE_ADDED);
        this.btnCheckAdded.setAlignmentX(0.5f);
        this.btnCheckAdded.setMaximumSize(new Dimension(400, this.btnCheckAdded.getPreferredSize().height));
        this.btnCheckAdded.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ESFMergePanel.this.toggleAction(1);
            }
        });
        this.btnCheckChanged = new JButton(STRING_TOGGLE_CHANGED);
        this.btnCheckChanged.setAlignmentX(0.5f);
        this.btnCheckChanged.setMaximumSize(new Dimension(400, this.btnCheckChanged.getPreferredSize().height));
        this.btnCheckChanged.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ESFMergePanel.this.toggleAction(2);
            }
        });
        this.btnCheckRemoved = new JButton(STRING_TOGGLE_REMOVED);
        this.btnCheckRemoved.setAlignmentX(0.5f);
        this.btnCheckRemoved.setMaximumSize(new Dimension(400, this.btnCheckRemoved.getPreferredSize().height));
        this.btnCheckRemoved.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ESFMergePanel.this.toggleAction(3);
            }
        });
        this.btnPerformMerge = new JButton(STRING_PERFORM_MERGE);
        this.btnPerformMerge.setBackground(Color.GREEN);
        this.btnPerformMerge.setAlignmentX(0.5f);
        this.btnPerformMerge.setMaximumSize(new Dimension(400, this.btnPerformMerge.getPreferredSize().height));
        this.btnPerformMerge.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ESFMergePanel.this.perform();
            }
        });
        Box box = new Box(1);
        box.add(this.btnOpen);
        box.add(Box.createVerticalStrut(20));
        box.add(this.chkIgnoreDataType);
        box.add(Box.createVerticalStrut(20));
        box.add(this.btnCheckAll);
        box.add(this.btnUncheckAll);
        box.add(Box.createVerticalStrut(20));
        box.add(this.btnCheckAdded);
        box.add(this.btnCheckChanged);
        box.add(this.btnCheckRemoved);
        box.add(Box.createVerticalGlue());
        box.add(this.btnPerformMerge);
        this.localDtm = new DefaultTableModel(){

            @Override
            public int getColumnCount() {
                return 5;
            }

            @Override
            public String getColumnName(int n) {
                return ESFMergePanel.this.TABLE_COlUMNS[n];
            }

            @Override
            public int getRowCount() {
                return ESFMergePanel.this.mergeObjects.length;
            }

            @Override
            public Object getValueAt(int n, int n2) {
                switch (n2) {
                    case 0: {
                        return ((ESFMergePanel)ESFMergePanel.this).mergeObjects[n].action;
                    }
                    case 1: {
                        return ESFMergePanel.this.mergeObjects[n].toString();
                    }
                    case 2: {
                        if (ESFMergePanel.this.mergeObjects[n].isElement()) {
                            return ((ESFMergePanel)ESFMergePanel.this).mergeObjects[n].ME().element.getTitle();
                        }
                        return ((ESFMergePanel)ESFMergePanel.this).mergeObjects[n].MG().group.title;
                    }
                    case 3: {
                        if (!ESFMergePanel.this.mergeObjects[n].isElement()) break;
                        return ((ESFMergePanel)ESFMergePanel.this).mergeObjects[n].ME().element.getDataType().toString();
                    }
                    case 4: {
                        return ((ESFMergePanel)ESFMergePanel.this).mergeObjects[n].accept;
                    }
                }
                return null;
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return n2 == 4;
            }

            @Override
            public void setValueAt(Object object, int n, int n2) {
                if (n2 == 4 && object instanceof Boolean) {
                    ((ESFMergePanel)ESFMergePanel.this).mergeObjects[n].accept = (Boolean)object;
                }
                this.fireTableCellUpdated(n, n2);
            }

            @Override
            public Class<?> getColumnClass(int n) {
                if (n == 4) {
                    return Boolean.class;
                }
                return String.class;
            }
        };
        this.localEsfTable = new JTable(this.localDtm);
        this.localEsfTable.setDefaultRenderer(String.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                if (component instanceof JLabel) {
                    if (n2 == 0) {
                        ((JLabel)component).setIcon(ESFMergePanel.this.mergeIcons[(Integer)object]);
                        ((JLabel)component).setText("");
                    } else {
                        ((JLabel)component).setIcon(null);
                    }
                }
                if (ESFMergePanel.this.mergeObjects[n].isGroup() && !bl) {
                    component.setBackground(new Color(0xE3E3FF));
                } else {
                    component.setBackground(bl ? ESFMergePanel.this.localEsfTable.getSelectionBackground() : ESFMergePanel.this.localEsfTable.getBackground());
                }
                return component;
            }
        });
        this.localEsfTable.getColumnModel().getColumn(4).setWidth(30);
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder(STRING_SRC_LOCAL));
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)new JScrollPane(this.localEsfTable), "Center");
        jPanel.add((Component)box, "East");
        this.remoteEsfPane.setBorder(BorderFactory.createTitledBorder(STRING_SRC_EIBPORT));
        this.setLayout(new BorderLayout());
        JSplitPane jSplitPane = new JSplitPane(1, this.remoteEsfPane, jPanel);
        jSplitPane.setDividerLocation(550);
        jSplitPane.setOneTouchExpandable(true);
        this.add((Component)jSplitPane, "Center");
        this.checkButtons();
    }

    private void checkButtons() {
        this.btnCheckAll.setEnabled(this.mergeObjects.length > 0);
        this.btnUncheckAll.setEnabled(this.mergeObjects.length > 0);
        this.btnCheckAdded.setEnabled(this.mergeObjects.length > 0);
        this.btnCheckChanged.setEnabled(this.mergeObjects.length > 0);
        this.btnCheckRemoved.setEnabled(this.mergeObjects.length > 0);
        this.btnPerformMerge.setEnabled(this.mergeObjects.length > 0);
    }

    private void toggleAction(int n) {
        boolean bl = true;
        boolean bl2 = false;
        for (MergeObject mergeObject : this.mergeObjects) {
            if (mergeObject.action != n) continue;
            if (!bl2) {
                bl = !mergeObject.accept;
                bl2 = true;
            }
            mergeObject.accept = bl;
        }
        this.localDtm.fireTableDataChanged();
    }

    private int getGroupIndex(int n, boolean bl) {
        if (bl) {
            return n << 11 | 0x10000;
        }
        return n << 11;
    }

    private int getGroupIndex(int n, int n2, boolean bl) {
        if (bl) {
            return n << 11 | n2 << 8 | 0x20000;
        }
        return n << 11 | n2 << 8;
    }

    private void compare() {
        HashMap<Integer, MergeObject> hashMap = new HashMap<Integer, MergeObject>();
        for (MainGroup object2 : this.remoteEsfData.getFilledMainGroups()) {
            hashMap.put(this.getGroupIndex(object2.index, true), new MergeGroup(object2, 3));
            for (MiddleGroup middleGroup : this.remoteEsfData.getFilledMiddleGroups(object2.index)) {
                hashMap.put(this.getGroupIndex(middleGroup.main, middleGroup.index, true), new MergeGroup(middleGroup, 3));
                for (ESFElement eSFElement : this.remoteEsfData.getElementsInGroup(object2.index, middleGroup.index)) {
                    hashMap.put(eSFElement.getAddress().getIntAddress(), new MergeElement(eSFElement, 3));
                }
            }
        }
        for (MainGroup mainGroup : this.localEsfData.getFilledMainGroups()) {
            MainGroup mainGroup2 = this.remoteEsfData.mainGroup[mainGroup.index];
            if (mainGroup2 == null) {
                hashMap.put(this.getGroupIndex(mainGroup.index, true), new MergeGroup(mainGroup, 1));
            } else if (!mainGroup2.title.equals(mainGroup.title)) {
                hashMap.put(this.getGroupIndex(mainGroup.index, true), new MergeGroup(mainGroup, 2));
            } else if (hashMap.containsKey(this.getGroupIndex(mainGroup2.index, true))) {
                ((MergeObject)hashMap.get((Object)Integer.valueOf((int)this.getGroupIndex((int)mainGroup2.index, (boolean)true)))).action = 0;
            }
            for (MiddleGroup middleGroup : this.localEsfData.getFilledMiddleGroups(mainGroup.index)) {
                if (mainGroup2 == null) {
                    hashMap.put(this.getGroupIndex(middleGroup.main, middleGroup.index, true), new MergeGroup(middleGroup, 1));
                } else {
                    ESFElement[] eSFElementArray = mainGroup2.middleGroup[middleGroup.index];
                    if (eSFElementArray == null) {
                        hashMap.put(this.getGroupIndex(middleGroup.main, middleGroup.index, true), new MergeGroup(middleGroup, 1));
                    } else if (!eSFElementArray.title.equals(middleGroup.title)) {
                        hashMap.put(this.getGroupIndex(middleGroup.main, middleGroup.index, true), new MergeGroup(middleGroup, 2));
                    } else if (hashMap.containsKey(this.getGroupIndex(eSFElementArray.main, eSFElementArray.index, true))) {
                        ((MergeObject)hashMap.get((Object)Integer.valueOf((int)this.getGroupIndex((int)eSFElementArray.main, (int)eSFElementArray.index, (boolean)true)))).action = 0;
                    }
                }
                for (ESFElement eSFElement : this.localEsfData.getElementsInGroup(mainGroup.index, middleGroup.index)) {
                    ESFElement eSFElement2 = this.remoteEsfData.getElementByAddress(eSFElement.getAddress().getIntAddress());
                    if (eSFElement2 == null) {
                        hashMap.put(eSFElement.getAddress().getIntAddress(), new MergeElement(eSFElement, 1));
                        continue;
                    }
                    if (!eSFElement2.getTitle().equals(eSFElement.getTitle()) || !this.chkIgnoreDataType.isSelected() && eSFElement2.getDataType().getTypeIndex() != eSFElement.getDataType().getTypeIndex()) {
                        if (this.chkIgnoreDataType.isSelected()) {
                            eSFElement.setDataType(eSFElement2.getDataType());
                        }
                        hashMap.put(eSFElement.getAddress().getIntAddress(), new MergeElement(eSFElement, 2));
                        continue;
                    }
                    ((MergeObject)hashMap.get((Object)Integer.valueOf((int)eSFElement.getAddress().getIntAddress()))).action = 0;
                }
            }
        }
        for (Integer n : hashMap.keySet().toArray(new Integer[hashMap.size()])) {
            MergeObject mergeObject = (MergeObject)hashMap.get(n);
            if (mergeObject.action != 0) continue;
            hashMap.remove(n);
        }
        this.mergeObjects = hashMap.values().toArray(new MergeObject[hashMap.size()]);
        Arrays.sort(this.mergeObjects, new Comparator<MergeObject>(){

            @Override
            public int compare(MergeObject mergeObject, MergeObject mergeObject2) {
                return mergeObject.index - mergeObject2.index;
            }
        });
        this.localDtm.fireTableDataChanged();
        this.checkButtons();
    }

    private void perform() {
        Boolean bl = null;
        block9: for (MergeObject mergeObject : this.mergeObjects) {
            if (!mergeObject.accept) continue;
            if (mergeObject.action == 3 && bl == null) {
                int n = JOptionPane.showConfirmDialog(this, STRING_CONFIRM_REMOVE, STRING_TITLE, 0);
                bl = n == 0;
            }
            if (mergeObject.isGroup()) {
                MergeGroup mergeGroup = mergeObject.MG();
                switch (mergeObject.action) {
                    case 1: {
                        if (mergeGroup.group instanceof MainGroup) {
                            this.remoteEsfData.mainGroup[mergeGroup.group.index].title = mergeGroup.group.title;
                            break;
                        }
                        MiddleGroup middleGroup = (MiddleGroup)mergeGroup.group;
                        this.remoteEsfData.mainGroup[middleGroup.main].middleGroup[middleGroup.index].title = middleGroup.title;
                        break;
                    }
                    case 2: {
                        if (mergeGroup.group instanceof MainGroup) {
                            this.remoteEsfData.mainGroup[mergeGroup.group.index].title = mergeGroup.group.title;
                            break;
                        }
                        MiddleGroup middleGroup = (MiddleGroup)mergeGroup.group;
                        this.remoteEsfData.mainGroup[middleGroup.main].middleGroup[middleGroup.index].title = middleGroup.title;
                        break;
                    }
                }
            }
            if (!mergeObject.isElement()) continue;
            switch (mergeObject.action) {
                case 1: {
                    this.remoteEsfData.addElement(mergeObject.ME().element, false);
                    continue block9;
                }
                case 2: {
                    this.remoteEsfData.addElement(mergeObject.ME().element, false);
                    continue block9;
                }
                case 3: {
                    if (!bl.booleanValue()) continue block9;
                    this.remoteEsfData.removeElement(mergeObject.ME().element);
                }
            }
        }
        this.remoteEsfData.fireDataChanged();
        this.compare();
        this.hasBeenChanged = true;
    }

    public boolean hasBeenChanged() {
        return this.hasBeenChanged;
    }

    private void openLocalFile() {
        JFileChooser jFileChooser = new JFileChooser(this.latestFile);
        jFileChooser.setFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return "ESF/ESFx";
            }

            @Override
            public boolean accept(File file) {
                return file.isDirectory() || file.getAbsolutePath().endsWith(".esf") || file.getAbsolutePath().endsWith(".esfx");
            }
        });
        if (jFileChooser.showOpenDialog(this) == 0) {
            this.latestFile = jFileChooser.getSelectedFile();
            try {
                ESFFactory.parseData(new FileInputStream(this.latestFile), this.localEsfData);
                this.compare();
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
        }
    }

    public static void main(String[] stringArray) {
        Serializable serializable;
        Serializable serializable2;
        Object object;
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel");
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println("No Nimbus Look&Feel installed");
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            unsupportedLookAndFeelException.printStackTrace();
        }
        ESFData eSFData = new ESFData();
        try {
            object = new HostInformation("ept4", 80);
            serializable2 = ((HostInformation)object).getURL("users/bt1/config/data.esf");
            serializable = ((HostInformation)object).getURL("users/bt1/config/data.esfx");
            ESFFactory.parseData((URL)serializable, serializable2, eSFData);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        object = new ESFData();
        try {
            ESFFactory.parseData(new FileInputStream("/home/timo/Desktop/data.esf"), (ESFData)object);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        serializable2 = new ESFMergePanel(eSFData);
        serializable = new JFrame(STRING_TITLE);
        ((JFrame)serializable).setDefaultCloseOperation(3);
        ((JFrame)serializable).getContentPane().setLayout(new BorderLayout());
        ((JFrame)serializable).getContentPane().add((Component)serializable2, "Center");
        ((Window)serializable).pack();
        ((Window)serializable).setVisible(true);
    }

    class MergeGroup
    extends MergeObject {
        ESFGroup group;

        public MergeGroup(ESFGroup eSFGroup, int n) {
            super(0, n);
            if (eSFGroup instanceof MainGroup) {
                this.index = ESFMergePanel.this.getGroupIndex(eSFGroup.index, 0, false);
            }
            if (eSFGroup instanceof MiddleGroup) {
                this.index = ESFMergePanel.this.getGroupIndex(((MiddleGroup)eSFGroup).main, eSFGroup.index, false);
            }
            this.group = eSFGroup;
        }

        public String toString() {
            if (this.group instanceof MainGroup) {
                if (EIBAddressFormat.is2Layer()) {
                    return this.group.index + "/*";
                }
                return this.group.index + "/*/*";
            }
            if (this.group instanceof MiddleGroup) {
                return ((MiddleGroup)this.group).main + "/" + this.group.index + "/*";
            }
            return "group.index";
        }
    }

    class MergeElement
    extends MergeObject {
        ESFElement element;

        public MergeElement(ESFElement eSFElement, int n) {
            super(eSFElement.getAddress().getIntAddress(), n);
            this.element = eSFElement;
        }

        public String toString() {
            return this.element.getAddress().getStrAddress();
        }
    }

    class MergeObject {
        boolean accept = false;
        int index;
        int action;

        public MergeObject(int n, int n2) {
            this.index = n;
            this.action = n2;
        }

        public boolean isElement() {
            return this instanceof MergeElement;
        }

        public boolean isGroup() {
            return this instanceof MergeGroup;
        }

        public MergeElement ME() {
            if (!this.isElement()) {
                return null;
            }
            return (MergeElement)this;
        }

        public MergeGroup MG() {
            if (!this.isGroup()) {
                return null;
            }
            return (MergeGroup)this;
        }
    }
}

