/*
 * Decompiled with CFR 0.152.
 */
package de.eibport.components.login;

import de.eibport.components.login.EpUser;
import de.eibport.components.login.ILoginUser;
import de.eibport.components.login.IUserPool;
import de.eibport.components.login.UserPoolListener;
import de.eibport.net.sftp.FileInterface;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.NoRouteToHostException;
import java.util.ArrayList;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class UserPool
implements IUserPool {
    private Document doc;
    private ArrayList<EpUser> users = new ArrayList();
    private UserPoolListener upl = null;

    public UserPool(Document document, UserPoolListener userPoolListener) {
        this.doc = document;
        this.upl = userPoolListener;
        for (Element element : document.getRootElement().getChildren()) {
            this.users.add(new EpUser(element));
        }
    }

    public UserPool(FileInterface fileInterface) {
        this.loadFromFileInterface(fileInterface, "/home/bt1/config/users.xml");
    }

    public UserPool(FileInterface fileInterface, String string) {
        this.loadFromFileInterface(fileInterface, string);
    }

    private void loadFromFileInterface(final FileInterface fileInterface, final String string) {
        try {
            InputStream inputStream = fileInterface.readFromFile(string, true);
            try {
                this.doc = new SAXBuilder().build(inputStream);
                this.upl = new UserPoolListener(){

                    @Override
                    public boolean save() {
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                        try {
                            new XMLOutputter(Format.getPrettyFormat()).output(UserPool.this.doc, (OutputStream)byteArrayOutputStream);
                            fileInterface.writeToFile(string, byteArrayOutputStream.toByteArray());
                            return true;
                        }
                        catch (IOException iOException) {
                            return false;
                        }
                    }
                };
                for (Element element : this.doc.getRootElement().getChildren()) {
                    this.users.add(new EpUser(element));
                }
            }
            catch (JDOMException jDOMException) {
                jDOMException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        catch (NoRouteToHostException noRouteToHostException) {
            // empty catch block
        }
    }

    @Override
    public ILoginUser getUser(String string, String string2) {
        for (EpUser epUser : this.users) {
            if (!epUser.getUsername().equals(string) || !epUser.getPassword().equals(string2)) continue;
            return epUser;
        }
        return null;
    }

    @Override
    public ILoginUser[] getUserArray() {
        EpUser[] epUserArray = new EpUser[this.users.size()];
        return this.users.toArray(epUserArray);
    }

    @Override
    public boolean save(ILoginUser iLoginUser) {
        if (this.upl != null) {
            return this.upl.save();
        }
        return false;
    }

    public Document getDocument() {
        this.doc.getRootElement().removeContent();
        for (EpUser epUser : this.users) {
            this.doc.getRootElement().addContent(epUser.getElement());
        }
        return this.doc;
    }
}

