/*
 * Decompiled with CFR 0.152.
 */
package de.eibport.components.monitor;

import de.eibport.components.monitor.MonitorModel;
import de.eibport.net.bmx.BMXConnectionHandler;
import de.eibport.net.bmx.BMXListenerAdapter;
import de.eibport.net.bmx.BMXPackets;
import de.eibport.net.bmx.BMXTelegram;

public abstract class BmxMonitorController {
    public static final int ACTION_WAITING = 0;
    public static final int ACTION_REFRESH_STATUS_TABLE = 1;
    public static final int ACTION_REFRESH_HISTORY = 2;
    private MonitorModel<BMXTelegram> model = new MonitorModel();
    private BMXConnectionHandler conn;
    private BMXListenerAdapter currentListener;
    private int currentAction = 0;
    int tcount = 0;

    public BmxMonitorController(BMXConnectionHandler bMXConnectionHandler) {
        this.conn = bMXConnectionHandler;
    }

    protected abstract void actionStarted(int var1);

    protected abstract void actionFinished(int var1);

    protected abstract void actionCanceled(int var1);

    public MonitorModel<BMXTelegram> getModel() {
        return this.model;
    }

    public void refreshStatusTable() {
        if (this.currentAction != 0) {
            this.cancel();
        }
        this.model.clearItems();
        this.conn.setConnectionStatus(this, 1);
        this.currentListener = new BMXListenerAdapter(){

            @Override
            public void getTelegram(BMXTelegram bMXTelegram) {
                if (bMXTelegram.getAddress() != 0 || bMXTelegram.getDate() != 0.0) {
                    BmxMonitorController.this.model.addItem(bMXTelegram);
                }
            }

            @Override
            public void addressTableCompleted() {
                BmxMonitorController.this.cleanupAction(this);
                BmxMonitorController.this.actionFinished(BmxMonitorController.this.currentAction);
                BmxMonitorController.this.currentAction = 0;
                BmxMonitorController.this.tcount = 0;
            }
        };
        this.conn.getBMXConnection().addBMXListener(this.currentListener);
        this.currentAction = 1;
        this.actionStarted(this.currentAction);
        this.conn.sendPacket(BMXPackets.constructGetTeleTabelle());
    }

    public void refreshHistory() {
        if (this.currentAction != 0) {
            this.cancel();
        }
        this.model.clearItems();
        this.conn.setConnectionStatus(this, 1);
        this.currentListener = new BMXListenerAdapter(){

            @Override
            public void getTraceListe(BMXTelegram bMXTelegram) {
                if (bMXTelegram.getStatusFunction() == 6 || bMXTelegram.getStatusFunction() == 2) {
                    BmxMonitorController.this.model.addItem(bMXTelegram);
                } else if (bMXTelegram.getDate() == 0.0) {
                    BmxMonitorController.this.cleanupAction(this);
                    BmxMonitorController.this.actionFinished(BmxMonitorController.this.currentAction);
                    BmxMonitorController.this.currentAction = 0;
                }
            }
        };
        this.conn.getBMXConnection().addBMXListener(this.currentListener);
        this.currentAction = 2;
        this.actionStarted(this.currentAction);
        this.conn.sendPacket(BMXPackets.constructTraceListe());
    }

    private void cancel() {
        if (this.currentListener != null) {
            this.cleanupAction(this.currentListener);
            this.actionCanceled(this.currentAction);
            this.currentAction = 0;
        }
    }

    private void cleanupAction(BMXListenerAdapter bMXListenerAdapter) {
        this.conn.getBMXConnection().removeBMXListener(bMXListenerAdapter);
        this.conn.setConnectionStatus(this, 0);
    }
}

