/*
 * Decompiled with CFR 0.152.
 */
package de.eibport.net;

import de.babtec.matrix.DongleProtect;
import de.babtec.matrix.Utils;
import de.babtec.matrix.exceptions.DPParseException;
import de.babtec.matrix.exceptions.DPReadException;
import de.babtec.matrix.exceptions.DongleProtectException;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;

public class HostInformation {
    private InetAddress address;
    private int http_port = 80;
    private int ssh_port = 22;
    private int bmx_tcp_port = 1735;
    private int bmx_udp_port = 1735;
    private String epName;
    private String fwVersion;
    private String sernr;
    private DongleProtect dp = new DongleProtect();

    public HostInformation(String string, int n) throws IOException {
        this.loadPorts(string, n);
    }

    private boolean loadPorts(String string, int n) throws IOException {
        try {
            this.address = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            unknownHostException.printStackTrace();
        }
        this.http_port = n == -1 ? 80 : n;
        try {
            URL uRL = new URL("http", string, n, "/yabusrc");
            this.loadPorts(uRL.openConnection().getInputStream());
            uRL = new URL("http", string, n, "/tmp/sernr");
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openConnection().getInputStream()));
            this.sernr = bufferedReader.readLine();
            uRL = new URL("http", string, n, "/fw_version");
            bufferedReader = new BufferedReader(new InputStreamReader(uRL.openConnection().getInputStream()));
            this.fwVersion = bufferedReader.readLine();
            uRL = new URL("http", string, n, "/name");
            bufferedReader = new BufferedReader(new InputStreamReader(uRL.openConnection().getInputStream()));
            this.epName = bufferedReader.readLine();
            return true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            try {
                URL uRL = new URL("http", string, n, "/bxdrc");
                System.out.println("reading " + uRL);
                return this.loadPorts(uRL.openConnection().getInputStream());
            }
            catch (FileNotFoundException fileNotFoundException2) {
                fileNotFoundException2.printStackTrace();
                return false;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return false;
            }
        }
    }

    private boolean loadPorts(InputStream inputStream) throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        String string2 = "^(\\w+)\\s*=\\s*\"?(\\d+)\"?";
        Pattern pattern = Pattern.compile(string2, 64);
        while ((string = bufferedReader.readLine()) != null) {
            Matcher matcher = pattern.matcher(string);
            if (!matcher.matches() || matcher.groupCount() < 2) continue;
            if (matcher.group(1).equals("bmx_tcp_port")) {
                this.bmx_tcp_port = Integer.parseInt(matcher.group(2));
                System.out.println("found bmx_tcp_port: " + this.bmx_tcp_port);
                continue;
            }
            if (matcher.group(1).equals("bmx_udp_port")) {
                this.bmx_udp_port = Integer.parseInt(matcher.group(2));
                System.out.println("found bmx_udp_port: " + this.bmx_udp_port);
                continue;
            }
            if (!matcher.group(1).equals("ssh_port")) continue;
            this.ssh_port = Integer.parseInt(matcher.group(2));
            System.out.println("found ssh_port: " + this.ssh_port);
        }
        return true;
    }

    public String getEpName() {
        return this.epName;
    }

    public String getFwVersion() {
        return this.fwVersion;
    }

    public String getSernr() {
        return this.sernr;
    }

    public InetAddress getHost() {
        return this.address;
    }

    public int getHttpPort() {
        return this.http_port;
    }

    public void setHttpPort(int n) {
        this.http_port = n;
    }

    public int getSshPort() {
        return this.ssh_port;
    }

    public void setSshPort(int n) {
        this.ssh_port = n;
    }

    public int getBmxTcpPort() {
        return this.bmx_tcp_port;
    }

    public void setBmxTcpPort(int n) {
        this.bmx_tcp_port = n;
    }

    public int getBmxUdpPort() {
        return this.bmx_udp_port;
    }

    public void setBmxUdpPort(int n) {
        this.bmx_udp_port = n;
    }

    public URL getBaseURL() {
        URL uRL = null;
        try {
            uRL = new URL("http", this.address.getHostAddress(), this.http_port, "/");
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        return uRL;
    }

    public URL getURL(String string) {
        if (!string.startsWith("/")) {
            string = "/" + string;
        }
        URL uRL = null;
        try {
            uRL = new URL("http", this.address.getHostAddress(), this.http_port, string);
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        return uRL;
    }

    public static int getComparableVersion(String string) {
        Pattern pattern = Pattern.compile(".*?(\\d*)\\.(\\d*).(\\d*)(?:-pre(\\d*))?");
        Matcher matcher = pattern.matcher(string);
        int n = 255;
        if (matcher.matches()) {
            n |= Integer.parseInt(matcher.group(1)) << 24;
            n |= Integer.parseInt(matcher.group(2)) << 16;
            n |= Integer.parseInt(matcher.group(3)) << 8;
            if (matcher.groupCount() > 4) {
                n |= Integer.parseInt(matcher.group(4));
            }
        }
        return n;
    }

    public boolean isEditorFree() {
        try {
            this.dp.init(null);
            boolean bl = this.dp.getProperty(1, 2);
            boolean bl2 = this.dp.getProperty(2, 2);
            String string = this.getSernr();
            if (Utils.isEibPortSernr(string) && bl) {
                return true;
            }
            if (Utils.isIpcSernr(string) && bl2) {
                return true;
            }
        }
        catch (DPReadException dPReadException) {
        }
        catch (DPParseException dPParseException) {
            if (dPParseException.getError() == 1) {
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "This dongle expired. Please contact b.a.b-technologie gmbh to reactivate this dongle.");
            }
        }
        catch (DongleProtectException dongleProtectException) {
            // empty catch block
        }
        return false;
    }

    public boolean isConfigToolFree() {
        try {
            this.dp.init(null);
            boolean bl = this.dp.getProperty(1, 1);
            boolean bl2 = this.dp.getProperty(2, 1);
            String string = this.getSernr();
            if (Utils.isEibPortSernr(string) && bl) {
                return true;
            }
            if (Utils.isIpcSernr(string) && bl2) {
                return true;
            }
        }
        catch (DPReadException dPReadException) {
        }
        catch (DPParseException dPParseException) {
            if (dPParseException.getError() == 1) {
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "This dongle expired. Please contact b.a.b-technologie gmbh to reactivate this dongle.");
            }
        }
        catch (DongleProtectException dongleProtectException) {
            // empty catch block
        }
        return false;
    }
}

