/*
 * Decompiled with CFR 0.152.
 */
package de.eibport.net.bmx;

import de.eibport.net.bmx.BMXPackets;
import de.eibport.net.bmx.interfaces.IBMXConnection;
import de.eibport.net.bmx.interfaces.IBMXConnectionThread;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.util.Date;

public class BMXConnectionThread
extends Thread
implements IBMXConnectionThread {
    public static final boolean DEBUG = false;
    private IBMXConnection owner;
    private byte[] buffer = new byte[8192];
    private int bufferUsed = 0;
    private Socket socket;
    private BufferedOutputStream out;
    private BufferedInputStream in;
    private boolean interrupted = false;
    private boolean pongReceived = false;
    private PingPongThread ppt;

    public BMXConnectionThread(IBMXConnection iBMXConnection) {
        this.setName(this.getClass().getName());
        this.owner = iBMXConnection;
    }

    @Override
    public boolean openSocket(String string, int n) {
        try {
            this.socket = new Socket(string, n);
            this.socket.setSoTimeout(30000);
            this.out = new BufferedOutputStream(this.socket.getOutputStream());
            this.in = new BufferedInputStream(this.socket.getInputStream());
            this.start();
            this.sendPing();
            return true;
        }
        catch (Exception exception) {
            System.out.println("(" + string + ":" + n + ") " + exception.getLocalizedMessage());
            return false;
        }
    }

    @Override
    public boolean closeSocket() {
        try {
            if (this.socket != null && this.socket.isConnected()) {
                this.interrupted = true;
                this.ppt.interrupt();
                this.in.close();
                this.out.close();
                this.socket.close();
            }
            return true;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
    }

    private void reconnect() {
        if (this.interrupted) {
            return;
        }
        this.interrupted = true;
        this.closeSocket();
        this.owner.socketConnectionInterrupted();
    }

    @Override
    public void sendPacket(byte[] byArray) {
        if (this.out != null) {
            try {
                this.out.write(byArray);
                this.out.flush();
            }
            catch (IOException iOException) {
                System.out.println("unable to send packet");
                this.reconnect();
            }
        }
    }

    @Override
    public void run() {
        while (!this.interrupted) {
            try {
                this.bufferUsed += this.in.read(this.buffer, this.bufferUsed, 8192 - this.bufferUsed);
            }
            catch (SocketException socketException) {
                if (!this.interrupted) {
                    this.reconnect();
                }
                this.interrupt();
            }
            catch (IOException iOException) {
                if (!this.interrupted) {
                    this.reconnect();
                }
                this.interrupt();
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                if (!this.interrupted) {
                    this.reconnect();
                }
                this.interrupt();
            }
            boolean bl = true;
            while (this.bufferUsed >= 4 && bl) {
                int n = this.buffer[0] & 0xFF | (this.buffer[1] & 0xFF) << 8;
                if (n <= this.bufferUsed) {
                    byte[] byArray = new byte[n];
                    System.arraycopy(this.buffer, 0, byArray, 0, n);
                    this.parsePacket(byArray, n);
                    this.bufferUsed -= n;
                    System.arraycopy(this.buffer, n, this.buffer, 0, this.bufferUsed);
                    continue;
                }
                bl = false;
            }
        }
        this.interrupt();
    }

    private void parsePacket(byte[] byArray, int n) {
        int n2 = byArray[2] | byArray[3] << 8;
        switch (n2) {
            case 10: {
                this.sendPacket(BMXPackets.constructPongPacket());
                break;
            }
            case 11: {
                this.pongReceived = true;
                break;
            }
            default: {
                this.owner.parsePacket(byArray, n);
            }
        }
    }

    public void noPongReceived() {
        System.out.println(new Date() + " no pong received");
    }

    public void sendPing() {
        this.pongReceived = false;
        this.ppt = new PingPongThread();
        this.ppt.start();
    }

    class PingPongThread
    extends Thread {
        PingPongThread() {
        }

        @Override
        public void run() {
            BMXConnectionThread.this.sendPacket(BMXPackets.constructPingPacket());
            try {
                Thread.sleep(15000L);
                if (!BMXConnectionThread.this.pongReceived) {
                    BMXConnectionThread.this.noPongReceived();
                }
                BMXConnectionThread.this.sendPing();
            }
            catch (InterruptedException interruptedException) {
                this.interrupt();
            }
        }
    }
}

