/*
 * Decompiled with CFR 0.152.
 */
package de.eibport.net.bmx.eibaddress;

import de.eibport.net.bmx.eibaddress2.EIBAddressFormat;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

public class Address {
    private int address;

    public Address(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        if (Pattern.matches("\\A(\\d{1,2})\\/(\\d{1,4})\\Z", string)) {
            this.address = (Integer.parseInt(stringTokenizer.nextToken()) & 0xFF) << 11 | Integer.parseInt(stringTokenizer.nextToken()) & 0x7FF;
        } else if (Pattern.matches("\\A(\\d{1,2})\\/(\\d{1,2})\\/(\\d{1,3})\\Z", string)) {
            this.address = (Integer.parseInt(stringTokenizer.nextToken()) & 0x1F) << 11 | (Integer.parseInt(stringTokenizer.nextToken()) & 7) << 8 | Integer.parseInt(stringTokenizer.nextToken()) & 0xFF;
        }
    }

    public Address(int n, int n2, int n3) {
        this.address = n << 11 | n2 << 8 | n3 & 0xFF;
    }

    public Address(int n, int n2) {
        this.address = n << 11 | n2 & 0x7FF;
    }

    public Address(int n) {
        this.address = n;
    }

    public int getMain() {
        return (this.address & 0xF800) >> 11;
    }

    public int getMiddle() {
        return (this.address & 0x700) >> 8;
    }

    public int getSub2Layer() {
        return this.address & 0x7FF;
    }

    public int getSub3Layer() {
        return this.address & 0xFF;
    }

    public int getIntAddress() {
        return this.address;
    }

    public String getString(int n) {
        String string = "";
        string = n == 2 ? string + (int)Math.floor(this.address / 2048) + "/" + this.address % 2048 : string + (int)Math.floor(this.address / 2048) + "/" + (int)Math.floor(this.address % 2048 / 256) + "/" + this.address % 256;
        return string;
    }

    public String getString() {
        return this.getString(EIBAddressFormat.getAddressFormat());
    }
}

