/*
 * Decompiled with CFR 0.152.
 */
package de.eibport.net.bmx.eibaddress2;

import de.eibport.net.bmx.eibaddress2.EIBAddressFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EIBAddress2
implements Comparable<EIBAddress2> {
    private static final Pattern pt2 = Pattern.compile("\\A(\\d{1,2})\\/(\\d{1,4})\\Z", 64);
    private static final Pattern pt3 = Pattern.compile("\\A(\\d{1,2})\\/(\\d{1,2})\\/(\\d{1,3})\\Z", 64);
    private static Matcher match;
    private int address;

    private EIBAddress2(int n) {
        this.address = n;
    }

    public int getIntAddress() {
        return this.address;
    }

    public String getStrAddress() {
        return EIBAddress2.getStrAddress(this.address);
    }

    public static String getStrAddress(int n) {
        if (n < 0) {
            return "";
        }
        String string = "";
        if (EIBAddressFormat.getAddressFormat() == 2) {
            string = EIBAddress2.getMain(n) + "/" + EIBAddress2.getSub2(n);
        }
        if (EIBAddressFormat.getAddressFormat() == 3) {
            string = EIBAddress2.getMain(n) + "/" + EIBAddress2.getMiddle(n) + "/" + EIBAddress2.getSub3(n);
        }
        return string;
    }

    public int getMain() {
        return EIBAddress2.getMain(this.address);
    }

    public int getMiddle() {
        return EIBAddress2.getMiddle(this.address);
    }

    public int getSub3() {
        return EIBAddress2.getSub3(this.address);
    }

    public int getSub2() {
        return EIBAddress2.getSub2(this.address);
    }

    public static int getMain(int n) {
        return (n & 0xF800) >> 11;
    }

    public static int getMiddle(int n) {
        return (n & 0x700) >> 8;
    }

    public static int getSub3(int n) {
        return n & 0xFF;
    }

    public static int getSub2(int n) {
        return n & 0x7FF;
    }

    public static boolean isValid(String string) {
        return EIBAddress2.getValidAddress(string) != -1;
    }

    public static int getValidAddress(String string) {
        int n = -1;
        if (string == null) {
            return n;
        }
        match = pt2.matcher(string);
        if (match.matches()) {
            int n2 = Integer.parseInt(match.group(1));
            int n3 = Integer.parseInt(match.group(2));
            n = EIBAddress2.getIntAddress(n2, n3);
        } else {
            match = pt3.matcher(string);
            if (match.matches()) {
                int n4 = Integer.parseInt(match.group(1));
                int n5 = Integer.parseInt(match.group(2));
                int n6 = Integer.parseInt(match.group(3));
                n = EIBAddress2.getIntAddress(n4, n5, n6);
            }
        }
        return n;
    }

    public static int getIntAddress(int n, int n2, int n3) {
        int n4;
        if (n >= 0 && n <= 31 && n2 >= 0 && n2 <= 7 && n3 >= 0 && n3 <= 255 && (n4 = n << 11 | n2 << 8 | n3) > 0 && n4 <= 65535) {
            return n4;
        }
        return -1;
    }

    public static int getIntAddress(int n, int n2) {
        int n3;
        if (n >= 0 && n <= 31 && n2 >= 0 && n2 <= 2047 && (n3 = n << 11 | n2) > 0 && n3 <= 65535) {
            return n3;
        }
        return -1;
    }

    public static boolean isValid(int n) {
        return n > 0 && n < 65535;
    }

    public static EIBAddress2 getAddress(String string) {
        int n = EIBAddress2.getValidAddress(string);
        if (n != -1) {
            return new EIBAddress2(n);
        }
        return null;
    }

    public static EIBAddress2 getAddress(int n) {
        if (EIBAddress2.isValid(n)) {
            return new EIBAddress2(n);
        }
        return null;
    }

    public static EIBAddress2 getAddress(int n, int n2) {
        return EIBAddress2.getAddress(EIBAddress2.getIntAddress(n, n2));
    }

    public static EIBAddress2 getAddress(int n, int n2, int n3) {
        return EIBAddress2.getAddress(EIBAddress2.getIntAddress(n, n2, n3));
    }

    @Override
    public int compareTo(EIBAddress2 eIBAddress2) {
        return this.address - eIBAddress2.address;
    }
}

