/*
 * Decompiled with CFR 0.152.
 */
package de.eibport.net.bmx.jobs.data;

import de.eibport.net.bmx.eibaddress2.EIBAddressObject2;
import de.eibport.net.bmx.jobs.BMXJobData;
import de.eibport.net.bmx.jobs.BMXJobList;
import de.eibport.net.bmx.jobs.data.BMXJobModel;
import java.util.ArrayList;
import java.util.List;

public class BMXLogicModel
extends BMXJobModel {
    public static final int OPERATION_AND = 0;
    public static final int OPERATION_OR = 1;
    public static final int OPERATION_XOR = 2;
    public static final int OPERATION_OBJECT = 3;
    public static final int OPERATION_NAND = 4;
    public static final int OPERATION_NOR = 5;
    public static final int OPERATION_NXOR = 6;
    public static final int OPERATION_NOBJECT = 7;
    public static final int SEND_ON_CHANGE = 0;
    public static final int SEND_ALWAYS = 1;
    public static final int FILTER_NONE = 0;
    public static final int FILTER_ON = 1;
    public static final int FILTER_OFF = 2;
    private EIBAddressObject2 objEnable;
    private EIBAddressObject2 objOutput;
    private ArrayList<EIBAddressObject2> objInputs = new ArrayList();
    private int operation;
    private int send;
    private int filter;

    public BMXLogicModel(BMXJobData bMXJobData) {
        this.setBMXJobData(bMXJobData);
    }

    public BMXLogicModel() {
    }

    public void setObjectEnable(EIBAddressObject2 eIBAddressObject2) {
        this.objEnable = eIBAddressObject2;
    }

    public EIBAddressObject2 getObjectEnable() {
        return this.objEnable;
    }

    public void setObjectOutput(EIBAddressObject2 eIBAddressObject2) {
        this.objOutput = eIBAddressObject2;
    }

    public EIBAddressObject2 getObjectOutput() {
        return this.objOutput;
    }

    public void setInputs(List<EIBAddressObject2> list) {
        this.objInputs.clear();
        this.objInputs.addAll(list);
    }

    public ArrayList<EIBAddressObject2> getInputs() {
        return this.objInputs;
    }

    public void setOperation(int n) {
        this.operation = n;
    }

    public int getOperation() {
        return this.operation;
    }

    public void setSend(int n) {
        this.send = n;
    }

    public int getSend() {
        return this.send;
    }

    public void setFilter(int n) {
        this.filter = n;
    }

    public int getFilter() {
        return this.filter;
    }

    @Override
    public void setBMXJobData(BMXJobData bMXJobData) {
        super.setBMXJobData(bMXJobData);
        this.objEnable = bMXJobData.getEIBAddressObject2(0);
        this.objOutput = bMXJobData.getEIBAddressObject2(1);
        this.operation = bMXJobData.getParam()[0] & 7;
        this.send = (bMXJobData.getParam()[0] & 0x10) >> 4;
        this.filter = (bMXJobData.getParam()[0] & 0xC0) >> 6;
        this.filter %= 3;
        int n = bMXJobData.getAddressObjectCount() - 2;
        for (int i = 0; i < n; ++i) {
            this.objInputs.add(bMXJobData.getEIBAddressObject2(i + 2));
        }
    }

    @Override
    public BMXJobData getJobData() {
        byte by = 0;
        by = (byte)(by | this.operation);
        by = (byte)(by | (this.send & 1) << 4);
        by = (byte)(by | (this.filter & 3) << 6);
        BMXJobData bMXJobData = this.getJobData(BMXJobList.LIBID_LOGIC, new byte[]{by});
        bMXJobData.addEIBAddressObject2(this.objEnable);
        bMXJobData.addEIBAddressObject2(this.objOutput);
        for (EIBAddressObject2 eIBAddressObject2 : this.objInputs) {
            bMXJobData.addEIBAddressObject2(eIBAddressObject2);
        }
        return bMXJobData;
    }

    @Override
    public String toString() {
        String string = System.getProperty("line.separator");
        String string2 = super.toString() + string;
        string2 = string2 + "Object Enable: " + this.objEnable.getAddressObjectAsString() + string;
        string2 = string2 + "Object Output: " + this.objOutput.getAddressObjectAsString() + string;
        string2 = string2 + "Operation: " + this.operation + string;
        string2 = string2 + "Send: " + this.send + string;
        string2 = string2 + "Filter: " + this.filter + string;
        string2 = string2 + "Inputs: " + this.objInputs.size() + string;
        for (EIBAddressObject2 eIBAddressObject2 : this.objInputs) {
            string2 = string2 + "Input: " + eIBAddressObject2.getAddressObjectAsString() + string;
        }
        return string2;
    }
}

