/*
 * Decompiled with CFR 0.152.
 */
package de.eibport.net.bmx.jobs.data.httpreq;

import de.eibport.net.bmx.eibaddress2.EIBAddressObject2;
import de.eibport.net.bmx.jobs.BMXJobData;
import de.eibport.net.bmx.jobs.BMXJobList;
import de.eibport.net.bmx.jobs.data.BMXJobModel;
import de.eibport.net.bmx.jobs.data.httpreq.HttpReqTargetModel;
import de.eibport.net.bmx.jobs.data.httpreq.HttpReqValueModel;
import de.eibport.net.utils.ByteConv;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class BMXHttpReqModel
extends BMXJobModel {
    public static final int JOBS_HTTPRQ_MAX_TARGETS = 8;
    public static final int JOBS_HTTPRQ_MAX_VALUES = 10;
    public static final int JOBS_HTTPRQ_MAX_REPLACEMENTS = 12;
    public static final int JOBS_HTTPRQ_MAX_OUTPUTS = 4;
    public static final int JOBS_HTTPRQ_MAX_PROTOCOL_LEN = 16;
    public static final int JOBS_HTTPRQ_MAX_BASEURL_LEN = 2048;
    public static final int JOBS_HTTPRQ_MAX_AUTH_NAME_LEN = 64;
    public static final int JOBS_HTTPRQ_MAX_AUTH_PASSWD_LEN = 64;
    public static final int JOBS_HTTPRQ_MAX_PROXY_URL_LEN = 1024;
    public static final int JOBS_HTTPRQ_MAX_PROXY_NAME_LEN = 64;
    public static final int JOBS_HTTPRQ_MAX_PROXY_PASSWD_LEN = 64;
    public static final int JOBS_HTTPRQ_MAX_USERAGENT_LEN = 128;
    public static final int JOBS_HTTPRQ_MAX_TARGETURL_LEN = 256;
    public static final int JOBS_HTTPRQ_POST_DATA_LEN = 128;
    public static final int JOBS_HTTPRQ_CA_FILENAME_LEN = 32;
    public static final int JOBS_HTTPRQ_CERT_FILENAME_LEN = 32;
    public static final int JOBS_HTTPRQ_ADD_HEADERS_LEN = 128;
    public static final int JOBS_HTTPRQ_FLAGS_FOLLOW_LOCATION = 1;
    public static final int JOBS_HTTPRQ_FLAGS_VERBOSE = 2;
    public static final int JOBS_HTTPRQ_FLAGS_FAILONERROR = 4;
    public static final int JOBS_HTTPRQ_FLAGS_SSL_VERIFYPEER = 8;
    public static final int JOBS_HTTPRQ_FLAGS_ALL = 15;
    public static final int JOBS_HTTPRQ_VALUE_FORMAT_EIS1_CONST_LEN = 32;
    public static final int JOBS_HTTPRQ_VALUE_FORMAT_STRING_LEN = 16;
    public static final int JOBS_HTTPRQ_VALUE_FORMAT_FLAG_ESCAPE_URL = 1;
    public static final int JOBS_HTTPRQ_VALUE_FORMAT_FLAG_TRIGGER = 2;
    public static final int JOBS_HTTPRQ_TARGET_FLAG_WILDCARD = 128;
    public static final int JOBS_HTTPRQ_OBMAX = 18;
    private int flags;
    private int total_timeout;
    private int max_size_k;
    private String protocol;
    private String baseURL;
    private String auth_name;
    private String auth_passwd;
    private String proxy_url;
    private String proxy_name;
    private String proxy_passwd;
    private String useragent;
    private byte post_type;
    private String post_data;
    private String ca_file;
    private String cert_file;
    private String additional_headers;
    private HttpReqValueModel[] value_format = new HttpReqValueModel[10];
    private byte result_eis;
    private byte output_implementation;
    private byte target_count;
    private HttpReqTargetModel[] targets = new HttpReqTargetModel[8];
    private EIBAddressObject2 objEnable;
    private EIBAddressObject2 objInput;
    private EIBAddressObject2[] objValue = new EIBAddressObject2[10];
    private EIBAddressObject2 objErrorTxt;
    private EIBAddressObject2 objResult;
    private EIBAddressObject2[] objOutput = new EIBAddressObject2[4];

    public BMXHttpReqModel(BMXJobData bMXJobData) {
        this();
        this.setBMXJobData(bMXJobData);
    }

    public BMXHttpReqModel() {
        int n;
        for (n = 0; n < 10; ++n) {
            this.value_format[n] = new HttpReqValueModel();
        }
        for (n = 0; n < 8; ++n) {
            this.targets[n] = new HttpReqTargetModel();
        }
    }

    @Override
    public void setBMXJobData(BMXJobData bMXJobData) {
        int n;
        int n2;
        super.setBMXJobData(bMXJobData);
        byte[] byArray = bMXJobData.getParam();
        int n3 = 0;
        this.flags = ByteConv.byte2short(byArray, n3);
        this.total_timeout = ByteConv.byte2short(byArray, n3 += 2);
        this.max_size_k = ByteConv.byte2short(byArray, n3 += 2);
        this.protocol = new String(byArray, n3 += 2, 16).trim();
        this.baseURL = new String(byArray, n3 += 16, 2048).trim();
        this.auth_name = new String(byArray, n3 += 2048, 64).trim();
        this.auth_passwd = new String(byArray, n3 += 64, 64).trim();
        this.proxy_url = new String(byArray, n3 += 64, 1024).trim();
        this.proxy_name = new String(byArray, n3 += 1024, 64).trim();
        this.proxy_passwd = new String(byArray, n3 += 64, 64).trim();
        this.useragent = new String(byArray, n3 += 64, 128).trim();
        n3 += 128;
        this.post_type = byArray[n3++];
        this.post_data = new String(byArray, n3, 128).trim();
        this.ca_file = new String(byArray, n3 += 128, 32).trim();
        this.cert_file = new String(byArray, n3 += 32, 32).trim();
        this.additional_headers = new String(byArray, n3 += 32, 128).trim();
        n3 += 128;
        for (n2 = 0; n2 < 10; ++n2) {
            this.value_format[n2].setEis(byArray[n3++]);
            this.value_format[n2].setFlags(byArray[n3++]);
            this.value_format[n2].setTrigger_eis14(byArray[n3++]);
            n = n3 + 64;
            switch (this.value_format[n2].getEis()) {
                case 1: {
                    this.value_format[n2].setEis1Text0(new String(byArray, n3, 32).trim());
                    this.value_format[n2].setEis1Text1(new String(byArray, n3 += 32, 32).trim());
                    n3 += 32;
                    break;
                }
                case 5: {
                    this.value_format[n2].setFactor(ByteConv.byte2float(byArray, n3));
                    this.value_format[n2].setOffset(ByteConv.byte2float(byArray, n3 += 4));
                    this.value_format[n2].setFormat(new String(byArray, n3 += 4, 16).trim());
                    n3 += 16;
                    break;
                }
                case 4: {
                    this.value_format[n2].setFormat(new String(byArray, n3, 16).trim());
                    n3 += 16;
                    break;
                }
                case 9: {
                    this.value_format[n2].setFactor(ByteConv.byte2float(byArray, n3));
                    this.value_format[n2].setOffset(ByteConv.byte2float(byArray, n3 += 4));
                    this.value_format[n2].setFormat(new String(byArray, n3 += 4, 16).trim());
                    n3 += 16;
                    break;
                }
                case 6: {
                    this.value_format[n2].setFormat(new String(byArray, n3, 16).trim());
                    n3 += 16;
                    break;
                }
                case 10: {
                    this.value_format[n2].setFormat(new String(byArray, n3, 16).trim());
                    n3 += 16;
                    break;
                }
                case 11: {
                    this.value_format[n2].setFormat(new String(byArray, n3, 16).trim());
                    n3 += 16;
                    break;
                }
                case 12: {
                    this.value_format[n2].setFormat(new String(byArray, n3, 16).trim());
                    n3 += 16;
                }
            }
            n3 = n;
        }
        this.result_eis = byArray[n3++];
        this.output_implementation = byArray[n3++];
        n3 += 1024;
        this.target_count = byArray[n3++];
        for (n2 = 0; n2 < 8; ++n2) {
            this.targets[n2].setFlags(byArray[n3++]);
            this.targets[n2].setTrigger(byArray[n3++]);
            this.targets[n2].setUrl(new String(byArray, n3, 256).trim());
            n3 += 256;
        }
        n2 = 0;
        this.objEnable = bMXJobData.getEIBAddressObject2(n2++);
        this.objInput = bMXJobData.getEIBAddressObject2(n2++);
        for (n = 0; n < 10; ++n) {
            this.objValue[n] = bMXJobData.getEIBAddressObject2(n2++);
        }
        this.objErrorTxt = bMXJobData.getEIBAddressObject2(n2++);
        this.objResult = bMXJobData.getEIBAddressObject2(n2++);
        for (n = 0; n < 4; ++n) {
            this.objOutput[n] = bMXJobData.getEIBAddressObject2(n2++);
        }
    }

    @Override
    public BMXJobData getJobData() {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            int n2;
            byteArrayOutputStream.write(ByteConv.short2byte(this.flags));
            byteArrayOutputStream.write(ByteConv.short2byte(this.total_timeout));
            byteArrayOutputStream.write(ByteConv.short2byte(this.max_size_k));
            byteArrayOutputStream.write(ByteConv.string2byteFixedLen(this.protocol, 16));
            byteArrayOutputStream.write(ByteConv.string2byteFixedLen(this.baseURL, 2048));
            byteArrayOutputStream.write(ByteConv.string2byteFixedLen(this.auth_name, 64));
            byteArrayOutputStream.write(ByteConv.string2byteFixedLen(this.auth_passwd, 64));
            byteArrayOutputStream.write(ByteConv.string2byteFixedLen(this.proxy_url, 1024));
            byteArrayOutputStream.write(ByteConv.string2byteFixedLen(this.proxy_name, 64));
            byteArrayOutputStream.write(ByteConv.string2byteFixedLen(this.proxy_passwd, 64));
            byteArrayOutputStream.write(ByteConv.string2byteFixedLen(this.useragent, 128));
            byteArrayOutputStream.write(this.post_type);
            byteArrayOutputStream.write(ByteConv.string2byteFixedLen(this.post_data, 128));
            byteArrayOutputStream.write(ByteConv.string2byteFixedLen(this.ca_file, 32));
            byteArrayOutputStream.write(ByteConv.string2byteFixedLen(this.cert_file, 32));
            byteArrayOutputStream.write(ByteConv.string2byteFixedLen(this.additional_headers, 128));
            for (n2 = 0; n2 < 10; ++n2) {
                byteArrayOutputStream.write(this.value_format[n2].getEis());
                byteArrayOutputStream.write(this.value_format[n2].getFlags());
                byteArrayOutputStream.write(this.value_format[n2].getTrigger_eis14());
                n = byteArrayOutputStream.size() + 64;
                switch (this.value_format[n2].getEis()) {
                    case 1: {
                        byteArrayOutputStream.write(ByteConv.string2byteFixedLen(this.value_format[n2].getEis1Text0(), 32));
                        byteArrayOutputStream.write(ByteConv.string2byteFixedLen(this.value_format[n2].getEis1Text1(), 32));
                        break;
                    }
                    case 5: {
                        byteArrayOutputStream.write(ByteConv.float2byte(this.value_format[n2].getFactor()));
                        byteArrayOutputStream.write(ByteConv.float2byte(this.value_format[n2].getOffset()));
                        byteArrayOutputStream.write(ByteConv.string2byteFixedLen(this.value_format[n2].getFormat(), 16));
                        break;
                    }
                    case 4: {
                        byteArrayOutputStream.write(ByteConv.string2byteFixedLen(this.value_format[n2].getFormat(), 16));
                        break;
                    }
                    case 9: {
                        byteArrayOutputStream.write(ByteConv.float2byte(this.value_format[n2].getFactor()));
                        byteArrayOutputStream.write(ByteConv.float2byte(this.value_format[n2].getOffset()));
                        byteArrayOutputStream.write(ByteConv.string2byteFixedLen(this.value_format[n2].getFormat(), 16));
                        break;
                    }
                    case 6: {
                        byteArrayOutputStream.write(ByteConv.string2byteFixedLen(this.value_format[n2].getFormat(), 16));
                        break;
                    }
                    case 10: {
                        byteArrayOutputStream.write(ByteConv.string2byteFixedLen(this.value_format[n2].getFormat(), 16));
                        break;
                    }
                    case 11: {
                        byteArrayOutputStream.write(ByteConv.string2byteFixedLen(this.value_format[n2].getFormat(), 16));
                        break;
                    }
                    case 12: {
                        byteArrayOutputStream.write(ByteConv.string2byteFixedLen(this.value_format[n2].getFormat(), 16));
                    }
                }
                if (byteArrayOutputStream.size() >= n) continue;
                byteArrayOutputStream.write(new byte[n - byteArrayOutputStream.size()]);
            }
            byteArrayOutputStream.write(this.result_eis);
            byteArrayOutputStream.write(this.output_implementation);
            byteArrayOutputStream.write(new byte[1024]);
            byteArrayOutputStream.write(this.target_count);
            for (n2 = 0; n2 < 8; ++n2) {
                byteArrayOutputStream.write(this.targets[n2].getFlags());
                byteArrayOutputStream.write(this.targets[n2].getTrigger());
                byteArrayOutputStream.write(ByteConv.string2byteFixedLen(this.targets[n2].getUrl(), 256));
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        System.out.println("Parameter size: " + byteArrayOutputStream.size());
        BMXJobData bMXJobData = this.getJobData(BMXJobList.LIBID_HTTPREQ, byteArrayOutputStream.toByteArray());
        bMXJobData.addEIBAddressObject2(this.objEnable);
        bMXJobData.addEIBAddressObject2(this.objInput);
        for (n = 0; n < 10; ++n) {
            bMXJobData.addEIBAddressObject2(this.objValue[n]);
        }
        bMXJobData.addEIBAddressObject2(this.objErrorTxt);
        bMXJobData.addEIBAddressObject2(this.objResult);
        for (n = 0; n < 4; ++n) {
            bMXJobData.addEIBAddressObject2(this.objValue[n]);
        }
        return bMXJobData;
    }

    @Override
    public String toString() {
        String string = System.getProperty("line.separator");
        String string2 = super.toString() + string;
        string2 = string2 + "Flags: \t" + this.flags + "\n";
        string2 = string2 + "total_timeout: \t" + this.total_timeout + "\n";
        string2 = string2 + "max_size_k: \t" + this.max_size_k + "\n";
        string2 = string2 + "protocol: \t" + this.protocol + "\n";
        string2 = string2 + "baseURL: \t" + this.baseURL + "\n";
        string2 = string2 + "auth_name: \t" + this.auth_name + "\n";
        string2 = string2 + "auth_passwd: \t" + this.auth_passwd + "\n";
        string2 = string2 + "proxy_url: \t" + this.proxy_url + "\n";
        string2 = string2 + "proxy_name: \t" + this.proxy_name + "\n";
        string2 = string2 + "proxy_passwd: \t" + this.proxy_passwd + "\n";
        string2 = string2 + "useragent: \t" + this.useragent + "\n";
        string2 = string2 + "post_type: \t" + this.post_type + "\n";
        string2 = string2 + "post_data: \t" + this.post_data + "\n";
        string2 = string2 + "ca_file: \t" + this.ca_file + "\n";
        string2 = string2 + "cert_file: \t" + this.cert_file + "\n";
        string2 = string2 + "additional_headers: \t" + this.additional_headers + "\n";
        for (HttpReqValueModel object : this.value_format) {
            string2 = string2 + JOBS_EIS_TO_STRING[object.getEis()] + "\n";
            string2 = string2 + "flags: " + object.getFlags() + "\n";
            string2 = string2 + "trigger: " + object.getTrigger_eis14() + "\n";
            string2 = string2 + "factor: " + object.getFactor() + "\n";
            string2 = string2 + "offset: " + object.getOffset() + "\n";
            string2 = string2 + "format: " + object.getFormat() + "\n";
        }
        string2 = string2 + "result_eis: \t" + this.result_eis + "\n";
        string2 = string2 + "target_count: \t" + this.target_count + "\n";
        for (HttpReqTargetModel httpReqTargetModel : this.targets) {
            string2 = string2 + httpReqTargetModel.getUrl() + "\n";
        }
        string2 = string2 + "enable: \t" + this.objEnable.getAddressObjectAsString() + "\n";
        string2 = string2 + "input: \t" + this.objInput.getAddressObjectAsString() + "\n";
        for (EIBAddressObject2 eIBAddressObject2 : this.objValue) {
            string2 = string2 + "value: \t" + eIBAddressObject2.getAddressObjectAsString() + "\n";
        }
        string2 = string2 + "error: \t" + this.objErrorTxt.getAddressObjectAsString() + "\n";
        string2 = string2 + "result: \t" + this.objResult.getAddressObjectAsString() + "\n";
        for (EIBAddressObject2 eIBAddressObject2 : this.objOutput) {
            if (eIBAddressObject2 == null) continue;
            string2 = string2 + "output: \t" + eIBAddressObject2.getAddressObjectAsString() + "\n";
        }
        return string2;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int n) {
        this.flags = n;
    }

    public int getTotal_timeout() {
        return this.total_timeout;
    }

    public void setTotal_timeout(int n) {
        this.total_timeout = n;
    }

    public int getMax_size_k() {
        return this.max_size_k;
    }

    public void setMax_size_k(int n) {
        this.max_size_k = n;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String string) {
        this.protocol = string;
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    public void setBaseURL(String string) {
        this.baseURL = string;
    }

    public String getAuth_name() {
        return this.auth_name;
    }

    public void setAuth_name(String string) {
        this.auth_name = string;
    }

    public String getAuth_passwd() {
        return this.auth_passwd;
    }

    public void setAuth_passwd(String string) {
        this.auth_passwd = string;
    }

    public String getProxy_url() {
        return this.proxy_url;
    }

    public void setProxy_url(String string) {
        this.proxy_url = string;
    }

    public String getProxy_name() {
        return this.proxy_name;
    }

    public void setProxy_name(String string) {
        this.proxy_name = string;
    }

    public String getProxy_passwd() {
        return this.proxy_passwd;
    }

    public void setProxy_passwd(String string) {
        this.proxy_passwd = string;
    }

    public String getUseragent() {
        return this.useragent;
    }

    public void setUseragent(String string) {
        this.useragent = string;
    }

    public byte getPost_type() {
        return this.post_type;
    }

    public void setPost_type(byte by) {
        this.post_type = by;
    }

    public String getPost_data() {
        return this.post_data;
    }

    public void setPost_data(String string) {
        this.post_data = string;
    }

    public String getCa_file() {
        return this.ca_file;
    }

    public void setCa_file(String string) {
        this.ca_file = string;
    }

    public String getCert_file() {
        return this.cert_file;
    }

    public void setCert_file(String string) {
        this.cert_file = string;
    }

    public String getAdditional_headers() {
        return this.additional_headers;
    }

    public void setAdditional_headers(String string) {
        this.additional_headers = string;
    }

    public HttpReqValueModel[] getValue_format() {
        return this.value_format;
    }

    public void setValue_format(HttpReqValueModel[] httpReqValueModelArray) {
        this.value_format = httpReqValueModelArray;
    }

    public byte getResult_eis() {
        return this.result_eis;
    }

    public void setResult_eis(byte by) {
        this.result_eis = by;
    }

    public byte getOutput_implementation() {
        return this.output_implementation;
    }

    public void setOutput_implementation(byte by) {
        this.output_implementation = by;
    }

    public byte getTarget_count() {
        return this.target_count;
    }

    public void setTarget_count(byte by) {
        this.target_count = by;
    }

    public HttpReqTargetModel[] getTargets() {
        return this.targets;
    }

    public void setTargets(HttpReqTargetModel[] httpReqTargetModelArray) {
        this.targets = httpReqTargetModelArray;
    }

    public EIBAddressObject2 getObjEnable() {
        return this.objEnable;
    }

    public void setObjEnable(EIBAddressObject2 eIBAddressObject2) {
        this.objEnable = eIBAddressObject2;
    }

    public EIBAddressObject2 getObjInput() {
        return this.objInput;
    }

    public void setObjInput(EIBAddressObject2 eIBAddressObject2) {
        this.objInput = eIBAddressObject2;
    }

    public EIBAddressObject2[] getObjValue() {
        return this.objValue;
    }

    public void setObjValue(EIBAddressObject2[] eIBAddressObject2Array) {
        this.objValue = eIBAddressObject2Array;
    }

    public EIBAddressObject2 getObjErrorTxt() {
        return this.objErrorTxt;
    }

    public void setObjErrorTxt(EIBAddressObject2 eIBAddressObject2) {
        this.objErrorTxt = eIBAddressObject2;
    }

    public EIBAddressObject2 getObjResult() {
        return this.objResult;
    }

    public void setObjResult(EIBAddressObject2 eIBAddressObject2) {
        this.objResult = eIBAddressObject2;
    }

    public EIBAddressObject2[] getObjOutput() {
        return this.objOutput;
    }

    public void setObjOutput(EIBAddressObject2[] eIBAddressObject2Array) {
        this.objOutput = eIBAddressObject2Array;
    }
}

