/*
 * Decompiled with CFR 0.152.
 */
package de.eibport.net.bmx.jobs.data.integrator;

import de.eibport.net.bmx.eibaddress2.EIBAddressObject2;
import de.eibport.net.bmx.jobs.BMXJobData;
import de.eibport.net.bmx.jobs.BMXJobList;
import de.eibport.net.bmx.jobs.data.BMXJobModel;
import de.eibport.net.bmx.jobs.data.integrator.IntegratorInput;
import de.eibport.net.datatype.DataType;
import de.eibport.net.utils.ByteConv;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class BMXIntegrator
extends BMXJobModel {
    public static final int JOBS_INTEGRATOR_INPUTS = 4;
    public static final int JOBS_INTEGRATOR_OBMAX = 7;
    public static final int JOBS_INTEGRATOR_EIS15_FORMAT_LEN = 14;
    public static final byte JOBS_INTEGRATOR_INPUT_FLAGS_INIT_FROM_STABLE = 1;
    public static final byte JOBS_INTEGRATOR_FLAGS_INPUT_VOLATILE = 1;
    public static final byte JOBS_INTEGRATOR_FLAGS_STOP_ON_TIMEOUT = 2;
    public static final byte JOBS_INTEGRATOR_FLAGS_CLEAR_ON_TIMEOUT = 4;
    public static final byte JOBS_INTEGRATOR_FLAGS_ALL = 7;
    private byte flags;
    private IntegratorInput[] input = new IntegratorInput[4];
    private int interval;
    private byte output_eis;
    private String outputEis15Format;
    private EIBAddressObject2 objEnable;
    private EIBAddressObject2 objTrigger;
    private EIBAddressObject2[] objInput = new EIBAddressObject2[4];
    private EIBAddressObject2 objOutput;

    public BMXIntegrator(BMXJobData bMXJobData) {
        this();
        this.setBMXJobData(bMXJobData);
    }

    public BMXIntegrator() {
        for (int i = 0; i < 4; ++i) {
            this.input[i] = new IntegratorInput();
        }
    }

    @Override
    public void setBMXJobData(BMXJobData bMXJobData) {
        int n;
        super.setBMXJobData(bMXJobData);
        byte[] byArray = bMXJobData.getParam();
        int n2 = 0;
        this.flags = byArray[n2++];
        for (n = 0; n < 4; ++n) {
            this.input[n].setFlags(byArray[n2++]);
            this.input[n].setEis(byArray[n2++]);
            this.input[n].setFactor(ByteConv.byte2float(byArray, n2));
            this.input[n].setOffset(ByteConv.byte2float(byArray, n2 += 4));
            this.input[n].setTimeout(ByteConv.byte2short(byArray, n2 += 4));
            this.input[n].setMin((long)ByteConv.byte2long(byArray, n2 += 2) & 0xFFFFFFFFL);
            this.input[n].setMax((long)ByteConv.byte2long(byArray, n2 += 4) & 0xFFFFFFFFL);
            n2 += 4;
        }
        this.interval = ByteConv.byte2short(byArray, n2);
        n2 += 2;
        this.output_eis = byArray[n2++];
        this.outputEis15Format = ByteConv.byte2string(byArray, n2, 14);
        n2 += 14;
        n = 0;
        this.objEnable = bMXJobData.getEIBAddressObject2(n++);
        this.objTrigger = bMXJobData.getEIBAddressObject2(n++);
        for (int i = 0; i < 4; ++i) {
            this.objInput[i] = bMXJobData.getEIBAddressObject2(n++);
        }
        this.objOutput = bMXJobData.getEIBAddressObject2(n++);
    }

    @Override
    public BMXJobData getJobData() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byteArrayOutputStream.write(this.flags);
            for (int i = 0; i < 4; ++i) {
                byteArrayOutputStream.write(this.input[i].getFlags());
                byteArrayOutputStream.write(this.input[i].getEis());
                byteArrayOutputStream.write(ByteConv.float2byte(this.input[i].getFactor()));
                byteArrayOutputStream.write(ByteConv.float2byte(this.input[i].getOffset()));
                byteArrayOutputStream.write(ByteConv.short2byte(this.input[i].getTimeout()));
                byteArrayOutputStream.write(ByteConv.long2byte((int)(this.input[i].getMin() & 0xFFFFFFFFFFFFFFFFL)));
                byteArrayOutputStream.write(ByteConv.long2byte((int)(this.input[i].getMax() & 0xFFFFFFFFFFFFFFFFL)));
            }
            byteArrayOutputStream.write(ByteConv.short2byte(this.interval));
            byteArrayOutputStream.write(this.output_eis);
            byteArrayOutputStream.write(ByteConv.string2byteFixedLen(this.outputEis15Format, 14));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        System.out.println("Parameter size: " + byteArrayOutputStream.size());
        BMXJobData bMXJobData = this.getJobData(BMXJobList.LIBID_INTEGRATOR, byteArrayOutputStream.toByteArray());
        bMXJobData.addEIBAddressObject2(this.objEnable);
        bMXJobData.addEIBAddressObject2(this.objTrigger);
        for (int i = 0; i < 4; ++i) {
            bMXJobData.addEIBAddressObject2(this.objInput[i]);
        }
        bMXJobData.addEIBAddressObject2(this.objOutput);
        return bMXJobData;
    }

    @Override
    public String toString() {
        String string = System.getProperty("line.separator");
        String string2 = super.toString() + string;
        string2 = string2 + "Flags: \t" + this.flags + "\n";
        string2 = string2 + "interval: \t" + this.interval + "\n";
        string2 = string2 + "enable: \t" + this.objEnable.getAddressObjectAsString() + "\n";
        string2 = string2 + "trigger: \t" + this.objTrigger.getAddressObjectAsString() + "\n";
        for (int i = 0; i < 4; ++i) {
            if (this.objInput[i] == null) continue;
            string2 = string2 + "input " + i + ": \t" + this.objInput[i].getAddressObjectAsString() + "\n";
            string2 = string2 + "eis " + i + ": \t" + DataType.getBMXDataType(this.input[i].getEis()).toString() + "\n";
        }
        string2 = string2 + "output: \t" + this.objOutput.getAddressObjectAsString() + "\n";
        string2 = string2 + "output eis: \t" + DataType.getBMXDataType(this.output_eis).toString() + "\n";
        string2 = string2 + "output eis15 format: \t" + this.outputEis15Format + "\n";
        return string2;
    }

    public byte getFlags() {
        return this.flags;
    }

    public void setFlags(byte by) {
        this.flags = by;
    }

    public int getInterval() {
        return this.interval;
    }

    public void setInterval(int n) {
        this.interval = n;
    }

    public IntegratorInput[] getInputs() {
        return this.input;
    }

    public byte getOutputEis() {
        return this.output_eis;
    }

    public void setOutputEis(byte by) {
        this.output_eis = by;
    }

    public String getOutputEis15Format() {
        return this.outputEis15Format;
    }

    public void setOutputEis15Format(String string) {
        this.outputEis15Format = string;
    }

    public EIBAddressObject2 getObjEnable() {
        return this.objEnable;
    }

    public void setObjEnable(EIBAddressObject2 eIBAddressObject2) {
        this.objEnable = eIBAddressObject2;
    }

    public EIBAddressObject2 getObjTrigger() {
        return this.objTrigger;
    }

    public void setObjTrigger(EIBAddressObject2 eIBAddressObject2) {
        this.objTrigger = eIBAddressObject2;
    }

    public EIBAddressObject2[] getObjInput() {
        return this.objInput;
    }

    public void setObjInput(EIBAddressObject2[] eIBAddressObject2Array) {
        this.objInput = eIBAddressObject2Array;
    }

    public EIBAddressObject2 getObjOutput() {
        return this.objOutput;
    }

    public void setObjOutput(EIBAddressObject2 eIBAddressObject2) {
        this.objOutput = eIBAddressObject2;
    }
}

