/*
 * Decompiled with CFR 0.152.
 */
package de.eibport.net.bmx.jobs.data.math;

import de.eibport.net.bmx.eibaddress2.EIBAddressObject2;
import de.eibport.net.bmx.jobs.BMXJobData;
import de.eibport.net.bmx.jobs.BMXJobList;
import de.eibport.net.bmx.jobs.data.BMXJobModel;
import de.eibport.net.datatype.DataType;
import de.eibport.net.utils.ByteConv;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class BMXMathematics
extends BMXJobModel {
    public static final int JOBS_MATH_INPUTS = 12;
    public static final int JOBS_MATH_EXPRESSIONS = 4;
    public static final int JOBS_MATH_OBMAX = 18;
    public static final int JOBS_MATH_MAX_EXPR_LEN = 256;
    public static final int JOBS_MATH_FLAGS_SHOW_RUNTIME_ERROR = 1;
    public static final int JOBS_MATH_FLAGS_DYNAMIC_EXPRESSION = 2;
    public static final int JOBS_MATH_FLAGS_INPUT_VOLATILE = 4;
    public static final int JOBS_MATH_FLAGS_ALL = 7;
    private int flags;
    private String[] expr = new String[4];
    private byte[] input_eis = new byte[12];
    private byte output_eis;
    private EIBAddressObject2 objEnable;
    private EIBAddressObject2 objSelectExpr;
    private EIBAddressObject2 objActualExpr;
    private EIBAddressObject2[] objInput = new EIBAddressObject2[12];
    private EIBAddressObject2 objOutput;
    private EIBAddressObject2 objError;
    private EIBAddressObject2 objErrorTxt;

    public BMXMathematics(BMXJobData bMXJobData) {
        this();
        this.setBMXJobData(bMXJobData);
    }

    public BMXMathematics() {
    }

    @Override
    public void setBMXJobData(BMXJobData bMXJobData) {
        int n;
        super.setBMXJobData(bMXJobData);
        byte[] byArray = bMXJobData.getParam();
        int n2 = 0;
        this.flags = byArray[n2++];
        for (n = 0; n < 4; ++n) {
            this.expr[n] = ByteConv.byte2string(byArray, n2, 256);
            n2 += 256;
        }
        for (n = 0; n < 12; ++n) {
            this.input_eis[n] = byArray[n2++];
        }
        this.output_eis = byArray[n2++];
        n = 0;
        this.objEnable = bMXJobData.getEIBAddressObject2(n++);
        this.objSelectExpr = bMXJobData.getEIBAddressObject2(n++);
        this.objActualExpr = bMXJobData.getEIBAddressObject2(n++);
        for (int i = 0; i < 12; ++i) {
            this.objInput[i] = bMXJobData.getEIBAddressObject2(n++);
        }
        this.objOutput = bMXJobData.getEIBAddressObject2(n++);
        this.objError = bMXJobData.getEIBAddressObject2(n++);
        this.objErrorTxt = bMXJobData.getEIBAddressObject2(n++);
    }

    @Override
    public BMXJobData getJobData() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            int n;
            byteArrayOutputStream.write(this.flags);
            for (n = 0; n < 4; ++n) {
                byteArrayOutputStream.write(ByteConv.string2byteFixedLen(this.expr[n], 256));
            }
            for (n = 0; n < 12; ++n) {
                byteArrayOutputStream.write(this.input_eis[n]);
            }
            byteArrayOutputStream.write(this.output_eis);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        System.out.println("Parameter size: " + byteArrayOutputStream.size());
        BMXJobData bMXJobData = this.getJobData(BMXJobList.LIBID_MATHEMATICS, byteArrayOutputStream.toByteArray());
        bMXJobData.addEIBAddressObject2(this.objEnable);
        bMXJobData.addEIBAddressObject2(this.objSelectExpr);
        bMXJobData.addEIBAddressObject2(this.objActualExpr);
        for (int i = 0; i < 12; ++i) {
            bMXJobData.addEIBAddressObject2(this.objInput[i]);
        }
        bMXJobData.addEIBAddressObject2(this.objOutput);
        bMXJobData.addEIBAddressObject2(this.objError);
        bMXJobData.addEIBAddressObject2(this.objErrorTxt);
        return bMXJobData;
    }

    @Override
    public String toString() {
        int n;
        String string = System.getProperty("line.separator");
        String string2 = super.toString() + string;
        string2 = string2 + "Flags: \t" + this.flags + "\n";
        for (n = 0; n < 4; ++n) {
            string2 = string2 + "expression " + n + ": \t" + this.expr[n] + "\n";
        }
        string2 = string2 + "enable: \t" + this.objEnable.getAddressObjectAsString() + "\n";
        string2 = string2 + "select expression: \t" + this.objSelectExpr.getAddressObjectAsString() + "\n";
        string2 = string2 + "actual expression: \t" + this.objActualExpr.getAddressObjectAsString() + "\n";
        for (n = 0; n < 12; ++n) {
            if (this.objInput[n] == null) continue;
            string2 = string2 + "input " + n + ": \t" + this.objInput[n].getAddressObjectAsString() + "\n";
            string2 = string2 + "eis " + n + ": \t" + DataType.getBMXDataType(this.input_eis[n]).toString();
        }
        string2 = string2 + "output: \t" + this.objOutput.getAddressObjectAsString() + "\n";
        string2 = string2 + "output eis: \t" + DataType.getBMXDataType(this.output_eis).toString();
        string2 = string2 + "error: \t" + this.objError.getAddressObjectAsString() + "\n";
        string2 = string2 + "error txt: \t" + this.objErrorTxt.getAddressObjectAsString() + "\n";
        return string2;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int n) {
        this.flags = n;
    }

    public String[] getExpressions() {
        return this.expr;
    }

    public void setExpressions(String[] stringArray) {
        this.expr = stringArray;
    }

    public byte[] getInputEis() {
        return this.input_eis;
    }

    public void setInputEis() {
        this.input_eis = this.input_eis;
    }

    public byte getOutputEis() {
        return this.output_eis;
    }

    public void setOutputEis(byte by) {
        this.output_eis = by;
    }

    public EIBAddressObject2 getObjEnable() {
        return this.objEnable;
    }

    public void setObjEnable(EIBAddressObject2 eIBAddressObject2) {
        this.objEnable = eIBAddressObject2;
    }

    public EIBAddressObject2 getObjSelectExpr() {
        return this.objSelectExpr;
    }

    public void setObjSelectExpr(EIBAddressObject2 eIBAddressObject2) {
        this.objSelectExpr = eIBAddressObject2;
    }

    public EIBAddressObject2 getObjActualExpr() {
        return this.objActualExpr;
    }

    public void setObjActualExpr(EIBAddressObject2 eIBAddressObject2) {
        this.objActualExpr = eIBAddressObject2;
    }

    public EIBAddressObject2[] getObjInput() {
        return this.objInput;
    }

    public void setObjInput(EIBAddressObject2[] eIBAddressObject2Array) {
        this.objInput = eIBAddressObject2Array;
    }

    public EIBAddressObject2 getObjOutput() {
        return this.objOutput;
    }

    public void setObjOutput(EIBAddressObject2 eIBAddressObject2) {
        this.objOutput = eIBAddressObject2;
    }

    public EIBAddressObject2 getObjError() {
        return this.objError;
    }

    public void setObjError(EIBAddressObject2 eIBAddressObject2) {
        this.objError = eIBAddressObject2;
    }

    public EIBAddressObject2 getObjErrorTxt() {
        return this.objErrorTxt;
    }

    public void setObjErrorTxt(EIBAddressObject2 eIBAddressObject2) {
        this.objErrorTxt = eIBAddressObject2;
    }
}

