/*
 * Decompiled with CFR 0.152.
 */
package de.eibport.net.datatype;

import de.eibport.net.datatype.DT_Unknown;
import de.eibport.net.datatype.dpt.DT_Dpt_29;
import de.eibport.net.datatype.dpt.DT_Dpt_6_010;
import de.eibport.net.datatype.eis.DT_Eis1;
import de.eibport.net.datatype.eis.DT_Eis10s;
import de.eibport.net.datatype.eis.DT_Eis10u;
import de.eibport.net.datatype.eis.DT_Eis11s;
import de.eibport.net.datatype.eis.DT_Eis11u;
import de.eibport.net.datatype.eis.DT_Eis14s;
import de.eibport.net.datatype.eis.DT_Eis14u;
import de.eibport.net.datatype.eis.DT_Eis15;
import de.eibport.net.datatype.eis.DT_Eis3;
import de.eibport.net.datatype.eis.DT_Eis4;
import de.eibport.net.datatype.eis.DT_Eis5;
import de.eibport.net.datatype.eis.DT_Eis6;
import de.eibport.net.datatype.eis.DT_Eis9;
import java.text.DecimalFormat;
import java.util.HashMap;

public abstract class DataType<T>
implements Comparable {
    public static final int DATATYPE_UNKNOWN = 0;
    public static final int DATATYPE_URL = 200;
    public static final int DATATYPE_EIS1 = 10000010;
    public static final int DATATYPE_EIS2 = 10000020;
    public static final int DATATYPE_EIS3 = 10000030;
    public static final int DATATYPE_EIS4 = 10000040;
    public static final int DATATYPE_EIS5 = 10000050;
    public static final int DATATYPE_EIS6 = 10000060;
    public static final int DATATYPE_EIS7 = 10000070;
    public static final int DATATYPE_EIS8 = 10000080;
    public static final int DATATYPE_EIS9 = 10000090;
    public static final int DATATYPE_EIS10s = 10000100;
    public static final int DATATYPE_EIS10u = 10000101;
    public static final int DATATYPE_EIS11s = 10000110;
    public static final int DATATYPE_EIS11u = 10000111;
    public static final int DATATYPE_EIS12 = 10000120;
    public static final int DATATYPE_EIS13 = 10000130;
    public static final int DATATYPE_EIS14s = 10000140;
    public static final int DATATYPE_EIS14u = 10000141;
    public static final int DATATYPE_EIS15 = 10000150;
    public static final int DATATYPE_DPT1 = 1001000;
    public static final int DATATYPE_DPT1_001 = 1001001;
    public static final int DATATYPE_DPT1_002 = 1001002;
    public static final int DATATYPE_DPT1_003 = 1001003;
    public static final int DATATYPE_DPT1_006 = 1001006;
    public static final int DATATYPE_DPT1_008 = 1001008;
    public static final int DATATYPE_DPT1_009 = 1001009;
    public static final int DATATYPE_DPT1_100 = 1001100;
    public static final int DATATYPE_DPT2 = 1002000;
    public static final int DATATYPE_DPT3 = 1003000;
    public static final int DATATYPE_DPT4 = 1004000;
    public static final int DATATYPE_DPT5 = 1005000;
    public static final int DATATYPE_DPT6 = 1006000;
    public static final int DATATYPE_DPT6_010 = 1006010;
    public static final int DATATYPE_DPT7 = 1007000;
    public static final int DATATYPE_DPT8 = 1008000;
    public static final int DATATYPE_DPT9 = 1009000;
    public static final int DATATYPE_DPT10 = 1010000;
    public static final int DATATYPE_DPT11 = 1011000;
    public static final int DATATYPE_DPT12 = 1012000;
    public static final int DATATYPE_DPT13 = 1013000;
    public static final int DATATYPE_DPT14 = 1014000;
    public static final int DATATYPE_DPT15 = 1015000;
    public static final int DATATYPE_DPT16_000 = 1016000;
    public static final int DATATYPE_DPT16_001 = 1016001;
    public static final int DATATYPE_DPT29 = 1029000;
    public static final int DATATYPE_DPT29_010 = 1029010;
    public static final int DATATYPE_DPT29_011 = 1029011;
    public static final int DATATYPE_DPT29012 = 1029012;
    private static HashMap<Integer, DataType<?>> DATATYPE_MAP = new HashMap();
    private int typeIndex;
    private String title;

    public static final DataType<?>[] getDataTypes() {
        return DATATYPE_MAP.values().toArray(new DataType[DATATYPE_MAP.size()]);
    }

    public static final DataType<?> getDataType(int n) {
        return DATATYPE_MAP.get(n);
    }

    public static final DataType<?> getBMXDataType(int n) {
        switch (n) {
            case 1: {
                return DATATYPE_MAP.get(10000010);
            }
            case 3: {
                return DATATYPE_MAP.get(10000020);
            }
            case 7: {
                return DATATYPE_MAP.get(10000030);
            }
            case 8: {
                return DATATYPE_MAP.get(10000040);
            }
            case 5: {
                return DATATYPE_MAP.get(10000050);
            }
            case 4: {
                return DATATYPE_MAP.get(10000060);
            }
            case 2: {
                return DATATYPE_MAP.get(10000080);
            }
            case 9: {
                return DATATYPE_MAP.get(10000090);
            }
            case 6: {
                return DATATYPE_MAP.get(10000100);
            }
            case 10: {
                return DATATYPE_MAP.get(10000110);
            }
            case 11: {
                return DATATYPE_MAP.get(10000141);
            }
            case 12: {
                return DATATYPE_MAP.get(10000150);
            }
        }
        return DATATYPE_MAP.get(0);
    }

    protected DataType(int n, String string) {
        this.typeIndex = n;
        this.title = string;
    }

    public int getTypeIndex() {
        return this.typeIndex;
    }

    public String toString() {
        return this.title;
    }

    public boolean getFactorEnabled() {
        return true;
    }

    public boolean getOffsetEnabled() {
        return true;
    }

    public boolean getMinEnabled() {
        return true;
    }

    public boolean getMaxEnabled() {
        return true;
    }

    public boolean getFormatEnabled() {
        return true;
    }

    public String getPrintfFormat() {
        return "%f";
    }

    public abstract T getMinValue();

    public abstract T getMaxValue();

    public abstract boolean isInRange(T var1);

    public abstract boolean isInRange(T var1, double var2, double var4);

    public abstract T getValueInRange(T var1);

    public abstract T getValueInRange(T var1, double var2, double var4);

    public abstract byte[] getData(T var1);

    public abstract byte[] getData(T var1, double var2, double var4);

    public abstract T getValue(byte[] var1);

    public abstract Double getDoubleValue(T var1);

    public abstract T getDataValue(Double var1);

    public Double getDoubleValue(byte[] byArray, double d, double d2) {
        return this.getDoubleValue(this.getValue(byArray)) * d + d2;
    }

    public String formatDoubleValue(double d, String string) {
        DecimalFormat decimalFormat = new DecimalFormat(string);
        decimalFormat.setMultiplier(1);
        return decimalFormat.format(d);
    }

    public abstract String getValueAsString(T var1);

    public abstract String getValuePrefix();

    public abstract String getValuePostfix();

    public abstract String formatValue(T var1, String var2);

    public abstract T parseValue(String var1) throws Exception;

    public abstract T parseValue(String var1, String var2) throws Exception;

    public abstract int getBmxDataWidth();

    public byte getBmxIndex() {
        return 0;
    }

    public static final DT_Unknown getUnknown() {
        return (DT_Unknown)DATATYPE_MAP.get(0);
    }

    public static final DT_Eis1 getEis1() {
        return (DT_Eis1)DATATYPE_MAP.get(10000010);
    }

    public static final DT_Eis3 getEis3() {
        return (DT_Eis3)DATATYPE_MAP.get(10000030);
    }

    public static final DT_Eis4 getEis4() {
        return (DT_Eis4)DATATYPE_MAP.get(10000040);
    }

    public static final DT_Eis5 getEis5() {
        return (DT_Eis5)DATATYPE_MAP.get(10000050);
    }

    public static final DT_Eis6 getEis6() {
        return (DT_Eis6)DATATYPE_MAP.get(10000060);
    }

    public static final DT_Eis9 getEis9() {
        return (DT_Eis9)DATATYPE_MAP.get(10000090);
    }

    public static final DT_Eis10s getEis10s() {
        return (DT_Eis10s)DATATYPE_MAP.get(10000100);
    }

    public static final DT_Eis10u getEis10u() {
        return (DT_Eis10u)DATATYPE_MAP.get(10000101);
    }

    public static final DT_Eis11s getEis11s() {
        return (DT_Eis11s)DATATYPE_MAP.get(10000110);
    }

    public static final DT_Eis11u getEis11u() {
        return (DT_Eis11u)DATATYPE_MAP.get(10000111);
    }

    public static final DT_Eis14s getEis14s() {
        return (DT_Eis14s)DATATYPE_MAP.get(10000140);
    }

    public static final DT_Eis14u getEis14u() {
        return (DT_Eis14u)DATATYPE_MAP.get(10000141);
    }

    public static final DT_Eis15 getEis15() {
        return (DT_Eis15)DATATYPE_MAP.get(10000150);
    }

    public static final DT_Dpt_6_010 getDpt6_010() {
        return (DT_Dpt_6_010)DATATYPE_MAP.get(1006010);
    }

    public static final DT_Dpt_29 getDpt29() {
        return (DT_Dpt_29)DATATYPE_MAP.get(1029000);
    }

    static {
        DATATYPE_MAP.put(0, new DT_Unknown());
        DATATYPE_MAP.put(10000010, new DT_Eis1());
        DATATYPE_MAP.put(10000030, new DT_Eis3());
        DATATYPE_MAP.put(10000040, new DT_Eis4());
        DATATYPE_MAP.put(10000050, new DT_Eis5());
        DATATYPE_MAP.put(10000060, new DT_Eis6());
        DATATYPE_MAP.put(10000090, new DT_Eis9());
        DATATYPE_MAP.put(10000100, new DT_Eis10s());
        DATATYPE_MAP.put(10000101, new DT_Eis10u());
        DATATYPE_MAP.put(10000110, new DT_Eis11s());
        DATATYPE_MAP.put(10000111, new DT_Eis11u());
        DATATYPE_MAP.put(10000140, new DT_Eis14s());
        DATATYPE_MAP.put(10000141, new DT_Eis14u());
        DATATYPE_MAP.put(10000150, new DT_Eis15());
        DATATYPE_MAP.put(1029000, new DT_Dpt_29());
        DATATYPE_MAP.put(1006010, new DT_Dpt_6_010());
    }
}

