/*
 * Decompiled with CFR 0.152.
 */
package de.eibport.net.datatype.eis;

import de.eibport.net.datatype.DataType;
import java.text.DecimalFormat;
import java.text.ParseException;

public class DT_Eis11s
extends DataType<Integer> {
    public static final int MIN_VALUE = Integer.MIN_VALUE;
    public static final int MAX_VALUE = Integer.MAX_VALUE;

    public DT_Eis11s() {
        super(10000110, "EIS 11s (4 Byte Value)");
    }

    @Override
    public Double getDoubleValue(Integer n) {
        return n.doubleValue();
    }

    @Override
    public Integer getDataValue(Double d) {
        return d.intValue();
    }

    @Override
    public Integer getMaxValue() {
        return Integer.MAX_VALUE;
    }

    @Override
    public Integer getMinValue() {
        return Integer.MIN_VALUE;
    }

    @Override
    public Integer getValueInRange(Integer n) {
        return n < Integer.MIN_VALUE ? Integer.MIN_VALUE : (n > Integer.MAX_VALUE ? Integer.MAX_VALUE : n);
    }

    @Override
    public Integer getValueInRange(Integer n, double d, double d2) {
        int n2 = (int)(-2.147483648E9 < d ? d : -2.147483648E9);
        int n3 = (int)(2.147483647E9 < d2 ? d2 : 2.147483647E9);
        return n < n2 ? n2 : (n > n3 ? n3 : n);
    }

    @Override
    public boolean isInRange(Integer n) {
        return n >= Integer.MIN_VALUE && n <= Integer.MAX_VALUE;
    }

    @Override
    public boolean isInRange(Integer n, double d, double d2) {
        return (double)n.intValue() >= Math.max(-2.147483648E9, d) && (double)n.intValue() <= Math.min(2.147483647E9, d2);
    }

    public int compareTo(Object object) {
        return 0;
    }

    @Override
    public byte[] getData(Integer n) {
        return new byte[]{(byte)((n & 0xFF000000) >> 24), (byte)((n & 0xFF0000) >> 16), (byte)((n & 0xFF00) >> 8), (byte)(n & 0xFF)};
    }

    @Override
    public byte[] getData(Integer n, double d, double d2) {
        return this.getData((int)(((double)n.intValue() - d2) / d));
    }

    @Override
    public Integer getValue(byte[] byArray) {
        int n = byArray[3] & 0xFF | (byArray[2] & 0xFF) << 8 | (byArray[1] & 0xFF) << 16 | (byArray[0] & 0xFF) << 24;
        return n;
    }

    @Override
    public String getValueAsString(Integer n) {
        return n.toString();
    }

    @Override
    public String getValuePostfix() {
        return "";
    }

    @Override
    public String getValuePrefix() {
        return "";
    }

    @Override
    public String getPrintfFormat() {
        return "%d";
    }

    @Override
    public String formatValue(Integer n, String string) {
        DecimalFormat decimalFormat = new DecimalFormat(string);
        decimalFormat.setMultiplier(1);
        return decimalFormat.format(n);
    }

    @Override
    public Integer parseValue(String string) throws Exception {
        return Integer.parseInt(string);
    }

    @Override
    public Integer parseValue(String string, String string2) throws Exception {
        try {
            if (string2 != null) {
                return new DecimalFormat(string2).parse(string).intValue();
            }
        }
        catch (ParseException parseException) {
            return Integer.parseInt(string);
        }
        return null;
    }

    @Override
    public int getBmxDataWidth() {
        return 8;
    }

    @Override
    public byte getBmxIndex() {
        return 10;
    }
}

