/*
 * Decompiled with CFR 0.152.
 */
package de.eibport.net.datatype.eis;

import de.eibport.net.datatype.DataType;
import java.text.DecimalFormat;
import java.text.ParseException;

public class DT_Eis11u
extends DataType<Long> {
    public static final long MIN_VALUE = 0L;
    public static final long MAX_VALUE = 0xFFFFFFFFL;

    public DT_Eis11u() {
        super(10000111, "EIS 11u (4 Byte unsigned Value)");
    }

    @Override
    public Double getDoubleValue(Long l) {
        return l.doubleValue();
    }

    @Override
    public Long getDataValue(Double d) {
        return d.longValue();
    }

    @Override
    public Long getMaxValue() {
        return 0xFFFFFFFFL;
    }

    @Override
    public Long getMinValue() {
        return 0L;
    }

    @Override
    public Long getValueInRange(Long l) {
        return l < 0L ? 0L : (l > 0xFFFFFFFFL ? 0xFFFFFFFFL : l);
    }

    @Override
    public Long getValueInRange(Long l, double d, double d2) {
        long l2 = (long)(0.0 < d ? d : 0.0);
        long l3 = (long)(4.294967295E9 < d2 ? d2 : 4.294967295E9);
        return l < l2 ? l2 : (l > l3 ? l3 : l);
    }

    @Override
    public boolean isInRange(Long l) {
        return l >= 0L && l <= 0xFFFFFFFFL;
    }

    @Override
    public boolean isInRange(Long l, double d, double d2) {
        return (double)l.longValue() >= Math.max(0.0, d) && (double)l.longValue() <= Math.min(4.294967295E9, d2);
    }

    public int compareTo(Object object) {
        return 0;
    }

    @Override
    public byte[] getData(Long l) {
        return new byte[]{(byte)((l & 0xFFFFFFFFFF000000L) >> 24), (byte)((l & 0xFF0000L) >> 16), (byte)((l & 0xFF00L) >> 8), (byte)(l & 0xFFL)};
    }

    @Override
    public byte[] getData(Long l, double d, double d2) {
        return this.getData((long)(((double)l.longValue() - d2) / d));
    }

    @Override
    public Long getValue(byte[] byArray) {
        long l = (long)(byArray[3] & 0xFF) | (long)(byArray[2] & 0xFF) << 8 | (long)(byArray[1] & 0xFF) << 16 | (long)(byArray[0] & 0xFF) << 24;
        return l;
    }

    @Override
    public String getValueAsString(Long l) {
        return l.toString();
    }

    @Override
    public String getValuePostfix() {
        return "";
    }

    @Override
    public String getValuePrefix() {
        return "";
    }

    @Override
    public String getPrintfFormat() {
        return "%d";
    }

    @Override
    public String formatValue(Long l, String string) {
        DecimalFormat decimalFormat = new DecimalFormat(string);
        decimalFormat.setMultiplier(1);
        return decimalFormat.format(l);
    }

    @Override
    public Long parseValue(String string) throws Exception {
        return Long.parseLong(string);
    }

    @Override
    public Long parseValue(String string, String string2) throws Exception {
        try {
            if (string2 != null) {
                return new DecimalFormat(string2).parse(string).longValue();
            }
        }
        catch (ParseException parseException) {
            return Long.parseLong(string);
        }
        return null;
    }

    @Override
    public int getBmxDataWidth() {
        return 8;
    }

    @Override
    public byte getBmxIndex() {
        return 10;
    }
}

