/*
 * Decompiled with CFR 0.152.
 */
package de.eibport.net.datatype.eis;

import de.eibport.net.datatype.DataType;

public class DT_Eis15
extends DataType<String> {
    public static final String DEFAULT_CHARSET = "ISO-8859-1";
    public static final int MAX_DATA_LENGTH = 15;

    public DT_Eis15() {
        super(10000150, "EIS 15 (14 Byte Text)");
    }

    @Override
    public Double getDoubleValue(String string) {
        try {
            return Double.parseDouble(string);
        }
        catch (Exception exception) {
            return Double.NaN;
        }
    }

    @Override
    public String getDataValue(Double d) {
        return d.toString();
    }

    @Override
    public boolean getMinEnabled() {
        return false;
    }

    @Override
    public boolean getMaxEnabled() {
        return false;
    }

    @Override
    public boolean getFormatEnabled() {
        return false;
    }

    @Override
    public String getMaxValue() {
        return "";
    }

    @Override
    public String getMinValue() {
        return "";
    }

    @Override
    public String getValueInRange(String string) {
        return string.substring(0, Math.min(string.length(), 16));
    }

    @Override
    public String getValueInRange(String string, double d, double d2) {
        int n = string.length();
        while ((double)n < d) {
            string = string + " ";
            ++n;
        }
        return string.substring(0, (int)Math.min((double)string.length(), Math.min(d2, 16.0)));
    }

    @Override
    public boolean isInRange(String string) {
        return string.length() <= 16;
    }

    @Override
    public boolean isInRange(String string, double d, double d2) {
        return (double)string.length() >= d && (double)string.length() <= d2;
    }

    public int compareTo(Object object) {
        return 0;
    }

    @Override
    public byte[] getData(String string) {
        byte[] byArray = new byte[Math.min(string.length(), 15)];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)string.charAt(i);
        }
        return byArray;
    }

    @Override
    public byte[] getData(String string, double d, double d2) {
        return this.getData(string);
    }

    @Override
    public String getValue(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (byte by : byArray) {
            if ((by & 0xFF) == 0) continue;
            stringBuffer.append((char)(by & 0xFF));
        }
        return stringBuffer.toString();
    }

    @Override
    public String getValueAsString(String string) {
        return string;
    }

    @Override
    public String getValuePostfix() {
        return "";
    }

    @Override
    public String getValuePrefix() {
        return "";
    }

    @Override
    public String getPrintfFormat() {
        return "%s";
    }

    @Override
    public String formatValue(String string, String string2) {
        return string;
    }

    @Override
    public String parseValue(String string) throws Exception {
        return string;
    }

    @Override
    public String parseValue(String string, String string2) throws Exception {
        return string;
    }

    @Override
    public int getBmxDataWidth() {
        return 15;
    }

    @Override
    public byte getBmxIndex() {
        return 12;
    }
}

