/*
 * Decompiled with CFR 0.152.
 */
package de.eibport.net.datatype.eis;

import de.eibport.net.datatype.DataType;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class DT_Eis4
extends DataType<Calendar> {
    public DT_Eis4() {
        super(10000040, "EIS 4 (3 Byte Date)");
    }

    @Override
    public Double getDoubleValue(Calendar calendar) {
        return new Double(calendar.getTimeInMillis());
    }

    @Override
    public Calendar getDataValue(Double d) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTimeInMillis(d.longValue());
        return gregorianCalendar;
    }

    @Override
    public boolean getMinEnabled() {
        return false;
    }

    @Override
    public boolean getMaxEnabled() {
        return false;
    }

    @Override
    public boolean getOffsetEnabled() {
        return false;
    }

    @Override
    public boolean getFactorEnabled() {
        return false;
    }

    @Override
    public Calendar getMaxValue() {
        return null;
    }

    @Override
    public Calendar getMinValue() {
        return null;
    }

    @Override
    public Calendar getValueInRange(Calendar calendar) {
        return calendar;
    }

    @Override
    public Calendar getValueInRange(Calendar calendar, double d, double d2) {
        return calendar;
    }

    @Override
    public boolean isInRange(Calendar calendar) {
        return true;
    }

    @Override
    public boolean isInRange(Calendar calendar, double d, double d2) {
        return true;
    }

    public int compareTo(Object object) {
        return 0;
    }

    @Override
    public byte[] getData(Calendar calendar) {
        byte[] byArray = new byte[]{(byte)calendar.get(5), (byte)calendar.get(2), (byte)(calendar.get(1) % 100)};
        return byArray;
    }

    @Override
    public byte[] getData(Calendar calendar, double d, double d2) {
        return this.getData(calendar);
    }

    @Override
    public Calendar getValue(byte[] byArray) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        int n = gregorianCalendar.get(1) / 100 * 100;
        gregorianCalendar.set(0, 0, 0, 0, 0, 0);
        gregorianCalendar.set(5, byArray[0] & 0xFF);
        gregorianCalendar.set(2, (byArray[1] & 0xFF) - 1);
        gregorianCalendar.set(1, n + (byArray[2] & 0xFF));
        return gregorianCalendar;
    }

    @Override
    public String getValueAsString(Calendar calendar) {
        return DateFormat.getDateInstance(3).format(calendar.getTime());
    }

    @Override
    public String getValuePostfix() {
        return "";
    }

    @Override
    public String getValuePrefix() {
        return "";
    }

    @Override
    public String getPrintfFormat() {
        return "%02d.%02d.%04d";
    }

    @Override
    public String formatValue(Calendar calendar, String string) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
        return simpleDateFormat.format(calendar.getTime());
    }

    @Override
    public Calendar parseValue(String string) throws Exception {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat();
        Date date = simpleDateFormat.parse(string);
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        return gregorianCalendar;
    }

    @Override
    public Calendar parseValue(String string, String string2) throws Exception {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2);
        Date date = simpleDateFormat.parse(string);
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        return gregorianCalendar;
    }

    @Override
    public int getBmxDataWidth() {
        return 7;
    }

    @Override
    public byte getBmxIndex() {
        return 8;
    }
}

