/*
 * Decompiled with CFR 0.152.
 */
package de.eibport.net.datatype.eis;

import de.eibport.net.datatype.DataType;
import java.text.DecimalFormat;

public class DT_Eis5
extends DataType<Double> {
    public static final double MIN_VALUE = -671088.64;
    public static final double MAX_VALUE = 670760.96;

    public DT_Eis5() {
        super(10000050, "EIS 5 (2 Byte FP)");
    }

    @Override
    public Double getDoubleValue(Double d) {
        return d;
    }

    @Override
    public Double getDataValue(Double d) {
        return d;
    }

    @Override
    public Double getMaxValue() {
        return 670760.96;
    }

    @Override
    public Double getMinValue() {
        return -671088.64;
    }

    @Override
    public Double getValueInRange(Double d) {
        return d < -671088.64 ? -671088.64 : (d > 670760.96 ? 670760.96 : d);
    }

    @Override
    public Double getValueInRange(Double d, double d2, double d3) {
        double d4;
        double d5 = -671088.64 < d2 ? d2 : -671088.64;
        double d6 = d4 = 670760.96 < d3 ? d3 : 670760.96;
        return d < d5 ? d5 : (d > d4 ? d4 : d);
    }

    @Override
    public boolean isInRange(Double d) {
        return d >= -671088.64 && d <= 670760.96;
    }

    @Override
    public boolean isInRange(Double d, double d2, double d3) {
        return d >= Math.max(-671088.64, d2) && d <= Math.min(670760.96, d3);
    }

    public int compareTo(Object object) {
        return 0;
    }

    @Override
    public byte[] getData(Double d) {
        byte[] byArray = new byte[2];
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        if (d < 0.0) {
            n = 1;
            d = d * -1.0;
        }
        if (n == 1) {
            while (d > 20.48 && n3 < 16) {
                d = d / 2.0;
                ++n3;
            }
        } else {
            while (d > 20.47 && n3 < 16) {
                d = d / 2.0;
                ++n3;
            }
        }
        if (n3 > 15) {
            if (n == 1) {
                byArray[0] = -8;
                byArray[1] = 0;
            } else {
                byArray[0] = 127;
                byArray[1] = -1;
            }
        } else {
            n2 = n == 1 ? (~((int)(d * 100.0)) & 0x7FF) + 1 : (int)(d * 100.0);
            byArray[0] = (byte)(n << 7);
            byArray[0] = (byte)(byArray[0] | (byte)((n3 & 0xF) << 3));
            byArray[0] = (byte)(byArray[0] | (byte)((n2 & 0x700) >> 8));
            byArray[1] = (byte)(n2 & 0xFF);
        }
        return byArray;
    }

    @Override
    public byte[] getData(Double d, double d2, double d3) {
        return this.getData((d - d3) / d2);
    }

    @Override
    public Double getValue(byte[] byArray) {
        double d = 0.0;
        int n = (byArray[0] & 0x80) >> 7;
        int n2 = (byArray[0] & 0x78) >> 3;
        int n3 = (byArray[0] & 7) << 8 | byArray[1] & 0xFF;
        if (n == 1) {
            n3 = (~n3 & 0x7FF) + 1;
        }
        d = 0.01 * (double)n3 * Math.pow(2.0, n2);
        if (n == 1) {
            d *= -1.0;
        }
        return d;
    }

    @Override
    public String getValueAsString(Double d) {
        return d.toString();
    }

    @Override
    public String getValuePostfix() {
        return "";
    }

    @Override
    public String getValuePrefix() {
        return "";
    }

    @Override
    public String getPrintfFormat() {
        return "%f";
    }

    @Override
    public String formatValue(Double d, String string) {
        DecimalFormat decimalFormat = new DecimalFormat(string);
        decimalFormat.setMultiplier(1);
        return decimalFormat.format(d);
    }

    @Override
    public Double parseValue(String string) throws Exception {
        return Double.parseDouble(string);
    }

    @Override
    public Double parseValue(String string, String string2) throws Exception {
        return new DecimalFormat(string2).parse(string).doubleValue();
    }

    @Override
    public int getBmxDataWidth() {
        return 6;
    }

    @Override
    public byte getBmxIndex() {
        return 5;
    }
}

