/*
 * Decompiled with CFR 0.152.
 */
package de.eibport.net.mcast;

import de.eibport.net.mcast.DatagramListener;
import de.eibport.net.mcast.packets.v1.Beacon;
import de.eibport.net.mcast.packets.v1.DatagramHeader;
import de.eibport.net.mcast.packets.v2.EpDatagram;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Random;

public class MulticastThread
extends Thread {
    public static final String DEFAULT_IP = "239.192.168.27";
    public static final int DEFAULT_PORT = 1735;
    private InetAddress inetAddress;
    private int port;
    private ArrayList<MulticastSocket> sockets = new ArrayList();
    private Thread[] listenerThread;
    private ArrayList<DatagramListener> listener = new ArrayList();
    private short ownerType = 0;
    private Thread beaconThread = null;
    private Runnable beaconSender = new Runnable(){

        @Override
        public void run() {
            while (!MulticastThread.this.isInterrupted()) {
                MulticastThread.this.sendBytes(EpDatagram.getBeaconDatagram(MulticastThread.this.ownerType).getBytes());
                try {
                    Thread.sleep(30000L);
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
            }
        }
    };

    public MulticastThread(String string, int n, short s) {
        this.ownerType = s;
        try {
            this.inetAddress = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            unknownHostException.printStackTrace();
        }
        this.port = n;
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            block4: while (enumeration.hasMoreElements()) {
                NetworkInterface networkInterface = enumeration.nextElement();
                if (networkInterface.isLoopback() || !networkInterface.supportsMulticast()) continue;
                Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
                while (enumeration2.hasMoreElements()) {
                    if (!(enumeration2.nextElement() instanceof Inet4Address)) continue;
                    MulticastSocket multicastSocket = new MulticastSocket(n);
                    multicastSocket.setNetworkInterface(networkInterface);
                    this.sockets.add(multicastSocket);
                    continue block4;
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void sendBytes(byte[] byArray) {
        try {
            DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, this.inetAddress, this.port);
            for (MulticastSocket multicastSocket : this.sockets) {
                multicastSocket.send(datagramPacket);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void sendBytes(byte[] byArray, String string, int n) {
        try {
            DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, InetAddress.getByName(string), n);
            for (MulticastSocket multicastSocket : this.sockets) {
                multicastSocket.send(datagramPacket);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Override
    public void run() {
        this.listenerThread = new Thread[this.sockets.size()];
        for (int i = 0; i < this.sockets.size(); ++i) {
            try {
                this.listenerThread[i] = new Thread((Runnable)new MulticastListener(this.sockets.get(i)), "MulticastSocket_" + this.sockets.get(i).getNetworkInterface().getDisplayName());
                this.listenerThread[i].start();
                continue;
            }
            catch (SocketException socketException) {
                socketException.printStackTrace();
            }
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.startBeacons();
        while (!this.isInterrupted()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        for (int i = 0; i < this.listenerThread.length; ++i) {
            this.listenerThread[i].interrupt();
        }
    }

    public void startBeacons() {
        if (this.beaconThread != null && this.beaconThread.isAlive()) {
            this.stopBeacons();
        }
        this.beaconThread = new Thread(this.beaconSender);
        this.beaconThread.start();
    }

    public void stopBeacons() {
        if (this.beaconThread != null) {
            this.beaconThread.interrupt();
            this.beaconThread = null;
        }
    }

    private void gotDatagramV1(DatagramPacket datagramPacket) {
        DatagramHeader datagramHeader = new DatagramHeader(datagramPacket);
        switch (datagramHeader.getCommand()) {
            case 2: {
                Beacon beacon = new Beacon(datagramHeader, datagramPacket.getData(), 12);
                this.gotBeaconV1(beacon);
                break;
            }
        }
    }

    private void gotBeaconV1(Beacon beacon) {
        for (DatagramListener datagramListener : this.listener) {
            datagramListener.receivedBeacon(beacon);
        }
    }

    private void gotDatagramV2(DatagramPacket datagramPacket) {
        byte[] byArray = datagramPacket.getData();
        EpDatagram epDatagram = new EpDatagram(byArray, 0);
        switch (epDatagram.getHeader().getPropertyShort("hCommand")) {
            case 2: {
                switch (epDatagram.getHeader().getPropertyShort("hType")) {
                    case 2: {
                        this.gotBeaconV2(epDatagram);
                        break;
                    }
                    case 4: {
                        this.gotBeaconV2(epDatagram);
                        break;
                    }
                    case 64: {
                        break;
                    }
                    case 256: {
                        this.gotBeaconV2(epDatagram);
                    }
                }
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                break;
            }
            case 1: {
                new Thread(){

                    @Override
                    public void run() {
                        try {
                            Thread.sleep(new Random().nextInt(3000));
                        }
                        catch (InterruptedException interruptedException) {
                            this.interrupt();
                        }
                        if (!this.isInterrupted()) {
                            MulticastThread.this.sendBytes(EpDatagram.getBeaconDatagram(MulticastThread.this.ownerType).getBytes());
                        }
                    }
                }.start();
                break;
            }
            default: {
                short s = epDatagram.getHeader().getPropertyShort("hCommand");
                if (s == -11941) break;
                System.err.println("got undefined datagram (" + s + ")");
            }
        }
    }

    private void gotBeaconV2(EpDatagram epDatagram) {
        for (DatagramListener datagramListener : this.listener) {
            datagramListener.receivedBeacon(epDatagram);
        }
    }

    public void addListener(DatagramListener datagramListener) {
        this.listener.add(datagramListener);
    }

    public void removeListener(DatagramListener datagramListener) {
        this.listener.remove(datagramListener);
    }

    class MulticastListener
    implements Runnable {
        MulticastSocket socket;

        public MulticastListener(MulticastSocket multicastSocket) {
            this.socket = multicastSocket;
        }

        @Override
        public void run() {
            try {
                this.socket.joinGroup(MulticastThread.this.inetAddress);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            DatagramPacket datagramPacket = new DatagramPacket(new byte[1024], 1024);
            while (!MulticastThread.this.isInterrupted()) {
                try {
                    this.socket.receive(datagramPacket);
                }
                catch (IOException iOException) {
                    System.err.println(iOException.getMessage());
                }
                switch (datagramPacket.getData()[1]) {
                    case 1: {
                        MulticastThread.this.gotDatagramV1(datagramPacket);
                        break;
                    }
                    case 2: {
                        MulticastThread.this.gotDatagramV2(datagramPacket);
                    }
                }
            }
            try {
                MulticastThread.this.stopBeacons();
                this.socket.leaveGroup(MulticastThread.this.inetAddress);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }
}

