/*
 * Decompiled with CFR 0.152.
 */
package de.eibport.net.sftp;

import de.eibport.net.bmx.BMXConnection;
import de.eibport.net.bmx.BMXListenerAdapter;
import de.eibport.net.bmx.BMXPackets;
import de.eibport.net.sftp.BMXKeyListener;
import de.eibport.net.sftp.KeyStorageInterface;
import java.security.Key;
import java.util.Random;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class KeyStorageBMX
implements KeyStorageInterface {
    private byte[] publicKey = null;
    private byte[] privateKey = null;
    private boolean privateAvailable = false;
    private boolean privateReceived = false;
    private boolean publicAvailable = false;
    private boolean publicReceived = false;
    private BMXKeyListener bmxKeyListener;
    private byte[] iv_idx = new byte[8];
    private byte[] key_idx = new byte[8];
    private BMXConnection con;

    public KeyStorageBMX(String string, int n, String string2, BMXKeyListener bMXKeyListener, boolean bl, boolean bl2) {
        this.bmxKeyListener = bMXKeyListener;
        this.requestCrypto(string, n, string2, bl, bl2);
    }

    public KeyStorageBMX(String string, int n, String string2, BMXKeyListener bMXKeyListener) {
        this.bmxKeyListener = bMXKeyListener;
        this.requestCrypto(string, n, string2, true, true);
    }

    private void requestCrypto(String string, int n, String string2, boolean bl, boolean bl2) {
        this.con = new BMXConnection(string, n, "epConfigTool");
        boolean bl3 = this.con.openSocket();
        if (!bl3) {
            this.bmxKeyListener.keyRequestingFailed("Unable to establish a connection to " + string + " on port " + n);
        } else {
            this.con.addBMXListener(new BMXListenerAdapter(){

                @Override
                public void getCrypto(byte[] byArray) {
                    KeyStorageBMX.this.receiveCrypto(byArray);
                }
            });
            new Random().nextBytes(this.iv_idx);
            if (bl) {
                this.con.sendPacket(BMXPackets.constructBMXCrypto(this.iv_idx, 1));
            } else {
                this.privateReceived = true;
            }
            if (bl2) {
                this.con.sendPacket(BMXPackets.constructBMXCrypto(this.iv_idx, 2));
            } else {
                this.publicReceived = true;
            }
        }
    }

    private void finishRequest() {
        this.con.closeSocket();
    }

    private void receiveCrypto(byte[] byArray) {
        int n = (byArray[7] & 0xFF) << 24 | (byArray[6] & 0xFF) << 16 | (byArray[5] & 0xFF) << 8 | byArray[4] & 0xFF;
        int n2 = (byArray[11] & 0xFF) << 24 | (byArray[10] & 0xFF) << 16 | (byArray[9] & 0xFF) << 8 | byArray[8] & 0xFF;
        int n3 = (byArray[15] & 0xFF) << 24 | (byArray[14] & 0xFF) << 16 | (byArray[13] & 0xFF) << 8 | byArray[12] & 0xFF;
        if (n3 <= 0) {
            if (n2 == 1) {
                this.privateReceived = true;
                this.bmxKeyListener.privateKeyReceived(false, "No key in eibPort");
            } else {
                this.publicReceived = true;
                this.bmxKeyListener.publicKeyReceived(false, "No key in eibPort");
            }
        } else {
            byte[] byArray2 = new byte[256];
            System.arraycopy(byArray, 16, byArray2, 0, 256);
            this.key_idx[0] = byArray2[234];
            this.key_idx[1] = byArray2[73];
            this.key_idx[2] = byArray2[184];
            this.key_idx[3] = byArray2[32];
            this.key_idx[4] = byArray2[86];
            this.key_idx[5] = byArray2[36];
            this.key_idx[6] = byArray2[252];
            this.key_idx[7] = byArray2[177];
            byte[] byArray3 = new byte[n3];
            System.arraycopy(byArray, byArray.length - n3, byArray3, 0, n3);
            try {
                Cipher cipher = Cipher.getInstance("Blowfish/CFB8/NoPadding");
                SecretKeySpec secretKeySpec = new SecretKeySpec(this.key_idx, "Blowfish");
                IvParameterSpec ivParameterSpec = new IvParameterSpec(this.iv_idx);
                cipher.init(2, (Key)secretKeySpec, ivParameterSpec);
                if (n2 == 1) {
                    this.privateKey = cipher.doFinal(byArray3);
                    this.privateReceived = true;
                    this.privateAvailable = true;
                    this.bmxKeyListener.privateKeyReceived(true, null);
                } else {
                    this.publicKey = cipher.doFinal(byArray3);
                    this.publicReceived = true;
                    this.publicAvailable = true;
                    this.bmxKeyListener.publicKeyReceived(true, null);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (this.privateReceived && this.publicReceived) {
            this.finishRequest();
            this.bmxKeyListener.finishedReceivingKeys(this.privateAvailable, this.publicAvailable, this);
        }
    }

    @Override
    public byte[] getPrivateKey() {
        return this.privateKey;
    }

    @Override
    public byte[] getPublicKey() {
        return this.publicKey;
    }

    @Override
    public boolean privateAvailable() {
        return this.privateAvailable;
    }

    @Override
    public boolean publicAvailable() {
        return this.publicAvailable;
    }
}

