/*
 * Decompiled with CFR 0.152.
 */
package de.eibport.net.sftp;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import com.jcraft.jsch.SftpProgressMonitor;
import com.jcraft.jsch.UserInfo;
import de.eibport.net.sftp.FileInterface;
import de.eibport.net.sftp.KeyStorageInterface;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.NoRouteToHostException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JOptionPane;

public class SftpTransfer
implements FileInterface {
    private String host = "";
    private String user = "root";
    private int port = 22;
    private String passphrase;
    private Session session;
    private ChannelSftp sftpChannel;
    private KeyStorageInterface keyStorage;
    private int timeoutSeconds = 10;
    private static final boolean DEBUG = false;
    private Thread timeoutThread = null;

    public SftpTransfer(String string, int n, String string2, String string3, KeyStorageInterface keyStorageInterface) {
        this.host = string;
        this.port = n;
        this.user = string2;
        this.passphrase = string3;
        this.keyStorage = keyStorageInterface;
    }

    @Override
    public boolean sessionIsAlive() {
        if (this.session == null || this.sftpChannel == null) {
            return false;
        }
        return this.session.isConnected() && this.sftpChannel.isConnected();
    }

    private synchronized boolean setActive(boolean bl) {
        boolean bl2;
        if (bl) {
            bl2 = this.startSession();
        } else {
            this.endSession();
            bl2 = true;
        }
        return bl2;
    }

    private boolean startSession() {
        try {
            JSch jSch = new JSch();
            jSch.addIdentity("SftpTransfer", (byte[])this.keyStorage.getPrivateKey().clone(), (byte[])this.keyStorage.getPublicKey().clone(), "passphrase".getBytes());
            this.session = jSch.getSession(this.user, this.host, this.port);
            System.out.println("Using ssh component version '" + this.session.getClientVersion() + "'");
            MyUserInfo myUserInfo = new MyUserInfo(this.passphrase);
            this.session.setUserInfo(myUserInfo);
            this.session.connect();
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            hashtable.put("cipher.s2c", "none,aes128-cbc,3des-cbc,blowfish-cbc");
            hashtable.put("cipher.c2s", "none,aes128-cbc,3des-cbc,blowfish-cbc");
            this.session.setConfig(hashtable);
            this.session.rekey();
            this.sftpChannel = (ChannelSftp)this.session.openChannel("sftp");
            this.sftpChannel.connect();
            return true;
        }
        catch (JSchException jSchException) {
            System.err.println(jSchException.getLocalizedMessage());
            return false;
        }
        catch (Exception exception) {
            System.err.println(exception.getLocalizedMessage());
            return false;
        }
    }

    @Override
    public void closeConnection() {
        this.endSession();
    }

    private void endSession() {
        Session session = this.session;
        this.session = null;
        ChannelSftp channelSftp = this.sftpChannel;
        this.sftpChannel = null;
        this.stopTimeout();
        if (session != null) {
            session.disconnect();
            session = null;
        }
        if (channelSftp != null) {
            channelSftp.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream readFromFile(String string, boolean bl) throws NoRouteToHostException {
        try {
            if (this.preTransfer()) {
                InputStream inputStream = this.sftpChannel.get(string);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                byte[] byArray = new byte[1024];
                try {
                    int n;
                    while ((n = inputStream.read(byArray, 0, 1024)) != -1) {
                        byteArrayOutputStream.write(byArray, 0, n);
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                finally {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                this.postTransfer();
                return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            }
            throw new NoRouteToHostException("Lost connection to eibPort");
        }
        catch (SftpException sftpException) {
            if (bl) {
                int n = string.lastIndexOf(47);
                System.out.println("File not found: " + (n >= 0 ? string.substring(n + 1) : string) + " path: " + string);
            }
            return null;
        }
    }

    @Override
    public void writeToFile(String string, byte[] byArray) throws NoRouteToHostException {
        try {
            if (!this.preTransfer()) {
                throw new NoRouteToHostException("Lost connection to eibPort");
            }
            String string2 = string.substring(0, string.lastIndexOf("/"));
            this.mkdirs(string2, false);
            this.sftpChannel.put(new ByteArrayInputStream(byArray), string);
            this.postTransfer();
        }
        catch (SftpException sftpException) {
            sftpException.printStackTrace();
            throw new NoRouteToHostException("Lost connection to eibPort");
        }
    }

    @Override
    public boolean copy(String string, OutputStream outputStream) throws NoRouteToHostException {
        boolean bl = false;
        try {
            if (!this.preTransfer()) {
                throw new NoRouteToHostException("Lost connection to eibPort");
            }
            this.sftpChannel.get(string, outputStream);
            this.postTransfer();
            bl = true;
        }
        catch (SftpException sftpException) {
            System.out.println("File not found: " + string + " (Using default values)");
        }
        return bl;
    }

    @Override
    public void mkdirs(String string) throws NoRouteToHostException {
        this.mkdirs(string, true);
    }

    public void mkdirs(String string, boolean bl) throws NoRouteToHostException {
        if (!bl || this.preTransfer()) {
            String[] stringArray = string.split("/");
            try {
                this.sftpChannel.cd("/");
            }
            catch (SftpException sftpException) {
                System.out.println("can't cd  to /");
            }
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    this.sftpChannel.cd(stringArray[i]);
                    continue;
                }
                catch (SftpException sftpException) {
                    try {
                        this.sftpChannel.mkdir(stringArray[i]);
                        this.sftpChannel.cd(stringArray[i]);
                        continue;
                    }
                    catch (SftpException sftpException2) {
                        // empty catch block
                    }
                }
            }
            if (bl) {
                this.postTransfer();
            }
        } else {
            throw new NoRouteToHostException("Lost connection to eibPort");
        }
    }

    @Override
    public boolean copy(InputStream inputStream, String string) throws NoRouteToHostException {
        return this.copy(inputStream, string, null);
    }

    public boolean copy(InputStream inputStream, String string, SftpProgressMonitor sftpProgressMonitor) throws NoRouteToHostException {
        boolean bl = false;
        if (this.preTransfer()) {
            if (string.contains("/")) {
                String string2 = string.substring(0, string.lastIndexOf("/"));
                this.mkdirs(string2, false);
            }
            try {
                this.sftpChannel.put(inputStream, string, sftpProgressMonitor);
                bl = true;
            }
            catch (SftpException sftpException) {
                System.out.println("cant write file: " + string + " (" + sftpException.getMessage() + ")");
            }
        } else {
            throw new NoRouteToHostException("Lost connection to eibPort");
        }
        bl = false;
        this.postTransfer();
        return bl;
    }

    @Override
    public boolean fileExists(String string) throws NoRouteToHostException {
        if (this.preTransfer()) {
            try {
                boolean bl = this.sftpChannel.ls(string).size() > 0;
                this.postTransfer();
                return bl;
            }
            catch (SftpException sftpException) {
                this.postTransfer();
                return false;
            }
        }
        throw new NoRouteToHostException("Lost connection to eibPort");
    }

    private void removeFilesInDir(String string) throws NoRouteToHostException {
        for (String string2 : this.getFileList(string)) {
            this.remove(string2);
        }
        for (String string2 : this.getDirectoryList(string)) {
            this.removeFilesInDir(string2);
            this.remove(string2);
        }
    }

    @Override
    public boolean remove(String string) throws NoRouteToHostException {
        if (this.preTransfer()) {
            try {
                if (this.sftpChannel.lstat(string).isDir()) {
                    this.removeFilesInDir(string);
                    this.sftpChannel.rmdir(string);
                } else {
                    this.sftpChannel.rm(string);
                }
                this.postTransfer();
                return true;
            }
            catch (SftpException sftpException) {
                this.postTransfer();
                return false;
            }
        }
        throw new NoRouteToHostException("Lost connection to eibPort");
    }

    @Override
    public boolean rename(String string, String string2, boolean bl) throws NoRouteToHostException {
        if (!this.fileExists(string)) {
            System.out.println("skipping non-existant file" + string);
            return false;
        }
        if (this.fileExists(string2)) {
            if (bl) {
                System.err.println("removing " + string2 + " to overwrite it");
                this.remove(string2);
            } else {
                return false;
            }
        }
        if (this.preTransfer()) {
            String string3 = string2.substring(0, string2.lastIndexOf("/"));
            this.mkdirs(string3, false);
            try {
                this.sftpChannel.rename(string, string2);
                this.postTransfer();
                return true;
            }
            catch (SftpException sftpException) {
                sftpException.printStackTrace();
                this.postTransfer();
                return false;
            }
        }
        throw new NoRouteToHostException("Lost connection to eibPort");
    }

    @Override
    public String[] getEntryList(String string) throws NoRouteToHostException {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.preTransfer()) {
            try {
                if (this.sftpChannel.lstat(string).isDir()) {
                    if (!string.endsWith("/")) {
                        string = string + "/";
                    }
                    Vector vector = this.sftpChannel.ls(string);
                    for (ChannelSftp.LsEntry lsEntry : vector) {
                        if (lsEntry.getFilename().endsWith(".") || lsEntry.getFilename().endsWith("..")) continue;
                        arrayList.add(string + lsEntry.getFilename());
                    }
                }
            }
            catch (SftpException sftpException) {
                sftpException.printStackTrace();
            }
        } else {
            throw new NoRouteToHostException("Lost connection to eibPort");
        }
        this.postTransfer();
        return arrayList.toArray(new String[arrayList.size()]);
    }

    @Override
    public String[] getFileList(String string) throws NoRouteToHostException {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.preTransfer()) {
            if (!string.endsWith("/")) {
                string = string + "/";
            }
            try {
                Vector vector = this.sftpChannel.ls(string);
                for (ChannelSftp.LsEntry lsEntry : vector) {
                    if (lsEntry.getAttrs().isDir()) continue;
                    arrayList.add(string + lsEntry.getFilename());
                }
            }
            catch (SftpException sftpException) {
                // empty catch block
            }
        } else {
            throw new NoRouteToHostException("Lost connection to eibPort");
        }
        this.postTransfer();
        return arrayList.toArray(new String[arrayList.size()]);
    }

    @Override
    public String[] getDirectoryList(String string) throws NoRouteToHostException {
        String[] stringArray = null;
        if (this.preTransfer()) {
            try {
                if (!string.endsWith("/")) {
                    string = string + "/";
                }
                Vector vector = this.sftpChannel.ls(string);
                ArrayList<String> arrayList = new ArrayList<String>();
                for (ChannelSftp.LsEntry lsEntry : vector) {
                    if (!lsEntry.getAttrs().isDir() || lsEntry.getFilename().endsWith(".") || lsEntry.getFilename().endsWith("..")) continue;
                    arrayList.add(string + lsEntry.getFilename());
                }
                stringArray = new String[arrayList.size()];
                arrayList.toArray(stringArray);
            }
            catch (SftpException sftpException) {
                sftpException.printStackTrace();
            }
        } else {
            throw new NoRouteToHostException("Lost connection to eibPort");
        }
        this.postTransfer();
        return stringArray;
    }

    @Override
    public boolean setGrpAndOwn(String string, int n, int n2, boolean bl) {
        try {
            if (n != -1) {
                this.sftpChannel.chgrp(n, string);
            }
            if (n2 != -1) {
                this.sftpChannel.chown(n2, string);
            }
            if (bl && this.sftpChannel.lstat(string).isDir()) {
                for (String string2 : this.getDirectoryList(string)) {
                    this.setGrpAndOwn(string2, n, n2, bl);
                }
            }
        }
        catch (SftpException sftpException) {
            return false;
        }
        catch (NoRouteToHostException noRouteToHostException) {
            return false;
        }
        return true;
    }

    @Override
    public boolean setPermissions(String string, int n) {
        try {
            this.sftpChannel.chmod(n, string);
        }
        catch (SftpException sftpException) {
            return false;
        }
        return true;
    }

    @Override
    public int getGrp(String string) {
        try {
            return this.sftpChannel.lstat(string).getGId();
        }
        catch (SftpException sftpException) {
            return -1;
        }
    }

    @Override
    public int getPermissions(String string) {
        try {
            return this.sftpChannel.lstat(string).getPermissions();
        }
        catch (SftpException sftpException) {
            return -1;
        }
    }

    @Override
    public int getOwn(String string) {
        try {
            return this.sftpChannel.lstat(string).getUId();
        }
        catch (SftpException sftpException) {
            return -1;
        }
    }

    private boolean preTransfer() {
        this.stopTimeout();
        if (!this.sessionIsAlive()) {
            return this.setActive(true);
        }
        return true;
    }

    private void postTransfer() {
        this.startTimeout();
    }

    private void stopTimeout() {
        if (this.timeoutThread != null && this.timeoutThread.isAlive()) {
            this.timeoutThread.interrupt();
        }
        this.timeoutThread = null;
    }

    private void startTimeout() {
        this.stopTimeout();
        this.timeoutThread = new TimeoutThread();
        this.timeoutThread.start();
    }

    @Override
    public boolean testConnection() {
        return this.preTransfer();
    }

    class TimeoutThread
    extends Thread {
        TimeoutThread() {
        }

        @Override
        public void run() {
            try {
                Thread.sleep(SftpTransfer.this.timeoutSeconds * 1000);
                if (!this.isInterrupted()) {
                    SftpTransfer.this.setActive(false);
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }

    public static class MyUserInfo
    implements UserInfo {
        private String passphrase;

        public MyUserInfo(String string) {
            this.passphrase = string;
        }

        @Override
        public String getPassword() {
            return null;
        }

        @Override
        public boolean promptYesNo(String string) {
            return true;
        }

        @Override
        public String getPassphrase() {
            return this.passphrase;
        }

        @Override
        public boolean promptPassphrase(String string) {
            return true;
        }

        @Override
        public boolean promptPassword(String string) {
            return true;
        }

        @Override
        public void showMessage(String string) {
            JOptionPane.showMessageDialog(null, string);
        }
    }
}

