/*
 * Decompiled with CFR 0.152.
 */
package de.eibport.net.utils;

public class ByteConv {
    public static final int BYTE_SIZE = 1;
    public static final int SHORT_SIZE = 2;
    public static final int LONG_SIZE = 4;
    public static final int FLOAT_SIZE = 4;
    public static final int DOUBLE_SIZE = 8;

    public static float byte2float(byte[] byArray, int n) {
        int n2 = byArray[0 + n] & 0xFF | (byArray[1 + n] & 0xFF) << 8 | (byArray[2 + n] & 0xFF) << 16 | (byArray[3 + n] & 0xFF) << 24;
        return Float.intBitsToFloat(n2);
    }

    public static byte[] float2byte(float f) {
        byte[] byArray = new byte[4];
        int n = Float.floatToIntBits(f);
        byArray[0] = (byte)(n & 0xFF);
        byArray[1] = (byte)((n & 0xFF00) >> 8);
        byArray[2] = (byte)((n & 0xFF0000) >> 16);
        byArray[3] = (byte)((n & 0xFF000000) >> 24);
        return byArray;
    }

    public static byte[] float2byte(byte[] byArray, int n, float f) {
        int n2 = Float.floatToIntBits(f);
        byArray[n] = (byte)(n2 & 0xFF);
        byArray[n + 1] = (byte)((n2 & 0xFF00) >> 8);
        byArray[n + 2] = (byte)((n2 & 0xFF0000) >> 16);
        byArray[n + 3] = (byte)((n2 & 0xFF000000) >> 24);
        return byArray;
    }

    public static int byte2short(byte[] byArray, int n) {
        return (byArray[n + 1] & 0xFF) << 8 | byArray[n] & 0xFF;
    }

    public static byte[] short2byte(int n) {
        byte[] byArray = new byte[]{(byte)(n & 0xFF), (byte)((n & 0xFF00) >> 8)};
        return byArray;
    }

    public static byte[] short2byte(byte[] byArray, int n, int n2) {
        byArray[n] = (byte)(n2 & 0xFF);
        byArray[n + 1] = (byte)((n2 & 0xFF00) >> 8);
        return byArray;
    }

    public static void short2byteIP(int n, byte[] byArray, int n2) {
        byArray[n2 + 0] = (byte)(n & 0xFF);
        byArray[n2 + 1] = (byte)((n & 0xFF00) >> 8);
    }

    public static int byte2long(byte[] byArray, int n) {
        return (byArray[n + 3] & 0xFF) << 24 | (byArray[n + 2] & 0xFF) << 16 | (byArray[n + 1] & 0xFF) << 8 | byArray[n] & 0xFF;
    }

    public static byte[] long2byte(int n) {
        byte[] byArray = new byte[]{(byte)(n & 0xFF), (byte)((n & 0xFF00) >> 8), (byte)((n & 0xFF0000) >> 16), (byte)((n & 0xFF000000) >> 24)};
        return byArray;
    }

    public static void long2byteIP(int n, byte[] byArray, int n2) {
        byArray[n2 + 0] = (byte)(n & 0xFF);
        byArray[n2 + 1] = (byte)((n & 0xFF00) >> 8);
        byArray[n2 + 2] = (byte)((n & 0xFF0000) >> 16);
        byArray[n2 + 3] = (byte)((n & 0xFF000000) >> 24);
    }

    public static double byte2double(byte[] byArray, int n) {
        long l = (long)(byArray[0 + n] & 0xFF) | (long)(byArray[1 + n] & 0xFF) << 8 | (long)(byArray[2 + n] & 0xFF) << 16 | (long)(byArray[3 + n] & 0xFF) << 24 | (long)(byArray[4 + n] & 0xFF) << 32 | (long)(byArray[5 + n] & 0xFF) << 40 | (long)(byArray[6 + n] & 0xFF) << 48 | (long)(byArray[7 + n] & 0xFF) << 56;
        return Double.longBitsToDouble(l);
    }

    public static String byte2string(byte[] byArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer(n2);
        int n3 = n;
        for (int i = 0; i < n2 && byArray[n3] != 0; ++i) {
            stringBuffer.insert(i, (char)byArray[n3]);
            ++n3;
        }
        return stringBuffer.toString();
    }

    public static byte[] string2byteFixedLen(String string, int n) {
        if (string == null) {
            return new byte[n];
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.setLength(n);
        byte[] byArray = stringBuffer.toString().getBytes();
        byArray[n - 1] = 0;
        return byArray;
    }

    private static byte[] string2byte(String string, int n) {
        if (string == null || string.length() <= 0 || n <= 0) {
            return new byte[n];
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.setLength(n);
        byte[] byArray = stringBuffer.toString().getBytes();
        byArray[n - 1] = 0;
        return byArray;
    }

    public static void string2byte(String string, int n, byte[] byArray, int n2) {
        byte[] byArray2 = ByteConv.string2byte(string, n);
        System.arraycopy(byArray2, 0, byArray, n2, n);
    }

    public static void string2byteIP(String string, int n, byte[] byArray, int n2) {
        byte[] byArray2 = ByteConv.string2byte(string, n);
        System.arraycopy(byArray2, 0, byArray, n2, Math.min(byArray2.length, n));
    }

    public static boolean isUTF8(byte[] byArray) {
        boolean bl = false;
        int n = -1;
        for (int i = 0; i < byArray.length; ++i) {
            if (n >= 0) {
                if ((byArray[i] & 0xC0) == 128) {
                    if (--n != 0) continue;
                    bl = true;
                    n = -1;
                    continue;
                }
                return false;
            }
            String string = Integer.toBinaryString(byArray[i] & 0xFF);
            if (string.length() != 8) continue;
            int n2 = string.indexOf(48);
            if (n2 >= 2 && (n = n2 - 1) > 3) {
                return false;
            }
            if (n2 != 1) continue;
            return false;
        }
        return bl;
    }
}

