/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.adapters;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jdom.JDOMException;
import org.jdom.adapters.AbstractDOMAdapter;
import org.jdom.input.BuilderErrorHandler;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public class XercesDOMAdapter
extends AbstractDOMAdapter {
    private static final String CVS_ID = "@(#) $RCSfile: XercesDOMAdapter.java,v $ $Revision: 1.19 $ $Date: 2007/11/10 05:28:59 $ $Name: jdom_1_1 $";

    @Override
    public Document getDocument(InputStream inputStream, boolean bl) throws IOException, JDOMException {
        try {
            Method method;
            Class<?> clazz = Class.forName("org.apache.xerces.parsers.DOMParser");
            Object obj = clazz.newInstance();
            Method method2 = clazz.getMethod("setFeature", String.class, Boolean.TYPE);
            method2.invoke(obj, "http://xml.org/sax/features/validation", new Boolean(bl));
            method2.invoke(obj, "http://xml.org/sax/features/namespaces", new Boolean(true));
            if (bl) {
                method = clazz.getMethod("setErrorHandler", ErrorHandler.class);
                method.invoke(obj, new BuilderErrorHandler());
            }
            method = clazz.getMethod("parse", InputSource.class);
            method.invoke(obj, new InputSource(inputStream));
            Method method3 = clazz.getMethod("getDocument", null);
            Document document = (Document)method3.invoke(obj, null);
            return document;
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof SAXParseException) {
                SAXParseException sAXParseException = (SAXParseException)throwable;
                throw new JDOMException("Error on line " + sAXParseException.getLineNumber() + " of XML document: " + sAXParseException.getMessage(), invocationTargetException);
            }
            if (throwable instanceof IOException) {
                IOException iOException = (IOException)throwable;
                throw iOException;
            }
            throw new JDOMException(throwable.getMessage(), invocationTargetException);
        }
        catch (Exception exception) {
            throw new JDOMException(exception.getClass().getName() + ": " + exception.getMessage(), exception);
        }
    }

    @Override
    public Document createDocument() throws JDOMException {
        try {
            return (Document)Class.forName("org.apache.xerces.dom.DocumentImpl").newInstance();
        }
        catch (Exception exception) {
            throw new JDOMException(exception.getClass().getName() + ": " + exception.getMessage() + " when creating document", exception);
        }
    }
}

