/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.output;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.CDATA;
import org.jdom.Comment;
import org.jdom.DocType;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.EntityRef;
import org.jdom.Namespace;
import org.jdom.ProcessingInstruction;
import org.jdom.Text;
import org.jdom.Verifier;
import org.jdom.output.EscapeStrategy;
import org.jdom.output.Format;

public class XMLOutputter
implements Cloneable {
    private static final String CVS_ID = "@(#) $RCSfile: XMLOutputter.java,v $ $Revision: 1.116 $ $Date: 2007/11/10 05:29:01 $ $Name: jdom_1_1 $";
    private Format userFormat;
    protected static final Format preserveFormat = Format.getRawFormat();
    protected Format currentFormat;
    private boolean escapeOutput;

    public XMLOutputter() {
        this.currentFormat = this.userFormat = Format.getRawFormat();
        this.escapeOutput = true;
    }

    public XMLOutputter(Format format) {
        this.currentFormat = this.userFormat = Format.getRawFormat();
        this.escapeOutput = true;
        this.currentFormat = this.userFormat = (Format)format.clone();
    }

    public XMLOutputter(XMLOutputter xMLOutputter) {
        this.currentFormat = this.userFormat = Format.getRawFormat();
        this.escapeOutput = true;
        this.currentFormat = this.userFormat = (Format)xMLOutputter.userFormat.clone();
    }

    public void setFormat(Format format) {
        this.currentFormat = this.userFormat = (Format)format.clone();
    }

    public Format getFormat() {
        return (Format)this.userFormat.clone();
    }

    public void output(Document document, OutputStream outputStream) throws IOException {
        Writer writer = this.makeWriter(outputStream);
        this.output(document, writer);
    }

    public void output(DocType docType, OutputStream outputStream) throws IOException {
        Writer writer = this.makeWriter(outputStream);
        this.output(docType, writer);
    }

    public void output(Element element, OutputStream outputStream) throws IOException {
        Writer writer = this.makeWriter(outputStream);
        this.output(element, writer);
    }

    public void outputElementContent(Element element, OutputStream outputStream) throws IOException {
        Writer writer = this.makeWriter(outputStream);
        this.outputElementContent(element, writer);
    }

    public void output(List list, OutputStream outputStream) throws IOException {
        Writer writer = this.makeWriter(outputStream);
        this.output(list, writer);
    }

    public void output(CDATA cDATA, OutputStream outputStream) throws IOException {
        Writer writer = this.makeWriter(outputStream);
        this.output(cDATA, writer);
    }

    public void output(Text text, OutputStream outputStream) throws IOException {
        Writer writer = this.makeWriter(outputStream);
        this.output(text, writer);
    }

    public void output(Comment comment, OutputStream outputStream) throws IOException {
        Writer writer = this.makeWriter(outputStream);
        this.output(comment, writer);
    }

    public void output(ProcessingInstruction processingInstruction, OutputStream outputStream) throws IOException {
        Writer writer = this.makeWriter(outputStream);
        this.output(processingInstruction, writer);
    }

    public void output(EntityRef entityRef, OutputStream outputStream) throws IOException {
        Writer writer = this.makeWriter(outputStream);
        this.output(entityRef, writer);
    }

    private Writer makeWriter(OutputStream outputStream) throws UnsupportedEncodingException {
        return XMLOutputter.makeWriter(outputStream, this.userFormat.encoding);
    }

    private static Writer makeWriter(OutputStream outputStream, String string) throws UnsupportedEncodingException {
        if ("UTF-8".equals(string)) {
            string = "UTF8";
        }
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new BufferedOutputStream(outputStream), string));
        return bufferedWriter;
    }

    public void output(Document document, Writer writer) throws IOException {
        this.printDeclaration(writer, document, this.userFormat.encoding);
        List list = document.getContent();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Object e = list.get(i);
            if (e instanceof Element) {
                this.printElement(writer, document.getRootElement(), 0, this.createNamespaceStack());
            } else if (e instanceof Comment) {
                this.printComment(writer, (Comment)e);
            } else if (e instanceof ProcessingInstruction) {
                this.printProcessingInstruction(writer, (ProcessingInstruction)e);
            } else if (e instanceof DocType) {
                this.printDocType(writer, document.getDocType());
                writer.write(this.currentFormat.lineSeparator);
            }
            this.newline(writer);
            this.indent(writer, 0);
        }
        writer.write(this.currentFormat.lineSeparator);
        writer.flush();
    }

    public void output(DocType docType, Writer writer) throws IOException {
        this.printDocType(writer, docType);
        writer.flush();
    }

    public void output(Element element, Writer writer) throws IOException {
        this.printElement(writer, element, 0, this.createNamespaceStack());
        writer.flush();
    }

    public void outputElementContent(Element element, Writer writer) throws IOException {
        List list = element.getContent();
        this.printContentRange(writer, list, 0, list.size(), 0, this.createNamespaceStack());
        writer.flush();
    }

    public void output(List list, Writer writer) throws IOException {
        this.printContentRange(writer, list, 0, list.size(), 0, this.createNamespaceStack());
        writer.flush();
    }

    public void output(CDATA cDATA, Writer writer) throws IOException {
        this.printCDATA(writer, cDATA);
        writer.flush();
    }

    public void output(Text text, Writer writer) throws IOException {
        this.printText(writer, text);
        writer.flush();
    }

    public void output(Comment comment, Writer writer) throws IOException {
        this.printComment(writer, comment);
        writer.flush();
    }

    public void output(ProcessingInstruction processingInstruction, Writer writer) throws IOException {
        boolean bl = this.currentFormat.ignoreTrAXEscapingPIs;
        this.currentFormat.setIgnoreTrAXEscapingPIs(true);
        this.printProcessingInstruction(writer, processingInstruction);
        this.currentFormat.setIgnoreTrAXEscapingPIs(bl);
        writer.flush();
    }

    public void output(EntityRef entityRef, Writer writer) throws IOException {
        this.printEntityRef(writer, entityRef);
        writer.flush();
    }

    public String outputString(Document document) {
        StringWriter stringWriter = new StringWriter();
        try {
            this.output(document, (Writer)stringWriter);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stringWriter.toString();
    }

    public String outputString(DocType docType) {
        StringWriter stringWriter = new StringWriter();
        try {
            this.output(docType, (Writer)stringWriter);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stringWriter.toString();
    }

    public String outputString(Element element) {
        StringWriter stringWriter = new StringWriter();
        try {
            this.output(element, (Writer)stringWriter);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stringWriter.toString();
    }

    public String outputString(List list) {
        StringWriter stringWriter = new StringWriter();
        try {
            this.output(list, (Writer)stringWriter);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stringWriter.toString();
    }

    public String outputString(CDATA cDATA) {
        StringWriter stringWriter = new StringWriter();
        try {
            this.output(cDATA, (Writer)stringWriter);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stringWriter.toString();
    }

    public String outputString(Text text) {
        StringWriter stringWriter = new StringWriter();
        try {
            this.output(text, (Writer)stringWriter);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stringWriter.toString();
    }

    public String outputString(Comment comment) {
        StringWriter stringWriter = new StringWriter();
        try {
            this.output(comment, (Writer)stringWriter);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stringWriter.toString();
    }

    public String outputString(ProcessingInstruction processingInstruction) {
        StringWriter stringWriter = new StringWriter();
        try {
            this.output(processingInstruction, (Writer)stringWriter);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stringWriter.toString();
    }

    public String outputString(EntityRef entityRef) {
        StringWriter stringWriter = new StringWriter();
        try {
            this.output(entityRef, (Writer)stringWriter);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stringWriter.toString();
    }

    protected void printDeclaration(Writer writer, Document document, String string) throws IOException {
        if (!this.userFormat.omitDeclaration) {
            writer.write("<?xml version=\"1.0\"");
            if (!this.userFormat.omitEncoding) {
                writer.write(" encoding=\"" + string + "\"");
            }
            writer.write("?>");
            writer.write(this.currentFormat.lineSeparator);
        }
    }

    protected void printDocType(Writer writer, DocType docType) throws IOException {
        String string = docType.getPublicID();
        String string2 = docType.getSystemID();
        String string3 = docType.getInternalSubset();
        boolean bl = false;
        writer.write("<!DOCTYPE ");
        writer.write(docType.getElementName());
        if (string != null) {
            writer.write(" PUBLIC \"");
            writer.write(string);
            writer.write("\"");
            bl = true;
        }
        if (string2 != null) {
            if (!bl) {
                writer.write(" SYSTEM");
            }
            writer.write(" \"");
            writer.write(string2);
            writer.write("\"");
        }
        if (string3 != null && !string3.equals("")) {
            writer.write(" [");
            writer.write(this.currentFormat.lineSeparator);
            writer.write(docType.getInternalSubset());
            writer.write("]");
        }
        writer.write(">");
    }

    protected void printComment(Writer writer, Comment comment) throws IOException {
        writer.write("<!--");
        writer.write(comment.getText());
        writer.write("-->");
    }

    protected void printProcessingInstruction(Writer writer, ProcessingInstruction processingInstruction) throws IOException {
        String string = processingInstruction.getTarget();
        boolean bl = false;
        if (!this.currentFormat.ignoreTrAXEscapingPIs) {
            if (string.equals("javax.xml.transform.disable-output-escaping")) {
                this.escapeOutput = false;
                bl = true;
            } else if (string.equals("javax.xml.transform.enable-output-escaping")) {
                this.escapeOutput = true;
                bl = true;
            }
        }
        if (!bl) {
            String string2 = processingInstruction.getData();
            if (!"".equals(string2)) {
                writer.write("<?");
                writer.write(string);
                writer.write(" ");
                writer.write(string2);
                writer.write("?>");
            } else {
                writer.write("<?");
                writer.write(string);
                writer.write("?>");
            }
        }
    }

    protected void printEntityRef(Writer writer, EntityRef entityRef) throws IOException {
        writer.write("&");
        writer.write(entityRef.getName());
        writer.write(";");
    }

    protected void printCDATA(Writer writer, CDATA cDATA) throws IOException {
        String string = this.currentFormat.mode == Format.TextMode.NORMALIZE ? cDATA.getTextNormalize() : (this.currentFormat.mode == Format.TextMode.TRIM ? cDATA.getText().trim() : cDATA.getText());
        writer.write("<![CDATA[");
        writer.write(string);
        writer.write("]]>");
    }

    protected void printText(Writer writer, Text text) throws IOException {
        String string = this.currentFormat.mode == Format.TextMode.NORMALIZE ? text.getTextNormalize() : (this.currentFormat.mode == Format.TextMode.TRIM ? text.getText().trim() : text.getText());
        writer.write(this.escapeElementEntities(string));
    }

    private void printString(Writer writer, String string) throws IOException {
        if (this.currentFormat.mode == Format.TextMode.NORMALIZE) {
            string = Text.normalizeString(string);
        } else if (this.currentFormat.mode == Format.TextMode.TRIM) {
            string = string.trim();
        }
        writer.write(this.escapeElementEntities(string));
    }

    protected void printElement(Writer writer, Element element, int n, NamespaceStack namespaceStack) throws IOException {
        int n2;
        int n3;
        List list = element.getAttributes();
        List list2 = element.getContent();
        String string = null;
        if (list != null) {
            string = element.getAttributeValue("space", Namespace.XML_NAMESPACE);
        }
        Format format = this.currentFormat;
        if ("default".equals(string)) {
            this.currentFormat = this.userFormat;
        } else if ("preserve".equals(string)) {
            this.currentFormat = preserveFormat;
        }
        writer.write("<");
        this.printQualifiedName(writer, element);
        int n4 = namespaceStack.size();
        this.printElementNamespace(writer, element, namespaceStack);
        this.printAdditionalNamespaces(writer, element, namespaceStack);
        if (list != null) {
            this.printAttributes(writer, list, element, namespaceStack);
        }
        if ((n3 = this.skipLeadingWhite(list2, 0)) >= (n2 = list2.size())) {
            if (this.currentFormat.expandEmptyElements) {
                writer.write("></");
                this.printQualifiedName(writer, element);
                writer.write(">");
            } else {
                writer.write(" />");
            }
        } else {
            writer.write(">");
            if (XMLOutputter.nextNonText(list2, n3) < n2) {
                this.newline(writer);
                this.printContentRange(writer, list2, n3, n2, n + 1, namespaceStack);
                this.newline(writer);
                this.indent(writer, n);
            } else {
                this.printTextRange(writer, list2, n3, n2);
            }
            writer.write("</");
            this.printQualifiedName(writer, element);
            writer.write(">");
        }
        while (namespaceStack.size() > n4) {
            namespaceStack.pop();
        }
        this.currentFormat = format;
    }

    private void printContentRange(Writer writer, List list, int n, int n2, int n3, NamespaceStack namespaceStack) throws IOException {
        int n4 = n;
        while (n4 < n2) {
            boolean bl = n4 == n;
            Object e = list.get(n4);
            if (e instanceof Text || e instanceof EntityRef) {
                int n5 = this.skipLeadingWhite(list, n4);
                if (n5 >= (n4 = XMLOutputter.nextNonText(list, n5))) continue;
                if (!bl) {
                    this.newline(writer);
                }
                this.indent(writer, n3);
                this.printTextRange(writer, list, n5, n4);
                continue;
            }
            if (!bl) {
                this.newline(writer);
            }
            this.indent(writer, n3);
            if (e instanceof Comment) {
                this.printComment(writer, (Comment)e);
            } else if (e instanceof Element) {
                this.printElement(writer, (Element)e, n3, namespaceStack);
            } else if (e instanceof ProcessingInstruction) {
                this.printProcessingInstruction(writer, (ProcessingInstruction)e);
            }
            ++n4;
        }
    }

    private void printTextRange(Writer writer, List list, int n, int n2) throws IOException {
        int n3;
        String string = null;
        if ((n = this.skipLeadingWhite(list, n)) < (n3 = list.size())) {
            n2 = this.skipTrailingWhite(list, n2);
            for (int i = n; i < n2; ++i) {
                String string2;
                Object e = list.get(i);
                if (e instanceof Text) {
                    string2 = ((Text)e).getText();
                } else if (e instanceof EntityRef) {
                    string2 = "&" + ((EntityRef)e).getValue() + ";";
                } else {
                    throw new IllegalStateException("Should see only CDATA, Text, or EntityRef");
                }
                if (string2 == null || "".equals(string2)) continue;
                if (string != null && (this.currentFormat.mode == Format.TextMode.NORMALIZE || this.currentFormat.mode == Format.TextMode.TRIM) && (this.endsWithWhite(string) || this.startsWithWhite(string2))) {
                    writer.write(" ");
                }
                if (e instanceof CDATA) {
                    this.printCDATA(writer, (CDATA)e);
                } else if (e instanceof EntityRef) {
                    this.printEntityRef(writer, (EntityRef)e);
                } else {
                    this.printString(writer, string2);
                }
                string = string2;
            }
        }
    }

    private void printNamespace(Writer writer, Namespace namespace, NamespaceStack namespaceStack) throws IOException {
        String string = namespace.getPrefix();
        String string2 = namespace.getURI();
        if (string2.equals(namespaceStack.getURI(string))) {
            return;
        }
        writer.write(" xmlns");
        if (!string.equals("")) {
            writer.write(":");
            writer.write(string);
        }
        writer.write("=\"");
        writer.write(this.escapeAttributeEntities(string2));
        writer.write("\"");
        namespaceStack.push(namespace);
    }

    protected void printAttributes(Writer writer, List list, Element element, NamespaceStack namespaceStack) throws IOException {
        for (int i = 0; i < list.size(); ++i) {
            Attribute attribute = (Attribute)list.get(i);
            Namespace namespace = attribute.getNamespace();
            if (namespace != Namespace.NO_NAMESPACE && namespace != Namespace.XML_NAMESPACE) {
                this.printNamespace(writer, namespace, namespaceStack);
            }
            writer.write(" ");
            this.printQualifiedName(writer, attribute);
            writer.write("=");
            writer.write("\"");
            writer.write(this.escapeAttributeEntities(attribute.getValue()));
            writer.write("\"");
        }
    }

    private void printElementNamespace(Writer writer, Element element, NamespaceStack namespaceStack) throws IOException {
        Namespace namespace = element.getNamespace();
        if (namespace == Namespace.XML_NAMESPACE) {
            return;
        }
        if (namespace != Namespace.NO_NAMESPACE || namespaceStack.getURI("") != null) {
            this.printNamespace(writer, namespace, namespaceStack);
        }
    }

    private void printAdditionalNamespaces(Writer writer, Element element, NamespaceStack namespaceStack) throws IOException {
        List list = element.getAdditionalNamespaces();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                Namespace namespace = (Namespace)list.get(i);
                this.printNamespace(writer, namespace, namespaceStack);
            }
        }
    }

    private void newline(Writer writer) throws IOException {
        if (this.currentFormat.indent != null) {
            writer.write(this.currentFormat.lineSeparator);
        }
    }

    private void indent(Writer writer, int n) throws IOException {
        if (this.currentFormat.indent == null || this.currentFormat.indent.equals("")) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            writer.write(this.currentFormat.indent);
        }
    }

    private int skipLeadingWhite(List list, int n) {
        int n2;
        if (n < 0) {
            n = 0;
        }
        int n3 = list.size();
        if (this.currentFormat.mode == Format.TextMode.TRIM_FULL_WHITE || this.currentFormat.mode == Format.TextMode.NORMALIZE || this.currentFormat.mode == Format.TextMode.TRIM) {
            for (n2 = n; n2 < n3; ++n2) {
                if (this.isAllWhitespace(list.get(n2))) continue;
                return n2;
            }
        }
        return n2;
    }

    private int skipTrailingWhite(List list, int n) {
        int n2;
        int n3 = list.size();
        if (n > n3) {
            n = n3;
        }
        if (this.currentFormat.mode == Format.TextMode.TRIM_FULL_WHITE || this.currentFormat.mode == Format.TextMode.NORMALIZE || this.currentFormat.mode == Format.TextMode.TRIM) {
            for (n2 = n; n2 >= 0 && this.isAllWhitespace(list.get(n2 - 1)); --n2) {
            }
        }
        return n2;
    }

    private static int nextNonText(List list, int n) {
        if (n < 0) {
            n = 0;
        }
        int n2 = list.size();
        for (int i = n; i < n2; ++i) {
            Object e = list.get(i);
            if (e instanceof Text || e instanceof EntityRef) continue;
            return i;
        }
        return n2;
    }

    private boolean isAllWhitespace(Object object) {
        String string = null;
        if (object instanceof String) {
            string = (String)object;
        } else if (object instanceof Text) {
            string = ((Text)object).getText();
        } else {
            if (object instanceof EntityRef) {
                return false;
            }
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            if (Verifier.isXMLWhitespace(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private boolean startsWithWhite(String string) {
        return string != null && string.length() > 0 && Verifier.isXMLWhitespace(string.charAt(0));
    }

    private boolean endsWithWhite(String string) {
        return string != null && string.length() > 0 && Verifier.isXMLWhitespace(string.charAt(string.length() - 1));
    }

    public String escapeAttributeEntities(String string) {
        EscapeStrategy escapeStrategy = this.currentFormat.escapeStrategy;
        StringBuffer stringBuffer = null;
        for (int i = 0; i < string.length(); ++i) {
            String string2;
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    string2 = "&lt;";
                    break;
                }
                case '>': {
                    string2 = "&gt;";
                    break;
                }
                case '\"': {
                    string2 = "&quot;";
                    break;
                }
                case '&': {
                    string2 = "&amp;";
                    break;
                }
                case '\r': {
                    string2 = "&#xD;";
                    break;
                }
                case '\t': {
                    string2 = "&#x9;";
                    break;
                }
                case '\n': {
                    string2 = "&#xA;";
                    break;
                }
                default: {
                    string2 = escapeStrategy.shouldEscape(c) ? "&#x" + Integer.toHexString(c) + ";" : null;
                }
            }
            if (stringBuffer == null) {
                if (string2 == null) continue;
                stringBuffer = new StringBuffer(string.length() + 20);
                stringBuffer.append(string.substring(0, i));
                stringBuffer.append(string2);
                continue;
            }
            if (string2 == null) {
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append(string2);
        }
        return stringBuffer == null ? string : stringBuffer.toString();
    }

    public String escapeElementEntities(String string) {
        if (!this.escapeOutput) {
            return string;
        }
        EscapeStrategy escapeStrategy = this.currentFormat.escapeStrategy;
        StringBuffer stringBuffer = null;
        for (int i = 0; i < string.length(); ++i) {
            String string2;
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    string2 = "&lt;";
                    break;
                }
                case '>': {
                    string2 = "&gt;";
                    break;
                }
                case '&': {
                    string2 = "&amp;";
                    break;
                }
                case '\r': {
                    string2 = "&#xD;";
                    break;
                }
                case '\n': {
                    string2 = this.currentFormat.lineSeparator;
                    break;
                }
                default: {
                    string2 = escapeStrategy.shouldEscape(c) ? "&#x" + Integer.toHexString(c) + ";" : null;
                }
            }
            if (stringBuffer == null) {
                if (string2 == null) continue;
                stringBuffer = new StringBuffer(string.length() + 20);
                stringBuffer.append(string.substring(0, i));
                stringBuffer.append(string2);
                continue;
            }
            if (string2 == null) {
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append(string2);
        }
        return stringBuffer == null ? string : stringBuffer.toString();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException.toString());
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        block5: for (int i = 0; i < this.userFormat.lineSeparator.length(); ++i) {
            char c = this.userFormat.lineSeparator.charAt(i);
            switch (c) {
                case '\r': {
                    stringBuffer.append("\\r");
                    continue block5;
                }
                case '\n': {
                    stringBuffer.append("\\n");
                    continue block5;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    continue block5;
                }
                default: {
                    stringBuffer.append("[" + c + "]");
                }
            }
        }
        return "XMLOutputter[omitDeclaration = " + this.userFormat.omitDeclaration + ", " + "encoding = " + this.userFormat.encoding + ", " + "omitEncoding = " + this.userFormat.omitEncoding + ", " + "indent = '" + this.userFormat.indent + "'" + ", " + "expandEmptyElements = " + this.userFormat.expandEmptyElements + ", " + "lineSeparator = '" + stringBuffer.toString() + "', " + "textMode = " + this.userFormat.mode + "]";
    }

    private NamespaceStack createNamespaceStack() {
        return new NamespaceStack();
    }

    private void printQualifiedName(Writer writer, Element element) throws IOException {
        if (element.getNamespace().getPrefix().length() == 0) {
            writer.write(element.getName());
        } else {
            writer.write(element.getNamespace().getPrefix());
            writer.write(58);
            writer.write(element.getName());
        }
    }

    private void printQualifiedName(Writer writer, Attribute attribute) throws IOException {
        String string = attribute.getNamespace().getPrefix();
        if (string != null && !string.equals("")) {
            writer.write(string);
            writer.write(58);
            writer.write(attribute.getName());
        } else {
            writer.write(attribute.getName());
        }
    }

    protected class NamespaceStack
    extends org.jdom.output.NamespaceStack {
        protected NamespaceStack() {
        }
    }
}

