/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonPrimitive;
import com.google.gson.internal.$Gson$Preconditions;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public final class JsonObject
extends JsonElement {
    private final Map<String, JsonElement> members = new LinkedHashMap<String, JsonElement>();

    public void add(String string, JsonElement jsonElement) {
        if (jsonElement == null) {
            jsonElement = JsonNull.INSTANCE;
        }
        this.members.put($Gson$Preconditions.checkNotNull(string), jsonElement);
    }

    public JsonElement remove(String string) {
        return this.members.remove(string);
    }

    public void addProperty(String string, String string2) {
        this.add(string, this.createJsonElement(string2));
    }

    public void addProperty(String string, Number number) {
        this.add(string, this.createJsonElement(number));
    }

    public void addProperty(String string, Boolean bl) {
        this.add(string, this.createJsonElement(bl));
    }

    public void addProperty(String string, Character c) {
        this.add(string, this.createJsonElement(c));
    }

    private JsonElement createJsonElement(Object object) {
        return object == null ? JsonNull.INSTANCE : new JsonPrimitive(object);
    }

    public Set<Map.Entry<String, JsonElement>> entrySet() {
        return this.members.entrySet();
    }

    public boolean has(String string) {
        return this.members.containsKey(string);
    }

    public JsonElement get(String string) {
        if (this.members.containsKey(string)) {
            JsonElement jsonElement = this.members.get(string);
            return jsonElement == null ? JsonNull.INSTANCE : jsonElement;
        }
        return null;
    }

    public JsonPrimitive getAsJsonPrimitive(String string) {
        return (JsonPrimitive)this.members.get(string);
    }

    public JsonArray getAsJsonArray(String string) {
        return (JsonArray)this.members.get(string);
    }

    public JsonObject getAsJsonObject(String string) {
        return (JsonObject)this.members.get(string);
    }

    public boolean equals(Object object) {
        return object == this || object instanceof JsonObject && ((JsonObject)object).members.equals(this.members);
    }

    public int hashCode() {
        return this.members.hashCode();
    }
}

