/*
 * Decompiled with CFR 0.152.
 */
package com.sun.swingset3.utilities;

import com.sun.swingset3.utilities.Utilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class GradientPanel
extends JPanel {
    private final Color[] colors = new Color[2];
    private Image image;

    public GradientPanel(Color color, Color color2) {
        this.setOpaque(false);
        this.setBackground(color);
        this.colors[0] = color;
        this.colors[1] = color2;
    }

    public void setGradientColor1(Color color) {
        this.changeGradientColor(0, color);
    }

    public void setGradientColor2(Color color) {
        this.changeGradientColor(1, color);
    }

    protected void changeGradientColor(int n, Color color) {
        Color color2 = this.colors[n];
        this.colors[n] = color;
        if (!color2.equals(color)) {
            this.image = null;
            this.firePropertyChange("gradientColor" + n, color2, color);
        }
    }

    protected Image getGradientImage() {
        Dimension dimension = this.getSize();
        if (this.image == null || this.image.getWidth(null) != dimension.width || this.image.getHeight(null) != dimension.height) {
            this.image = Utilities.createGradientImage(dimension.width, dimension.height, this.colors[0], this.colors[1]);
        }
        return this.image;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Image image = this.getGradientImage();
        graphics.drawImage(image, 0, 0, null);
        super.paintComponent(graphics);
    }

    public static class ChiselBorder
    implements Border {
        private Insets insets = new Insets(1, 0, 1, 0);

        @Override
        public Insets getBorderInsets(Component component) {
            return this.insets;
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            Color color = component.getBackground();
            graphics.setColor(Utilities.deriveColorHSB(color, 0.0f, 0.0f, 0.2f));
            graphics.drawLine(n, n2, n + n3, n2);
            graphics.setColor(Utilities.deriveColorHSB(color, 0.0f, 0.0f, -0.2f));
            graphics.drawLine(n, n2 + n4 - 1, n + n3, n2 + n4 - 1);
        }
    }
}

