/*
 * Decompiled with CFR 0.152.
 */
package de.babtec.globals;

import java.text.DecimalFormat;

public class HexUtils {
    static final String HEXES = "0123456789abcdef";

    public static String getString(byte[] byArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        DecimalFormat decimalFormat = new DecimalFormat("00");
        for (int i = 0; i < n2; ++i) {
            String string = Integer.toHexString(byArray[n + i] & 0xFF);
            if (string.length() == 1) {
                stringBuffer.append("0" + string);
                continue;
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public static String getString(byte[] byArray) {
        return HexUtils.getString(byArray, 0, byArray.length);
    }

    public static int getInt(String string) {
        if (string.startsWith("0x")) {
            string = string.substring(2);
        }
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            n += HexUtils.charToByte(string.charAt(i)) << (string.length() - 1 - i) * 4;
        }
        return n;
    }

    public static byte charToByte(char c) {
        if (c - 48 >= 0 && c - 48 <= 9) {
            return (byte)(c - 48);
        }
        switch (c) {
            case 'a': {
                return 10;
            }
            case 'b': {
                return 11;
            }
            case 'c': {
                return 12;
            }
            case 'd': {
                return 13;
            }
            case 'e': {
                return 14;
            }
            case 'f': {
                return 15;
            }
            case 'A': {
                return 10;
            }
            case 'B': {
                return 11;
            }
            case 'C': {
                return 12;
            }
            case 'D': {
                return 13;
            }
            case 'E': {
                return 14;
            }
            case 'F': {
                return 15;
            }
        }
        return 0;
    }

    public static char[] byteToChar(byte by) {
        char[] cArray = new char[2];
        byte by2 = (byte)((by & 0xF0) >> 4);
        byte by3 = (byte)(by & 0xF);
        if (by2 < 10) {
            cArray[0] = (char)(by2 + 48);
        } else {
            by2 = (byte)(by2 - 10);
            cArray[0] = (char)(by2 + 97);
        }
        if (by3 < 10) {
            cArray[1] = (char)(by3 + 48);
        } else {
            by3 = (byte)(by3 - 10);
            cArray[1] = (char)(by3 + 97);
        }
        return cArray;
    }

    public static byte[] getBytes(String string, int n) {
        return HexUtils.getBytes(string, new byte[n]);
    }

    public static byte[] getBytes(String string, byte[] byArray) {
        if ((string = string.trim()).startsWith("0x")) {
            string = string.substring(2);
        }
        for (int i = 0; i < (int)Math.floor(string.length()) && i < byArray.length; ++i) {
            byArray[i] = (byte)(HexUtils.charToByte(string.charAt(i * 2)) << 4);
            int n = i;
            byArray[n] = (byte)(byArray[n] | HexUtils.charToByte(string.charAt(i * 2 + 1)));
        }
        return byArray;
    }

    public static byte[] getBytes(Long l, int n) {
        return HexUtils.getBytes(l, new byte[n]);
    }

    public static byte[] getBytes(Long l, byte[] byArray) {
        for (int i = 0; i < 8; ++i) {
            byArray[i] = (byte)((l & (long)(255 << i * 8)) >> i * 8);
        }
        return byArray;
    }

    public static String bytesToHex(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (byte by : byArray) {
            String string = Integer.toString(by & 0xFF, 16);
            if (string.length() == 1) {
                stringBuffer.append("0");
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public static byte[] hexToBytes(String string) {
        if (string.length() % 2 != 0) {
            return null;
        }
        int n = string.length() / 2;
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = (byte)(HexUtils.charToByte(string.charAt(i * 2)) << 4 | HexUtils.charToByte(string.charAt(i * 2 + 1)));
        }
        return byArray;
    }

    public static String getHex(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(2 * byArray.length);
        for (byte by : byArray) {
            stringBuilder.append(HEXES.charAt((by & 0xF0) >> 4)).append(HEXES.charAt(by & 0xF));
        }
        return stringBuilder.toString();
    }
}

