/*
 * Decompiled with CFR 0.152.
 */
package de.babtec.globals;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.util.ArrayList;
import java.util.Collection;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;

public class MemoryWarningSystem {
    private final Collection<Listener> listeners = new ArrayList<Listener>();
    private static final MemoryPoolMXBean tenuredGenPool = MemoryWarningSystem.findTenuredGenPool();

    public MemoryWarningSystem() {
        MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
        NotificationEmitter notificationEmitter = (NotificationEmitter)((Object)memoryMXBean);
        notificationEmitter.addNotificationListener(new NotificationListener(){

            @Override
            public void handleNotification(Notification notification, Object object) {
                if (notification.getType().equals("java.management.memory.threshold.exceeded")) {
                    long l = tenuredGenPool.getUsage().getMax();
                    long l2 = tenuredGenPool.getUsage().getUsed();
                    for (Listener listener : MemoryWarningSystem.this.listeners) {
                        listener.memoryUsageLow(l2, l);
                    }
                }
            }
        }, null, null);
    }

    public boolean addListener(Listener listener) {
        return this.listeners.add(listener);
    }

    public boolean removeListener(Listener listener) {
        return this.listeners.remove(listener);
    }

    public static void setPercentageUsageThreshold(double d) {
        if (d <= 0.0 || d > 1.0) {
            throw new IllegalArgumentException("Percentage not in range");
        }
        long l = tenuredGenPool.getUsage().getMax();
        long l2 = (long)((double)l * d);
        tenuredGenPool.setUsageThreshold(l2);
    }

    private static MemoryPoolMXBean findTenuredGenPool() {
        for (MemoryPoolMXBean memoryPoolMXBean : ManagementFactory.getMemoryPoolMXBeans()) {
            if (memoryPoolMXBean.getType() != MemoryType.HEAP || !memoryPoolMXBean.isUsageThresholdSupported()) continue;
            return memoryPoolMXBean;
        }
        throw new AssertionError((Object)"Could not find tenured space");
    }

    public static interface Listener {
        public void memoryUsageLow(long var1, long var3);
    }
}

